package com.bizvane.openapifacade.yanzhiwu.vo;

import com.bizvane.openapifacade.utils.valid.EnumStringValue;
import com.bizvane.openapifacade.utils.valid.StringBrandCode;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.math.BigDecimal;

@Data
public class YMStaffSyncRequestVo {
    @NotEmpty
    @EnumStringValue(StringBrandCode.class)
    private String brandCode;
    /**
     * 员工code
     */
    @NotEmpty
    private String staffCode;

    /**
     * 员工姓名
     */
    private String staffName;

    /**
     * 线下店铺code
     */
    @NotEmpty
    private String storeCode;

    /**
     * 线下店铺姓名
     */
    private String storeName;

    /**
     * 国家区号默认+86
     */
    private String countryCode;

    /**
     * 手机号
     */
    @NotEmpty
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 性别 1.女 2.男 3.未知
     */
    private Integer sex;

    /**
     * 生日：yyyy-MM-dd
     */
    private String birthday;

    /**
     * 职务
     */
    private String position;

    /**
     * 状态 0.禁用 1.启用
     */
    private Integer status;
    /**
     * 入职时间
     */
    private String onDate;
    /**
     * 离职时间
     */
    private String offDate;
    /**
     * 更新时间
     */
    private String offlineUpdateDate;
    /**
     * 员工id
     */
    private String staffId;

}
