package com.bizvane.openapifacade.models.vo;

import com.bizvane.openapifacade.utils.valid.EnumStringValue;
import com.bizvane.openapifacade.utils.valid.StringBrandCode;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;

/**
 * @Author sampson
 * @Date 2021-01-27 14:09
 * @Describe
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class VGStoreRequestVO {

    /**
     * 品牌俱乐部code
     */
    @NotBlank(message = "品牌code不能为空")
    @EnumStringValue(StringBrandCode.class)
    private String brandCode;

    /**
     * 店铺code
     * */
    @NotBlank(message = "店铺code不能为空")
    private String storeCode;

    /**
     * 线下店铺ID
     */
    @NotBlank(message = "店铺ID不能为空")
    private String storeId;

    /**
     * 线下更新时间
     */
    private String offlineUpdateDate ;

    /**
     * 开店时间
     */
    private String onDate ;

    /**
     * 关店时间
     */
    private String offDate ;

    /**
     * 店铺名称
     * */
    private String storeName;

    /**
     * 店铺电话
     * */
    private String storePhone;

    /**
     * 经销商ID
     */
    private String distributorId;

    /**
     * 经销商名称
     */
    private String distributorName;

    /**
     * 店铺类型:10.直营 20.非直营 40.联营 50.加盟店
     * */
    private Integer storeType;

    /**
     * 店铺负责人(只存储，不做业务处理)
     * */
    private String storeOwner;

    /**
     * 店铺区域(支社)
     */
    private String bizArea;

    /**
     * 区长
     */
    private String areaOwner;

    /**
     * 店铺描述
     * */
    private String storeInfo;

    /**
     * 省
     * */
    private String province;

    /**
     * 市
     * */
    private String city;

    /**
     * 区县
     * */
    private String county;

    /**
     * 详细地址
     * */
    private String detailedAddress;

    /**
     * 经度
     * */
    private String lng;

    /**
     * 纬度
     * */
    private String lat;

    /**
     * 店铺营业时间(无规则)
     * */
    private String storeBusinessTime;

    /**
     * 10.线下 20.线上（天猫、京东）
     * */
    private Integer modelType;

    /**
     * 营业状态10：开店申请20：已开业 30：立项终止40：已撤除
     * */
    private Integer businessStatus;

    /**
     * 店铺面积（单位平方）
     * */
    private String storeSize;

    /**
     * 备注
     * */
    private String remark;

}
