package com.bizvane.openapifacade.models.vo;

import com.bizvane.openapifacade.utils.valid.EnumStringValue;
import com.bizvane.openapifacade.utils.valid.StringBrandCode;
import com.bizvane.openapifacade.utils.valid.ValidConstants;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

/**
 * @author jone
 * @since 2021/1/25
 */
@Data
public class VgMemberQueryRequestVo {
	@NotBlank(message = "品牌code不能为空")
	@EnumStringValue(StringBrandCode.class)
	private String brandCode;

	//    @Pattern(regexp = "^[1][2,3,4,5,6,7,8,9][0-9]{9}$", message = ValidConstants.PHONE_ERROR_MESSAGE)
	private String phone;
	private String cardNo;
	private String wxUnionId;

    @Override
    public String toString() {
        return "VgMemberQueryRequestVo{" +
                "brandCode='" + brandCode + '\'' +
                ", phone='" + phone + '\'' +
                ", cardNo='" + cardNo + '\'' +
                ", wxUnionId='" + wxUnionId + '\'' +
                '}';
    }
}
