package com.bizvane.openapifacade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;

/**
 * 361商品同步接口请求参数里的product
 * @author dingshichen
 */
@Data
public class SyncGood361 {

    @NotEmpty
    private String skuCode;
    @NotEmpty
    private String goodsCode;
    @NotEmpty
    private String stypeCode;
    @NotEmpty
    private String product;
    @NotEmpty
    private String productName;
    private String colorCode;
    private String colorDesc;
    private String sizeCode;
    private String sizeDesc;
    private String unit;
    private String priceSug;
    @NotEmpty
    private String productBrandCode;
    @NotEmpty
    private String productBrandDesc;
    private String firstCataCode;
    private String firstCataDesc;
    private String secondCataCode;
    private String secondCataDesc;
    private String thirdCataCode;
    private String thirdCataDesc;
    private String coatPantsCode;
    private String coatPantsDesc;
    private String groupCode;
    private String groupDesc;
    private String sonGroupCode;
    private String sonGroupDesc;
    private String genderCode;
    private String genderDesc;
    private String timeToMarket;
    private String year;
    private String seasonCode;
    private String seasonDesc;

    @ApiModelProperty(name = "commodityFabricCode", value = "商品面料成分代码")
    private String commodityFabricCode;
    @ApiModelProperty(name = "commodityStoryPackNameDescription", value = "商品面料成分代码")
    private String commodityStoryPackNameDescription;
    @ApiModelProperty(name = "commodityType", value = "商品面料成分代码")
    private String commodityType;
    @ApiModelProperty(name = "commodityIndustryField", value = "商品面料成分代码")
    private String commodityIndustryField;
    @ApiModelProperty(name = "commodityListingMonthSouth", value = "商品面料成分代码")
    private String commodityListingMonthSouth;
    @ApiModelProperty(name = "commodityMainPushCode", value = "商品面料成分代码")
    private String commodityMainPushCode;
    @ApiModelProperty(name = "commodityLover", value = "商品面料成分代码")
    private String commodityLover;
    @ApiModelProperty(name = "commodityAnnualSeason", value = "商品面料成分代码")
    private String commodityAnnualSeason;
    @ApiModelProperty(name = "commodityMainProduct", value = "商品面料成分代码")
    private String commodityMainProduct;
    @ApiModelProperty(name = "commodityColourSystem", value = "商品面料成分代码")
    private String commodityColourSystem;
    @ApiModelProperty(name = "commodityPriceSegment", value = "商品面料成分代码")
    private String commodityPriceSegment;
    @ApiModelProperty(name = "isCommodityCoupleSet", value = "商品面料成分代码")
    private String isCommodityCoupleSet;
    @ApiModelProperty(name = "commodityScienceAndTechnology", value = "商品面料成分代码")
    private String commodityScienceAndTechnology;
    @ApiModelProperty(name = "commodityLaunchTimeNorth", value = "商品面料成分代码")
    private String commodityLaunchTimeNorth;
    @ApiModelProperty(name = "commoditySpecialChannel", value = "商品面料成分代码")
    private String commoditySpecialChannel;
    @ApiModelProperty(name = "commodityEventName", value = "商品面料成分代码")
    private String commodityEventName;
    @ApiModelProperty(name = "commodityDomesticSalesNumber", value = "商品面料成分代码")
    private String commodityDomesticSalesNumber;
    @ApiModelProperty(name = "commodityFashionDegree", value = "商品面料成分代码")
    private String commodityFashionDegree;
    @ApiModelProperty(name = "commodityLaunchTimeSouth", value = "商品面料成分代码")
    private String commodityLaunchTimeSouth;
    @ApiModelProperty(name = "commodityMarketablePeriod", value = "商品面料成分代码")
    private String commodityMarketablePeriod;
    @ApiModelProperty(name = "commodityDegreeOfSpecialization", value = "商品面料成分代码")
    private String commodityDegreeOfSpecialization;
    @ApiModelProperty(name = "commodityTopRecommended", value = "商品面料成分代码")
    private String commodityTopRecommended;

    @ApiModelProperty(value = "品牌描述", name = "commodityBrandDesc")
    private String commodityBrandDesc;

    @ApiModelProperty(value = "商品故事包", name = "commodityStoryPackName")
    private String commodityStoryPackName;

    @ApiModelProperty(value = "商品适合的年龄结构", name = "commodityAgeGroup")
    private String commodityAgeGroup;

    @ApiModelProperty(value = "商品成分", name = "commodityComposition")
    private String commodityComposition;

    @ApiModelProperty(value = "商品面料", name = "commodityFabric")
    private String commodityFabric;
}
