package com.bizvane.openapifacade.ur;


import lombok.Data;

import javax.validation.constraints.NotEmpty;

/**
 * ur-定制导购新增和修改
 */
@Data
public class URStaffSyncRequestVo {
    /**
     * 员工id(等于标准员工code)
     */
    @NotEmpty
    private String staffId;

    /**
     * 员工姓名
     */
    private String staffName;

    /**
     * 线下店铺id(d等于标准线下店铺code)
     */
    private String storeId;

    /**
     * 线下店铺姓名
     */
    private String storeName;

    /**
     * 国家区号默认+86
     */
    private String countryCode;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 性别 1.女 2.男 3.未知
     */
    private Integer sex;

    /**
     * 生日：yyyy-MM-dd
     */
    private String birthday;

    /**
     * 职务
     */
    private String position;

    /**
     * 状态 0.禁用 1.启用
     */
    private Integer status;
}
