package com.bizvane.openapifacade.models.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.List;


/**
 * @author baofeng@bizvane.cn
 * @createTime 2021-10-18 10:32:38
 * @description: 优惠券查询条件对象
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponQueryDTO {
    @ApiModelProperty(name = "cardCode", value = "会员卡号", required = true, example = "")
    @NotBlank(message = "会员卡号不能为空")
    private String cardCode;
    
    @ApiModelProperty(name = "couponCode", value = "券号")
    private String couponCode;

    @ApiModelProperty(name = "brandId", value = "品牌ID", required = false, example = "")
    @NotNull(message = "品牌ID不能为空")
    @Min(value = 0)
    private Long brandId;

    @ApiModelProperty(name = "corpId", value = "企业ID,即sysCompanyId", required = false, example = "")
    @Min(value = 0)
    private Long corpId;

    @ApiModelProperty(name = "status", value = "5-线上绑定，10-同步中，11-同步失败，12-同步成功，20-未使用，25-已过期，30-已核销", required = false, example = "")
    private Integer status;

    @ApiModelProperty(name = "couponDefinitionIdList", value = "券定义id集合")
    private List<Long> couponDefinitionIdList;

    @ApiModelProperty(name = "preferentialType", value = "优惠类型：现金=1,折扣=2,兑换=3", required = false, example = "")
    private Byte preferentialType;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;

    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;



}
