package com.bizvane.openapifacade.models.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class CouponDefinitionURVO {

    /**
     * 券定义id
     */
    private String thqId;

    /**
     * 券类型号
     */
    private String erpCouponDefinitionCode;

    /**
     * 券名
     */
    private String thqName;

    /**
     * 有效期类型：1-日期区间，2-领取后X天有效，3-仅限会员生日当天使用，4-仅限会员生日当月使用 5 领取后X天生效 效期X天
     */
    private Byte validType;

    /**
     * 开始日期yyyy-MM-dd hh:mm:ss
     */
    private String startDate;

    /**
     * 结束日期yyyy-MM-dd hh:mm:ss
     */
    private String endDate;

    /**
     * 有效天数
     */
    private Integer effectiveDays;

    /**
     * 领取X天后生效
     */
    private Integer delayDay;

    /**
     * 领取X天后有效期N天
     */
    private Integer delayValidDay;
    /**
     * 备注
     */
    private String ms;

    /**
     * 是否叠加促销(0-不叠加，1-叠加)
     */
    private Byte noStackPromotion;

    /**
     * 是否叠加券
     */
    private Byte noStackCardNo;

    /**
     * 使用金额
     */
    private BigDecimal Amount;

    /**
     * 最低消费金额
     */
    private BigDecimal MinAmount;

    /**
     * 是否有效
     */
    private String  isactive;

    /**
     * 券描述
     */

    private  String info;
    
    private Long couponDefinitionId;
}
