package com.bizvane.openapifacade.models.bo;


import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class CouponDefinitionBo {

    private String companyCode;///所属企业编号
    private Long sysBrandId;//所属品牌id
    private String brandCode;//所属品牌编号
   // private String couponDefinitionCode;//券编号
    private Byte useChannel;//渠道限制（仅线下1）
    private Byte couponDefinitionType;//券定义类型：1-线上定义，2-erp生成
    private String erpCouponDefinitionCode;//线下券类型号
    private String couponName;//券名称
    private Byte preferentialType;//优惠类型（1现金，2折扣，3兑换）
    private BigDecimal money;//当优惠类型为1时：券的面额
    private BigDecimal discount;//当优惠类型为2时：券的折扣
    private Byte validType;//有效期类型：1-日期区间，2-领取后X天有效，3-仅限会员生日当天使用，4-仅限会员生日当月使用 5 领取后X天生效 效期X天
    private Date validDateStart;//有效期开始时间
    private Date validDateEnd;//有效期结束时间
    private Integer validDay;//有效天数
    private BigDecimal minConsume;//最低消费金额(满减金额)
    private String info;//描述. info(使用说明)
    private Integer minCommodityNum;//当优惠类型为2时：商品数量最低限制
    private BigDecimal maxPreferential;//当优惠类型为2时：最高优惠金额
    private String isTransfer;//是否允许转赠（1允许转赠，0不允许转赠）-----
    private String transferSend;//转增后1核销送券，0不送券----
    private Long transferCouponDefinitionId;//转增后要发的券定义id
    private String transferInfo;//转增说明
    private Byte applianceStoreType;//适用门店类型：1-全部适用，2-部分适用
    private String storeWhitelist;//当适用门店为2时：白名单店
    private String storeBlacklist;//当适用门店为2时：黑名单店
    private Byte applianceCommodityType;//适用商品类型：1-全部适用，2-部分适用
    private String commodityWhitelist;//当适用商品类型为2时：商品单一白名单
    private String commodityBlacklist;//当适用商品类型为2时：商品黑名单
    private String commodityCompoundWhitelist;//当适用商品类型为2时：商品复合白名单
    private String isAddTemplate;//添加到券自定义模板(1是，0否)----
    private Byte activitySuperpositionType;//活动叠加条件：1-不允许叠加其他活动使用，2-允许叠加其他活动使用，3-允许部分活动使用
    private String activitySuperpositionWhiteList;//当活动叠加条件为3时：活动叠加白名单
    private String activitySuperpositionBlackList;//当活动叠加条件为3时：活动叠加黑名单
    private String  isSuperposition;//是否允许叠加（1是，0否）----
    private Byte couponSuperpositionType;//券叠加条件(1-不允许叠加其他券使用  2-允许叠加其他券使用)
    private BigDecimal minDiscount;//整单最低折扣限制
    private String transferFission;//可裂变1，不可以0 --


//    String addinterfaceAll2 = "couponDefinite,燕之屋券定义,/openapi.api/yanzhiwu/coupon/couponDefinition";
//    String addParamList12 = "companyCode,所属企业code&sysBrandId,所属品牌id&brandCode,所属品牌编号" +
//            "&useChannel,渠道限制&couponDefinitionType,券定义类型&erpCouponDefinitionCode，线下券类型号" +
//            "&couponName,券名称&preferentialType,优惠类型&money,券的面额&discount,券的折扣" +
//            "&validType,有效期类型&validDateStart,有效期开始时间&validDateEnd,有效期结束时间" +
//            "&validDay,有效天数&minConsume,最低消费金额&info,描述&minCommodityNum,商品数量最低限制" +
//            "&maxPreferential,最高优惠金额&isTransfer,是否允许转赠&transferSend,转增后核销送券&transferCouponDefinitionId,转增后要发的券定义id" +
//            "&transferInfo,转增说明&applianceStoreType,适用门店类型&storeWhitelist,白名单店&storeBlacklist,黑名单店" +
//            "&applianceCommodityType,适用商品类型&commodityWhitelist,商品单一白名单&commodityBlacklist,商品黑名单&commodityCompoundWhitelist,商品复合白名单" +
//            "&isAddTemplate,添加到券自定义模板&activitySuperpositionType,活动叠加条件&activitySuperpositionWhiteList,活动叠加白名单&storactivitySuperpositionBlackListeBlacklist,活动叠加黑名单" +
//            "&isSuperposition,是否允许叠加&couponSuperpositionType,券叠加条件&minDiscount,整单最低折扣限制&transferFission,裂变";

}
