package com.bizvane.openapifacade.yanzhiwu.vo;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@Data
public class YMStoreSyncRequestVo {

    /**
     * 品牌code
     */
    @NotEmpty
    private String brandCode;

    /**
     * 店铺code
     * */
    @NotEmpty
    private String storeCode;

    /**
     * 店铺名称
     * */
    private String storeName;

    /**
     * 店铺电话
     * */
    private String storePhone;

    /**
     * 店铺类型:10.直营 20.非直营 40.联营 50.加盟店
     * */
    private Integer storeType;

    /**
     * 店铺负责人(只存储，不做业务处理)
     * */
    private String storeOwner;

    /**
     * 店铺描述
     * */
    private String storeInfo;

    /**
     * 省
     * */
    private String province;

    /**
     * 市
     * */
    private String city;

    /**
     * 区县
     * */
    private String county;

    /**
     * 详细地址
     * */
    private String detailedAddress;

    /**
     * 经度
     * */
    private String lng;

    /**
     * 纬度
     * */
    private String lat;

    /**
     * 店铺营业时间(无规则)
     * */
    private String storeBusinessTime;

    /**
     * 10.线下 20.线上（天猫、京东）
     * */
    private Integer modelType;

    /**
     * 营业状态10：开店申请20：已开业 30：立项终止40：已撤除
     * */
    private Integer businessStatus;

    /**
     * 店铺面积（单位平方）
     * */
    private String storeSize;

    /**
     * 线下区域
     */
    private String bizArea;//线下区域


    /**
     * 所属经销商公司名
     */
    private String distributorName;

    /**
     * 备注
     * */
    private String remark;

    /**
     * 线下组织code
     * */
    private String offlineOrgCode;

}
