package com.bizvane.openapifacade.models.vo;

import lombok.Data;

import javax.validation.constraints.NotEmpty;

/**
 * @author lijiachun
 */
@Data
public class ByCardNoCoupon361ReqVO {

    /**
     * 品牌code
     */
    @NotEmpty
    private String brandCode;

    /**
     * 会员卡号
     */
    private String cardNo;

    /**
     * 会员唯一标识
     */
    private String erpId;

    /**
     * 会员手机号
     */
    private String phone;

    /**
     * 券状态 20-未使用，25-已过期，30-已核销
     */
    private String status;

    /**
     * 当前页码,默认第一页
     */
    private Integer pageNo = 1;

    /**
     * 每页显示条数,每页最大200条,默认10条
     */
    private Integer pageSize = 10;
}
