package com.bizvane.openapifacade.interfaces;


import com.bizvane.openapifacade.yanzhiwu.vo.CommonOpenCardRequestVo;
import com.bizvane.openapifacade.yanzhiwu.vo.CommonOpenCardResponseVo;
import com.bizvane.utils.commonutils.FeignConfig;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


import javax.validation.Valid;

@FeignClient(value = "${feign.client.openapi.name}", path = "${feign.client.openapi.path}",configuration = FeignConfig.class)
public interface CommonMemberServiceFeign {

    @PostMapping("/common/member/openCard")
    ResponseData<CommonOpenCardResponseVo> openCard(@RequestBody @Valid CommonOpenCardRequestVo requestVo);
}
