/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapifacade.models.vo;

import com.bizvane.openapifacade.models.vo.VGOrderUsedCouponVO;
import com.bizvane.openapifacade.models.vo.VGOrderUsedDetailVO;
import com.bizvane.openapifacade.models.vo.VGOrderUsedPaymentVO;
import com.bizvane.openapifacade.utils.valid.EnumStringValue;
import com.bizvane.openapifacade.utils.valid.StringBrandCode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import org.springframework.beans.BeanUtils;
import org.springframework.format.annotation.DateTimeFormat;

public class VGOrderRequestVO {
    @NotBlank(message="\u54c1\u724ccode\u4e0d\u80fd\u4e3a\u7a7a")
    @EnumStringValue(value=StringBrandCode.class)
    private @NotBlank(message="\u54c1\u724ccode\u4e0d\u80fd\u4e3a\u7a7a") String brandCode;
    @Min(value=1L)
    @Max(value=3L)
    @NotNull(message="\u8ba2\u5355\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c1-\u8ba2\u5355\uff0c2-\u662f\u9000\u5355\uff0c3-\u6362\u8d27\u5355")
    private @Min(value=1L) @Max(value=3L) @NotNull(message="\u8ba2\u5355\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c1-\u8ba2\u5355\uff0c2-\u662f\u9000\u5355\uff0c3-\u6362\u8d27\u5355") Integer orderFlag;
    private String cardNo;
    @NotBlank(message="\u8ba2\u5355\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a")
    private @NotBlank(message="\u8ba2\u5355\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a") String orderNo;
    @Min(value=1L)
    @Max(value=3L)
    @NotNull(message="\u8ba2\u5355\u6765\u6e90\u4e0d\u5141\u8bb8\u4e3a\u7a7a")
    private @Min(value=1L) @Max(value=3L) @NotNull(message="\u8ba2\u5355\u6765\u6e90\u4e0d\u5141\u8bb8\u4e3a\u7a7a") Integer orderFrom;
    @Past(message="\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u65f6\u95f4")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @NotNull(message="\u4e0b\u5355\u65f6\u95f4\u4e0d\u5141\u8bb8\u683c\u5f0f\u4e0d\u5bf9,eg: 2020-01-01 10:00:00")
    private @Past(message="\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u65f6\u95f4") @NotNull(message="\u4e0b\u5355\u65f6\u95f4\u4e0d\u5141\u8bb8\u683c\u5f0f\u4e0d\u5bf9,eg: 2020-01-01 10:00:00") Date placeOrderTime;
    private String phone;
    private String originalOrderNo;
    private String currentLevelCode;
    @NotNull(message="\u540a\u724c\u4ef7\u4e0d\u5141\u8bb8\u4e3a\u7a7a")
    private @NotNull(message="\u540a\u724c\u4ef7\u4e0d\u5141\u8bb8\u4e3a\u7a7a") BigDecimal commodityAmount;
    @NotNull(message="\u5b9e\u9645\u4ef7\u683c\u4e0d\u5141\u8bb8\u4e3a\u7a7a")
    private @NotNull(message="\u5b9e\u9645\u4ef7\u683c\u4e0d\u5141\u8bb8\u4e3a\u7a7a") BigDecimal tradeAmount;
    private BigDecimal preferentialAmount;
    private BigDecimal deductibleAmount;
    private BigDecimal otherPreferentialAmount;
    private Date payTime;
    private Date billTime;
    private BigDecimal payMoney;
    private Integer usedIntegral;
    private Integer getIntegral;
    @NotNull(message="\u5546\u54c1\u6570\u91cf\u4e0d\u5141\u8bb8\u4e3a\u7a7a")
    private @NotNull(message="\u5546\u54c1\u6570\u91cf\u4e0d\u5141\u8bb8\u4e3a\u7a7a") Integer productCount;
    private Date sendTime;
    private String storeCode;
    private List<VGOrderUsedCouponVO> couponInfos;
    private List<VGOrderUsedDetailVO> orderDetails;
    private List<VGOrderUsedPaymentVO> orderPayMents;
    private String buyerRemark;
    private String remark;
    private String orderGuideIds;
    private String orderGuideNames;
    private Long sysCompanyId;
    private String storeName;
    private String serviceStoreSite;

    public VGOrderRequestVO deepCopy() {
        List<VGOrderUsedCouponVO> thisCoupons;
        VGOrderRequestVO vo = new VGOrderRequestVO();
        BeanUtils.copyProperties((Object)this, (Object)vo);
        List<VGOrderUsedDetailVO> thisDetails = this.getOrderDetails();
        if (thisDetails != null && thisDetails.size() > 0) {
            ArrayList<VGOrderUsedDetailVO> detailVOList = new ArrayList<VGOrderUsedDetailVO>();
            for (int i = 0; i < thisDetails.size(); ++i) {
                VGOrderUsedDetailVO detailVO = new VGOrderUsedDetailVO();
                BeanUtils.copyProperties((Object)thisDetails.get(i), (Object)detailVO);
                detailVOList.add(detailVO);
            }
            vo.setOrderDetails(detailVOList);
        }
        if ((thisCoupons = this.getCouponInfos()) != null && thisCoupons.size() > 0) {
            ArrayList<VGOrderUsedCouponVO> couponVOList = new ArrayList<VGOrderUsedCouponVO>();
            for (int i = 0; i < couponVOList.size(); ++i) {
                VGOrderUsedCouponVO couponVO = new VGOrderUsedCouponVO();
                BeanUtils.copyProperties(couponVOList.get(i), (Object)couponVO);
                thisCoupons.add(couponVO);
            }
            vo.setCouponInfos(couponVOList);
        }
        return vo;
    }

    public static VGOrderRequestVOBuilder builder() {
        return new VGOrderRequestVOBuilder();
    }

    public VGOrderRequestVO(String brandCode, Integer orderFlag, String cardNo, String orderNo, Integer orderFrom, Date placeOrderTime, String phone, String originalOrderNo, String currentLevelCode, BigDecimal commodityAmount, BigDecimal tradeAmount, BigDecimal preferentialAmount, BigDecimal deductibleAmount, BigDecimal otherPreferentialAmount, Date payTime, Date billTime, BigDecimal payMoney, Integer usedIntegral, Integer getIntegral, Integer productCount, Date sendTime, String storeCode, List<VGOrderUsedCouponVO> couponInfos, List<VGOrderUsedDetailVO> orderDetails, List<VGOrderUsedPaymentVO> orderPayMents, String buyerRemark, String remark, String orderGuideIds, String orderGuideNames, Long sysCompanyId, String storeName, String serviceStoreSite) {
        this.brandCode = brandCode;
        this.orderFlag = orderFlag;
        this.cardNo = cardNo;
        this.orderNo = orderNo;
        this.orderFrom = orderFrom;
        this.placeOrderTime = placeOrderTime;
        this.phone = phone;
        this.originalOrderNo = originalOrderNo;
        this.currentLevelCode = currentLevelCode;
        this.commodityAmount = commodityAmount;
        this.tradeAmount = tradeAmount;
        this.preferentialAmount = preferentialAmount;
        this.deductibleAmount = deductibleAmount;
        this.otherPreferentialAmount = otherPreferentialAmount;
        this.payTime = payTime;
        this.billTime = billTime;
        this.payMoney = payMoney;
        this.usedIntegral = usedIntegral;
        this.getIntegral = getIntegral;
        this.productCount = productCount;
        this.sendTime = sendTime;
        this.storeCode = storeCode;
        this.couponInfos = couponInfos;
        this.orderDetails = orderDetails;
        this.orderPayMents = orderPayMents;
        this.buyerRemark = buyerRemark;
        this.remark = remark;
        this.orderGuideIds = orderGuideIds;
        this.orderGuideNames = orderGuideNames;
        this.sysCompanyId = sysCompanyId;
        this.storeName = storeName;
        this.serviceStoreSite = serviceStoreSite;
    }

    public VGOrderRequestVO() {
    }

    public String getBrandCode() {
        return this.brandCode;
    }

    public Integer getOrderFlag() {
        return this.orderFlag;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public Integer getOrderFrom() {
        return this.orderFrom;
    }

    public Date getPlaceOrderTime() {
        return this.placeOrderTime;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getOriginalOrderNo() {
        return this.originalOrderNo;
    }

    public String getCurrentLevelCode() {
        return this.currentLevelCode;
    }

    public BigDecimal getCommodityAmount() {
        return this.commodityAmount;
    }

    public BigDecimal getTradeAmount() {
        return this.tradeAmount;
    }

    public BigDecimal getPreferentialAmount() {
        return this.preferentialAmount;
    }

    public BigDecimal getDeductibleAmount() {
        return this.deductibleAmount;
    }

    public BigDecimal getOtherPreferentialAmount() {
        return this.otherPreferentialAmount;
    }

    public Date getPayTime() {
        return this.payTime;
    }

    public Date getBillTime() {
        return this.billTime;
    }

    public BigDecimal getPayMoney() {
        return this.payMoney;
    }

    public Integer getUsedIntegral() {
        return this.usedIntegral;
    }

    public Integer getGetIntegral() {
        return this.getIntegral;
    }

    public Integer getProductCount() {
        return this.productCount;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public String getStoreCode() {
        return this.storeCode;
    }

    public List<VGOrderUsedCouponVO> getCouponInfos() {
        return this.couponInfos;
    }

    public List<VGOrderUsedDetailVO> getOrderDetails() {
        return this.orderDetails;
    }

    public List<VGOrderUsedPaymentVO> getOrderPayMents() {
        return this.orderPayMents;
    }

    public String getBuyerRemark() {
        return this.buyerRemark;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getOrderGuideIds() {
        return this.orderGuideIds;
    }

    public String getOrderGuideNames() {
        return this.orderGuideNames;
    }

    public Long getSysCompanyId() {
        return this.sysCompanyId;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getServiceStoreSite() {
        return this.serviceStoreSite;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public void setOrderFlag(Integer orderFlag) {
        this.orderFlag = orderFlag;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public void setOrderFrom(Integer orderFrom) {
        this.orderFrom = orderFrom;
    }

    public void setPlaceOrderTime(Date placeOrderTime) {
        this.placeOrderTime = placeOrderTime;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setOriginalOrderNo(String originalOrderNo) {
        this.originalOrderNo = originalOrderNo;
    }

    public void setCurrentLevelCode(String currentLevelCode) {
        this.currentLevelCode = currentLevelCode;
    }

    public void setCommodityAmount(BigDecimal commodityAmount) {
        this.commodityAmount = commodityAmount;
    }

    public void setTradeAmount(BigDecimal tradeAmount) {
        this.tradeAmount = tradeAmount;
    }

    public void setPreferentialAmount(BigDecimal preferentialAmount) {
        this.preferentialAmount = preferentialAmount;
    }

    public void setDeductibleAmount(BigDecimal deductibleAmount) {
        this.deductibleAmount = deductibleAmount;
    }

    public void setOtherPreferentialAmount(BigDecimal otherPreferentialAmount) {
        this.otherPreferentialAmount = otherPreferentialAmount;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public void setBillTime(Date billTime) {
        this.billTime = billTime;
    }

    public void setPayMoney(BigDecimal payMoney) {
        this.payMoney = payMoney;
    }

    public void setUsedIntegral(Integer usedIntegral) {
        this.usedIntegral = usedIntegral;
    }

    public void setGetIntegral(Integer getIntegral) {
        this.getIntegral = getIntegral;
    }

    public void setProductCount(Integer productCount) {
        this.productCount = productCount;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public void setCouponInfos(List<VGOrderUsedCouponVO> couponInfos) {
        this.couponInfos = couponInfos;
    }

    public void setOrderDetails(List<VGOrderUsedDetailVO> orderDetails) {
        this.orderDetails = orderDetails;
    }

    public void setOrderPayMents(List<VGOrderUsedPaymentVO> orderPayMents) {
        this.orderPayMents = orderPayMents;
    }

    public void setBuyerRemark(String buyerRemark) {
        this.buyerRemark = buyerRemark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setOrderGuideIds(String orderGuideIds) {
        this.orderGuideIds = orderGuideIds;
    }

    public void setOrderGuideNames(String orderGuideNames) {
        this.orderGuideNames = orderGuideNames;
    }

    public void setSysCompanyId(Long sysCompanyId) {
        this.sysCompanyId = sysCompanyId;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public void setServiceStoreSite(String serviceStoreSite) {
        this.serviceStoreSite = serviceStoreSite;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VGOrderRequestVO)) {
            return false;
        }
        VGOrderRequestVO other = (VGOrderRequestVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$brandCode = this.getBrandCode();
        String other$brandCode = other.getBrandCode();
        if (this$brandCode == null ? other$brandCode != null : !this$brandCode.equals(other$brandCode)) {
            return false;
        }
        Integer this$orderFlag = this.getOrderFlag();
        Integer other$orderFlag = other.getOrderFlag();
        if (this$orderFlag == null ? other$orderFlag != null : !((Object)this$orderFlag).equals(other$orderFlag)) {
            return false;
        }
        String this$cardNo = this.getCardNo();
        String other$cardNo = other.getCardNo();
        if (this$cardNo == null ? other$cardNo != null : !this$cardNo.equals(other$cardNo)) {
            return false;
        }
        String this$orderNo = this.getOrderNo();
        String other$orderNo = other.getOrderNo();
        if (this$orderNo == null ? other$orderNo != null : !this$orderNo.equals(other$orderNo)) {
            return false;
        }
        Integer this$orderFrom = this.getOrderFrom();
        Integer other$orderFrom = other.getOrderFrom();
        if (this$orderFrom == null ? other$orderFrom != null : !((Object)this$orderFrom).equals(other$orderFrom)) {
            return false;
        }
        Date this$placeOrderTime = this.getPlaceOrderTime();
        Date other$placeOrderTime = other.getPlaceOrderTime();
        if (this$placeOrderTime == null ? other$placeOrderTime != null : !((Object)this$placeOrderTime).equals(other$placeOrderTime)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        String this$originalOrderNo = this.getOriginalOrderNo();
        String other$originalOrderNo = other.getOriginalOrderNo();
        if (this$originalOrderNo == null ? other$originalOrderNo != null : !this$originalOrderNo.equals(other$originalOrderNo)) {
            return false;
        }
        String this$currentLevelCode = this.getCurrentLevelCode();
        String other$currentLevelCode = other.getCurrentLevelCode();
        if (this$currentLevelCode == null ? other$currentLevelCode != null : !this$currentLevelCode.equals(other$currentLevelCode)) {
            return false;
        }
        BigDecimal this$commodityAmount = this.getCommodityAmount();
        BigDecimal other$commodityAmount = other.getCommodityAmount();
        if (this$commodityAmount == null ? other$commodityAmount != null : !((Object)this$commodityAmount).equals(other$commodityAmount)) {
            return false;
        }
        BigDecimal this$tradeAmount = this.getTradeAmount();
        BigDecimal other$tradeAmount = other.getTradeAmount();
        if (this$tradeAmount == null ? other$tradeAmount != null : !((Object)this$tradeAmount).equals(other$tradeAmount)) {
            return false;
        }
        BigDecimal this$preferentialAmount = this.getPreferentialAmount();
        BigDecimal other$preferentialAmount = other.getPreferentialAmount();
        if (this$preferentialAmount == null ? other$preferentialAmount != null : !((Object)this$preferentialAmount).equals(other$preferentialAmount)) {
            return false;
        }
        BigDecimal this$deductibleAmount = this.getDeductibleAmount();
        BigDecimal other$deductibleAmount = other.getDeductibleAmount();
        if (this$deductibleAmount == null ? other$deductibleAmount != null : !((Object)this$deductibleAmount).equals(other$deductibleAmount)) {
            return false;
        }
        BigDecimal this$otherPreferentialAmount = this.getOtherPreferentialAmount();
        BigDecimal other$otherPreferentialAmount = other.getOtherPreferentialAmount();
        if (this$otherPreferentialAmount == null ? other$otherPreferentialAmount != null : !((Object)this$otherPreferentialAmount).equals(other$otherPreferentialAmount)) {
            return false;
        }
        Date this$payTime = this.getPayTime();
        Date other$payTime = other.getPayTime();
        if (this$payTime == null ? other$payTime != null : !((Object)this$payTime).equals(other$payTime)) {
            return false;
        }
        Date this$billTime = this.getBillTime();
        Date other$billTime = other.getBillTime();
        if (this$billTime == null ? other$billTime != null : !((Object)this$billTime).equals(other$billTime)) {
            return false;
        }
        BigDecimal this$payMoney = this.getPayMoney();
        BigDecimal other$payMoney = other.getPayMoney();
        if (this$payMoney == null ? other$payMoney != null : !((Object)this$payMoney).equals(other$payMoney)) {
            return false;
        }
        Integer this$usedIntegral = this.getUsedIntegral();
        Integer other$usedIntegral = other.getUsedIntegral();
        if (this$usedIntegral == null ? other$usedIntegral != null : !((Object)this$usedIntegral).equals(other$usedIntegral)) {
            return false;
        }
        Integer this$getIntegral = this.getGetIntegral();
        Integer other$getIntegral = other.getGetIntegral();
        if (this$getIntegral == null ? other$getIntegral != null : !((Object)this$getIntegral).equals(other$getIntegral)) {
            return false;
        }
        Integer this$productCount = this.getProductCount();
        Integer other$productCount = other.getProductCount();
        if (this$productCount == null ? other$productCount != null : !((Object)this$productCount).equals(other$productCount)) {
            return false;
        }
        Date this$sendTime = this.getSendTime();
        Date other$sendTime = other.getSendTime();
        if (this$sendTime == null ? other$sendTime != null : !((Object)this$sendTime).equals(other$sendTime)) {
            return false;
        }
        String this$storeCode = this.getStoreCode();
        String other$storeCode = other.getStoreCode();
        if (this$storeCode == null ? other$storeCode != null : !this$storeCode.equals(other$storeCode)) {
            return false;
        }
        List<VGOrderUsedCouponVO> this$couponInfos = this.getCouponInfos();
        List<VGOrderUsedCouponVO> other$couponInfos = other.getCouponInfos();
        if (this$couponInfos == null ? other$couponInfos != null : !((Object)this$couponInfos).equals(other$couponInfos)) {
            return false;
        }
        List<VGOrderUsedDetailVO> this$orderDetails = this.getOrderDetails();
        List<VGOrderUsedDetailVO> other$orderDetails = other.getOrderDetails();
        if (this$orderDetails == null ? other$orderDetails != null : !((Object)this$orderDetails).equals(other$orderDetails)) {
            return false;
        }
        List<VGOrderUsedPaymentVO> this$orderPayMents = this.getOrderPayMents();
        List<VGOrderUsedPaymentVO> other$orderPayMents = other.getOrderPayMents();
        if (this$orderPayMents == null ? other$orderPayMents != null : !((Object)this$orderPayMents).equals(other$orderPayMents)) {
            return false;
        }
        String this$buyerRemark = this.getBuyerRemark();
        String other$buyerRemark = other.getBuyerRemark();
        if (this$buyerRemark == null ? other$buyerRemark != null : !this$buyerRemark.equals(other$buyerRemark)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        String this$orderGuideIds = this.getOrderGuideIds();
        String other$orderGuideIds = other.getOrderGuideIds();
        if (this$orderGuideIds == null ? other$orderGuideIds != null : !this$orderGuideIds.equals(other$orderGuideIds)) {
            return false;
        }
        String this$orderGuideNames = this.getOrderGuideNames();
        String other$orderGuideNames = other.getOrderGuideNames();
        if (this$orderGuideNames == null ? other$orderGuideNames != null : !this$orderGuideNames.equals(other$orderGuideNames)) {
            return false;
        }
        Long this$sysCompanyId = this.getSysCompanyId();
        Long other$sysCompanyId = other.getSysCompanyId();
        if (this$sysCompanyId == null ? other$sysCompanyId != null : !((Object)this$sysCompanyId).equals(other$sysCompanyId)) {
            return false;
        }
        String this$storeName = this.getStoreName();
        String other$storeName = other.getStoreName();
        if (this$storeName == null ? other$storeName != null : !this$storeName.equals(other$storeName)) {
            return false;
        }
        String this$serviceStoreSite = this.getServiceStoreSite();
        String other$serviceStoreSite = other.getServiceStoreSite();
        return !(this$serviceStoreSite == null ? other$serviceStoreSite != null : !this$serviceStoreSite.equals(other$serviceStoreSite));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VGOrderRequestVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $brandCode = this.getBrandCode();
        result = result * 59 + ($brandCode == null ? 43 : $brandCode.hashCode());
        Integer $orderFlag = this.getOrderFlag();
        result = result * 59 + ($orderFlag == null ? 43 : ((Object)$orderFlag).hashCode());
        String $cardNo = this.getCardNo();
        result = result * 59 + ($cardNo == null ? 43 : $cardNo.hashCode());
        String $orderNo = this.getOrderNo();
        result = result * 59 + ($orderNo == null ? 43 : $orderNo.hashCode());
        Integer $orderFrom = this.getOrderFrom();
        result = result * 59 + ($orderFrom == null ? 43 : ((Object)$orderFrom).hashCode());
        Date $placeOrderTime = this.getPlaceOrderTime();
        result = result * 59 + ($placeOrderTime == null ? 43 : ((Object)$placeOrderTime).hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        String $originalOrderNo = this.getOriginalOrderNo();
        result = result * 59 + ($originalOrderNo == null ? 43 : $originalOrderNo.hashCode());
        String $currentLevelCode = this.getCurrentLevelCode();
        result = result * 59 + ($currentLevelCode == null ? 43 : $currentLevelCode.hashCode());
        BigDecimal $commodityAmount = this.getCommodityAmount();
        result = result * 59 + ($commodityAmount == null ? 43 : ((Object)$commodityAmount).hashCode());
        BigDecimal $tradeAmount = this.getTradeAmount();
        result = result * 59 + ($tradeAmount == null ? 43 : ((Object)$tradeAmount).hashCode());
        BigDecimal $preferentialAmount = this.getPreferentialAmount();
        result = result * 59 + ($preferentialAmount == null ? 43 : ((Object)$preferentialAmount).hashCode());
        BigDecimal $deductibleAmount = this.getDeductibleAmount();
        result = result * 59 + ($deductibleAmount == null ? 43 : ((Object)$deductibleAmount).hashCode());
        BigDecimal $otherPreferentialAmount = this.getOtherPreferentialAmount();
        result = result * 59 + ($otherPreferentialAmount == null ? 43 : ((Object)$otherPreferentialAmount).hashCode());
        Date $payTime = this.getPayTime();
        result = result * 59 + ($payTime == null ? 43 : ((Object)$payTime).hashCode());
        Date $billTime = this.getBillTime();
        result = result * 59 + ($billTime == null ? 43 : ((Object)$billTime).hashCode());
        BigDecimal $payMoney = this.getPayMoney();
        result = result * 59 + ($payMoney == null ? 43 : ((Object)$payMoney).hashCode());
        Integer $usedIntegral = this.getUsedIntegral();
        result = result * 59 + ($usedIntegral == null ? 43 : ((Object)$usedIntegral).hashCode());
        Integer $getIntegral = this.getGetIntegral();
        result = result * 59 + ($getIntegral == null ? 43 : ((Object)$getIntegral).hashCode());
        Integer $productCount = this.getProductCount();
        result = result * 59 + ($productCount == null ? 43 : ((Object)$productCount).hashCode());
        Date $sendTime = this.getSendTime();
        result = result * 59 + ($sendTime == null ? 43 : ((Object)$sendTime).hashCode());
        String $storeCode = this.getStoreCode();
        result = result * 59 + ($storeCode == null ? 43 : $storeCode.hashCode());
        List<VGOrderUsedCouponVO> $couponInfos = this.getCouponInfos();
        result = result * 59 + ($couponInfos == null ? 43 : ((Object)$couponInfos).hashCode());
        List<VGOrderUsedDetailVO> $orderDetails = this.getOrderDetails();
        result = result * 59 + ($orderDetails == null ? 43 : ((Object)$orderDetails).hashCode());
        List<VGOrderUsedPaymentVO> $orderPayMents = this.getOrderPayMents();
        result = result * 59 + ($orderPayMents == null ? 43 : ((Object)$orderPayMents).hashCode());
        String $buyerRemark = this.getBuyerRemark();
        result = result * 59 + ($buyerRemark == null ? 43 : $buyerRemark.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        String $orderGuideIds = this.getOrderGuideIds();
        result = result * 59 + ($orderGuideIds == null ? 43 : $orderGuideIds.hashCode());
        String $orderGuideNames = this.getOrderGuideNames();
        result = result * 59 + ($orderGuideNames == null ? 43 : $orderGuideNames.hashCode());
        Long $sysCompanyId = this.getSysCompanyId();
        result = result * 59 + ($sysCompanyId == null ? 43 : ((Object)$sysCompanyId).hashCode());
        String $storeName = this.getStoreName();
        result = result * 59 + ($storeName == null ? 43 : $storeName.hashCode());
        String $serviceStoreSite = this.getServiceStoreSite();
        result = result * 59 + ($serviceStoreSite == null ? 43 : $serviceStoreSite.hashCode());
        return result;
    }

    public String toString() {
        return "VGOrderRequestVO(brandCode=" + this.getBrandCode() + ", orderFlag=" + this.getOrderFlag() + ", cardNo=" + this.getCardNo() + ", orderNo=" + this.getOrderNo() + ", orderFrom=" + this.getOrderFrom() + ", placeOrderTime=" + this.getPlaceOrderTime() + ", phone=" + this.getPhone() + ", originalOrderNo=" + this.getOriginalOrderNo() + ", currentLevelCode=" + this.getCurrentLevelCode() + ", commodityAmount=" + this.getCommodityAmount() + ", tradeAmount=" + this.getTradeAmount() + ", preferentialAmount=" + this.getPreferentialAmount() + ", deductibleAmount=" + this.getDeductibleAmount() + ", otherPreferentialAmount=" + this.getOtherPreferentialAmount() + ", payTime=" + this.getPayTime() + ", billTime=" + this.getBillTime() + ", payMoney=" + this.getPayMoney() + ", usedIntegral=" + this.getUsedIntegral() + ", getIntegral=" + this.getGetIntegral() + ", productCount=" + this.getProductCount() + ", sendTime=" + this.getSendTime() + ", storeCode=" + this.getStoreCode() + ", couponInfos=" + this.getCouponInfos() + ", orderDetails=" + this.getOrderDetails() + ", orderPayMents=" + this.getOrderPayMents() + ", buyerRemark=" + this.getBuyerRemark() + ", remark=" + this.getRemark() + ", orderGuideIds=" + this.getOrderGuideIds() + ", orderGuideNames=" + this.getOrderGuideNames() + ", sysCompanyId=" + this.getSysCompanyId() + ", storeName=" + this.getStoreName() + ", serviceStoreSite=" + this.getServiceStoreSite() + ")";
    }

    public static class VGOrderRequestVOBuilder {
        private String brandCode;
        private Integer orderFlag;
        private String cardNo;
        private String orderNo;
        private Integer orderFrom;
        private Date placeOrderTime;
        private String phone;
        private String originalOrderNo;
        private String currentLevelCode;
        private BigDecimal commodityAmount;
        private BigDecimal tradeAmount;
        private BigDecimal preferentialAmount;
        private BigDecimal deductibleAmount;
        private BigDecimal otherPreferentialAmount;
        private Date payTime;
        private Date billTime;
        private BigDecimal payMoney;
        private Integer usedIntegral;
        private Integer getIntegral;
        private Integer productCount;
        private Date sendTime;
        private String storeCode;
        private List<VGOrderUsedCouponVO> couponInfos;
        private List<VGOrderUsedDetailVO> orderDetails;
        private List<VGOrderUsedPaymentVO> orderPayMents;
        private String buyerRemark;
        private String remark;
        private String orderGuideIds;
        private String orderGuideNames;
        private Long sysCompanyId;
        private String storeName;
        private String serviceStoreSite;

        VGOrderRequestVOBuilder() {
        }

        public VGOrderRequestVOBuilder brandCode(String brandCode) {
            this.brandCode = brandCode;
            return this;
        }

        public VGOrderRequestVOBuilder orderFlag(Integer orderFlag) {
            this.orderFlag = orderFlag;
            return this;
        }

        public VGOrderRequestVOBuilder cardNo(String cardNo) {
            this.cardNo = cardNo;
            return this;
        }

        public VGOrderRequestVOBuilder orderNo(String orderNo) {
            this.orderNo = orderNo;
            return this;
        }

        public VGOrderRequestVOBuilder orderFrom(Integer orderFrom) {
            this.orderFrom = orderFrom;
            return this;
        }

        public VGOrderRequestVOBuilder placeOrderTime(Date placeOrderTime) {
            this.placeOrderTime = placeOrderTime;
            return this;
        }

        public VGOrderRequestVOBuilder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public VGOrderRequestVOBuilder originalOrderNo(String originalOrderNo) {
            this.originalOrderNo = originalOrderNo;
            return this;
        }

        public VGOrderRequestVOBuilder currentLevelCode(String currentLevelCode) {
            this.currentLevelCode = currentLevelCode;
            return this;
        }

        public VGOrderRequestVOBuilder commodityAmount(BigDecimal commodityAmount) {
            this.commodityAmount = commodityAmount;
            return this;
        }

        public VGOrderRequestVOBuilder tradeAmount(BigDecimal tradeAmount) {
            this.tradeAmount = tradeAmount;
            return this;
        }

        public VGOrderRequestVOBuilder preferentialAmount(BigDecimal preferentialAmount) {
            this.preferentialAmount = preferentialAmount;
            return this;
        }

        public VGOrderRequestVOBuilder deductibleAmount(BigDecimal deductibleAmount) {
            this.deductibleAmount = deductibleAmount;
            return this;
        }

        public VGOrderRequestVOBuilder otherPreferentialAmount(BigDecimal otherPreferentialAmount) {
            this.otherPreferentialAmount = otherPreferentialAmount;
            return this;
        }

        public VGOrderRequestVOBuilder payTime(Date payTime) {
            this.payTime = payTime;
            return this;
        }

        public VGOrderRequestVOBuilder billTime(Date billTime) {
            this.billTime = billTime;
            return this;
        }

        public VGOrderRequestVOBuilder payMoney(BigDecimal payMoney) {
            this.payMoney = payMoney;
            return this;
        }

        public VGOrderRequestVOBuilder usedIntegral(Integer usedIntegral) {
            this.usedIntegral = usedIntegral;
            return this;
        }

        public VGOrderRequestVOBuilder getIntegral(Integer getIntegral) {
            this.getIntegral = getIntegral;
            return this;
        }

        public VGOrderRequestVOBuilder productCount(Integer productCount) {
            this.productCount = productCount;
            return this;
        }

        public VGOrderRequestVOBuilder sendTime(Date sendTime) {
            this.sendTime = sendTime;
            return this;
        }

        public VGOrderRequestVOBuilder storeCode(String storeCode) {
            this.storeCode = storeCode;
            return this;
        }

        public VGOrderRequestVOBuilder couponInfos(List<VGOrderUsedCouponVO> couponInfos) {
            this.couponInfos = couponInfos;
            return this;
        }

        public VGOrderRequestVOBuilder orderDetails(List<VGOrderUsedDetailVO> orderDetails) {
            this.orderDetails = orderDetails;
            return this;
        }

        public VGOrderRequestVOBuilder orderPayMents(List<VGOrderUsedPaymentVO> orderPayMents) {
            this.orderPayMents = orderPayMents;
            return this;
        }

        public VGOrderRequestVOBuilder buyerRemark(String buyerRemark) {
            this.buyerRemark = buyerRemark;
            return this;
        }

        public VGOrderRequestVOBuilder remark(String remark) {
            this.remark = remark;
            return this;
        }

        public VGOrderRequestVOBuilder orderGuideIds(String orderGuideIds) {
            this.orderGuideIds = orderGuideIds;
            return this;
        }

        public VGOrderRequestVOBuilder orderGuideNames(String orderGuideNames) {
            this.orderGuideNames = orderGuideNames;
            return this;
        }

        public VGOrderRequestVOBuilder sysCompanyId(Long sysCompanyId) {
            this.sysCompanyId = sysCompanyId;
            return this;
        }

        public VGOrderRequestVOBuilder storeName(String storeName) {
            this.storeName = storeName;
            return this;
        }

        public VGOrderRequestVOBuilder serviceStoreSite(String serviceStoreSite) {
            this.serviceStoreSite = serviceStoreSite;
            return this;
        }

        public VGOrderRequestVO build() {
            return new VGOrderRequestVO(this.brandCode, this.orderFlag, this.cardNo, this.orderNo, this.orderFrom, this.placeOrderTime, this.phone, this.originalOrderNo, this.currentLevelCode, this.commodityAmount, this.tradeAmount, this.preferentialAmount, this.deductibleAmount, this.otherPreferentialAmount, this.payTime, this.billTime, this.payMoney, this.usedIntegral, this.getIntegral, this.productCount, this.sendTime, this.storeCode, this.couponInfos, this.orderDetails, this.orderPayMents, this.buyerRemark, this.remark, this.orderGuideIds, this.orderGuideNames, this.sysCompanyId, this.storeName, this.serviceStoreSite);
        }

        public String toString() {
            return "VGOrderRequestVO.VGOrderRequestVOBuilder(brandCode=" + this.brandCode + ", orderFlag=" + this.orderFlag + ", cardNo=" + this.cardNo + ", orderNo=" + this.orderNo + ", orderFrom=" + this.orderFrom + ", placeOrderTime=" + this.placeOrderTime + ", phone=" + this.phone + ", originalOrderNo=" + this.originalOrderNo + ", currentLevelCode=" + this.currentLevelCode + ", commodityAmount=" + this.commodityAmount + ", tradeAmount=" + this.tradeAmount + ", preferentialAmount=" + this.preferentialAmount + ", deductibleAmount=" + this.deductibleAmount + ", otherPreferentialAmount=" + this.otherPreferentialAmount + ", payTime=" + this.payTime + ", billTime=" + this.billTime + ", payMoney=" + this.payMoney + ", usedIntegral=" + this.usedIntegral + ", getIntegral=" + this.getIntegral + ", productCount=" + this.productCount + ", sendTime=" + this.sendTime + ", storeCode=" + this.storeCode + ", couponInfos=" + this.couponInfos + ", orderDetails=" + this.orderDetails + ", orderPayMents=" + this.orderPayMents + ", buyerRemark=" + this.buyerRemark + ", remark=" + this.remark + ", orderGuideIds=" + this.orderGuideIds + ", orderGuideNames=" + this.orderGuideNames + ", sysCompanyId=" + this.sysCompanyId + ", storeName=" + this.storeName + ", serviceStoreSite=" + this.serviceStoreSite + ")";
        }
    }
}

