package com.bizvane.openapifacade.models.vo;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
public class CommonMemberPerfectRequestVo {

    /*
		品牌编号
	 */
    @NotEmpty
    private String brandCode;

    /*
        请求来源:1.POS(门店) 2.官网3 4.微信 5.天猫 6.其他
     */
    @NotEmpty
    private String source;

    /*
        线下id
     */
    @NotEmpty
    private String erpId;

    /*
        服务门店
     */
    private String newServerStoreCode;

    /**
     * 服务导购
     */
    private String newServerGuideCode;

    /*
        会员姓名
     */
    private String newName;

    /*
        会员手机号
     */
    private String newPhone;

    /*
        会员性别（1女、2男、3，未知，默认未知）
     */
    private String newSex;

    /*
        省
     */
    private String newProvince;

    /*
        市
     */
    private String newCity;

    /*
        区
     */
    private String newCounty;

    /*
        会员详细地址
     */
    private String newAddress;

    /*
        备注
     */
    private String newRemark;

    /*
        会员邮箱
     */
    private String newEmail;

    /*
        会员身份证号
     */
    private String newIdCard;

    /*
        会员生日 格式：yyyy-MM-dd
     */
    private String newBirthday;

    /*
        会员卡状态1 有效 0无效
     */
    private String newValid;

    /*
        等级code
     */
    private String newLevelCode;

    /*
        亲属关系
     */
    private List<MemberPerfectRelatiive> relations;



    String addinterfaceAll1 = "openCard,燕之屋会员开卡,/openapi.api/yanzhiwu/member/openCard";
    String addParamList11 = "brandCode,品牌code&phone,手机号&cardNo,会员卡号&name,会员名称&sex,性别&province,省&city,市&county,区&address,会员详细地址&remark,备注&email,会员邮箱&idCard,会员身份证" +
            "&birthday,会员生日&storeCode,注册门店&levelCode,会员等级code&registerType,会员注册渠道&points,可用积分&unionId,微信unionId&valid,会员卡状态&erpId,会员唯一标志";

    String addinterfaceAll2 = "memberQuery,燕之屋会员查询,/openapi.api/yanzhiwu/member/queryMember";
    String addParamList12 = "brandCode,品牌code&erpId,会员唯一标志&phone,手机号&wxUnionId,会员unionId";

    String addinterfaceAll3 = "memberPerfect,燕之屋完善资料,/openapi.api/yanzhiwu/member/memberPerfect";
    String addParamList13 = "brandCode,品牌code&source,请求来源&erpId,会员唯一标志&newName,会员姓名&newPhone,会员手机号&newSex,会员性别&newProvince,省&newCity,市&newCounty,区&newAddress,会员地址&newRemark,备注" +
            "&newEmail,会员邮箱&newIdCard,会员身份证&newBirthday,会员生日&newLevelCode,会员等级code&newServerStoreCode,会员服务门店&newValid,会员是否可用&relations,亲属关系";
    /**
     * 非开放平台调用接口参数
     */
    private Long sysCompanyId;

}
