package com.bizvane.openapifacade.models.vo;

import lombok.Data;

import javax.validation.constraints.NotEmpty;

/**
 * <p>
 * 361积分调整接口请求参数Model
 * </p>
 * @author dingShiChen
 * @since 2019/10/15
 */
@Data
public class IntegralAdjust361RequestVO {

	/*
		线下积分变更流水号
	 */
	@NotEmpty
	private String serialNumber;

	/*
		品牌code
	 */
	@NotEmpty
	private String brandCode;

	/*
		会员手机号
	 */
	@NotEmpty
	private String phone;

	/*
		会员卡号
	 */
	private String cardNo;

	/*
		线下id
	 */
	@NotEmpty
	private String erpId;

	/*
		变更积分数 如果是扣减 则为负数
	 */
	@NotEmpty
	private String changeIntegral;

	/*
		积分来源:1.POS(门店) 2.官网3.商城 4.微信 5.天猫 6.其他
	 */
	@NotEmpty
	private String source;

	/*
		店铺Code
	 */
	private String storeCode;

	/*
		变更单据
	 */
	private String changeBills;

	/*
		变更说明
	 */
	private String changeRemark;

	/*
		积分调整业务场景code，详情见表t_mbr_integral_record_business_type
	 */
	private String businessWay;

	/*
	 	变更时间（yyyy-MM-dd HH:mm:ss）
	 */
	private String changeTime;
}
