package com.bizvane.openapifacade.models.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * <p>
 * 361会员完善资料接口请求参数model
 * </p>
 * @author dingShiChen
 * @since 2019/10/15
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class MemberPerfectDataRequestVO {

	/*
		品牌编号
	 */
	@NotEmpty
	private String brandCode;

	/*
		请求来源:1.POS(门店) 2.官网3 4.微信 5.天猫 6.其他 7.EHR
	 */
	@NotEmpty
	private String source;

	/*
		会员原始手机号
	 */
	private String phone;

	/*
		会员卡号
 	*/
	private String cardNo;

	/*
		线下id
 	*/
	@NotEmpty
	private String erpId;

	/*
		服务门店
	 */
	private String newServerStoreCode;

	/*
		会员姓名
	 */
	private String newName;

	/*
		会员手机号
	 */
	private String newPhone;

	/*
		会员性别（1女、2男、3，未知，默认未知）
	 */
	private String newSex;

	/*
		省
	 */
	private String newProvince;

	/*
		市
	 */
	private String newCity;

	/*
		区
	 */
	private String newCounty;

	/*
		会员详细地址
	 */
	private String newAddress;

	/*
		备注
	 */
	private String newRemark;

	/*
		会员邮箱
	 */
	private String newEmail;

	/*
		会员身份证号
	 */
	private String newIdCard;

	/*
		会员生日 格式：yyyy-MM-dd
	 */
	private String newBirthday;

	/*
		VIP卡状态，0：未激活、1：激活、2：停用、3：挂失、4：冻结
	 */
	private String newStatus;

	/*
		等级code
	 */
	private String newLevelCode;

	/*
		亲属关系
	 */
	private List<MemberPerfectRelatiive> relations;



	String addinterfaceAll1 = "openCard,燕之屋会员开卡,/openapi.api/yanzhiwu/member/openCard";
	String addParamList11 = "brandCode,品牌code&phone,手机号&cardNo,会员卡号&name,会员名称&sex,性别&province,省&city,市&county,区&address,会员详细地址&remark,备注&email,会员邮箱&idCard,会员身份证" +
			"&birthday,会员生日&storeCode,注册门店&levelCode,会员等级code&registerType,会员注册渠道&points,可用积分&unionId,微信unionId&valid,会员卡状态&erpId,会员唯一标志";

	String addinterfaceAll2 = "memberQuery,燕之屋会员查询,/openapi.api/yanzhiwu/member/queryMember";
	String addParamList12 = "brandCode,品牌code&erpId,会员唯一标志&phone,手机号&wxUnionId,会员unionId";

	String addinterfaceAll3 = "memberPerfect,燕之屋完善资料,/openapi.api/yanzhiwu/member/memberPerfect";
	String addParamList13 = "brandCode,品牌code&source,请求来源&phone,手机号&cardNo,卡号&erpId,会员唯一标志";
}
