package com.bizvane.openapifacade.models.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 券定义vo
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年08月29日 11:48:00
 */
@Data
public class CouponDefVo implements Serializable {



    @io.swagger.annotations.ApiModelProperty(value = "券编号", name = "couponDefinitionCode", required = false, example = "")
    private String couponDefinitionCode;


    @io.swagger.annotations.ApiModelProperty(value = "券定义类型：1-线上定义，2-erp生成", name = "couponDefinitionType", required = false, example = "")
    private Byte couponDefinitionType;


    @io.swagger.annotations.ApiModelProperty(value = "线下券类型号", name = "erpCouponDefinitionCode", required = false, example = "")
    private String erpCouponDefinitionCode;

    @io.swagger.annotations.ApiModelProperty(value = "券名称", name = "couponName", required = false, example = "")
    private String couponName;

    @io.swagger.annotations.ApiModelProperty(value = "渠道限制（1仅线下，2全渠道，3仅线上，4员工券，5天猫券）", name = "useChannel", required = false, example = "")
    private Byte useChannel;



    @io.swagger.annotations.ApiModelProperty(value = "是否允许转赠（1允许转赠，0不允许转赠）", name = "isTransfer", required = false, example = "")
    private Boolean isTransfer;


    @io.swagger.annotations.ApiModelProperty(value = "是否允许叠加（1是，0否）", name = "isSuperposition", required = false, example = "")
    private Boolean isSuperposition;



    @io.swagger.annotations.ApiModelProperty(value = "最低消费金额(满减金额)", name = "minConsume", required = false, example = "")
    private BigDecimal minConsume;

    @io.swagger.annotations.ApiModelProperty(value = "最高优惠金额", name = "maxPreferential", required = false, example = "")
    private BigDecimal maxPreferential;

    @io.swagger.annotations.ApiModelProperty(value = "商品数量最低限制", name = "minCommodityNum", required = false, example = "")
    private Integer minCommodityNum;

    @io.swagger.annotations.ApiModelProperty(value = "商品数量最高限制", name = "maxCommodityNum", required = false, example = "")
    private Integer maxCommodityNum;

    @io.swagger.annotations.ApiModelProperty(value = "整单最低折扣限制", name = "minDiscount", required = false, example = "")
    private BigDecimal minDiscount;


    @io.swagger.annotations.ApiModelProperty(value = "适用商品类型：1-全部适用，2-部分适用, 3-商品属性", name = "applianceCommodityType", required = false, example = "")
    private Byte applianceCommodityType;



    @io.swagger.annotations.ApiModelProperty(value = "适用门店类型：1-全部适用，2-部分适用", name = "applianceStoreType", required = false, example = "")
    private Byte applianceStoreType;

    @io.swagger.annotations.ApiModelProperty(value = "描述", name = "info", required = false, example = "")
    private String info;


    @io.swagger.annotations.ApiModelProperty(value = "券叠加条件(1-不允许叠加其他券使用  2-允许叠加其他券使用)", name = "couponSuperpositionType", required = false, example = "")
    private Byte couponSuperpositionType;


    @io.swagger.annotations.ApiModelProperty(value = "商品单一白名单", name = "commodityWhitelist", required = false, example = "")
    private String commodityWhitelist;

    @io.swagger.annotations.ApiModelProperty(value = "商品黑名单", name = "commodityBlacklist", required = false, example = "")
    private String commodityBlacklist;

    @io.swagger.annotations.ApiModelProperty(value = "线下商品code", name = "offlinePrdCode", required = false, example = "")
    private String offlinePrdCode;

    @io.swagger.annotations.ApiModelProperty(value = "门店黑名单", name = "storeWhitelist", required = false, example = "")
    private String storeWhitelist;

    @io.swagger.annotations.ApiModelProperty(value = "门店黑名单", name = "storeBlacklist", required = false, example = "")
    private String storeBlacklist;

    @io.swagger.annotations.ApiModelProperty(value = "商品复合白名单", name = "commodityCompoundWhitelist", required = false, example = "")
    private String commodityCompoundWhitelist;

    private static final long serialVersionUID = 1L;
}
