package com.bizvane.openapifacade.models.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @author lijiachun
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponByCard361ListResVO {

    /**
     * 券定义id
     */
   private Long couponDefinitionId;

    /**
     * 券code
     */
   private String couponCode;

    /**
     * 券名称
     */
   private String 	couponName;

    /**
     * 券类型（1现金，2折扣，3礼品）
     */
   private String preferentialType;

    /**
     * 会员code
     */
   private String memberCode;

    /**
     * 券有效开日期
     */
   private String validDateStart;

    /**
     * 券有效结束日期
     */
   private String validDateEnd;

    /**
     * 券面额
     */
   private BigDecimal money;

    /**
     * 券折扣
     */
   private BigDecimal discount;

    /**
     * 券描述
     */
   private String info;

    /**
     * 券使用类型 :1.线上 2.线下
     */
   private Integer useType;

    /**
     * 使用门店code
     */
   private String useStoreCode;

    /**
     * 使用订单号
     */
   private String useBusinessOrder;

    /**
     * 使用订单号金额
     */
   private BigDecimal useBusinessOrderAmount;

    /**
     * 使用时间
     */
   private String useTime;

    /**
     * 券状态:20.未使用,25:已过,30:已核销
     */
   private Integer couponStatus;

    /**
     * 是否使用:0.未使用,1:已使用
     */
   private Integer isUse;

    /**
     * 转增状态:0.未转增,1:已转增）
     */
   private Integer give;

    /**
     * 是否锁定
     */
   private Integer isLock;
}
