package com.bizvane.openapifacade.rpc;

import com.bizvane.openapifacade.models.vo.*;
import com.bizvane.openapifacade.yanzhiwu.vo.CommonOpenCardResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 第三方会员通rpc
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年08月12日 18:41:00
 */
@FeignClient(value = "${feign.client.openapi.name}",path = "${feign.client.openapi.path}/third")
public interface ThirdFeignRpc {

    @PostMapping(value = "/member/openCard")
    ResponseData<ThirdOpenCardResponseVo> openCard(@RequestBody @Valid ThirdOpenCardReqVo requestVo);

    @PostMapping(value = "/member/memberPerfect")
    ResponseData<MemberPerfectDataResponseVO> memberPerfect(@RequestBody @Valid CommonMemberPerfectRequestVo requestApiVo);

    @PostMapping(value = "/order/addCommonOrder")
    ResponseData<String> addCommonOrder(@RequestBody @Valid CommonOrderRequestApiVo requestApiVo);
}
