package com.bizvane.openapifacade.yanzhiwu.vo;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@Data
public class CommonOpenCardRequestVo {
    @NotEmpty
    private String brandCode;//	是	string	品牌
    @NotEmpty
    private String phone;//	是	string	手机号

    private String cardNo;//	是	string	会员卡号
    private String name;    //否	string	会员名称
    private Integer sex;    //否	int	性别 : 1.女 2.男 3.未知
    private String province;//	否	string	省
    private String city;//	否	string	市
    private String county;//	否	string	区
    private String address;//	否	string	会员详细地址
    private String remark;//	否	string	备注
    private String email;//	否	string	会员邮箱
    private String idCard;//	否	string	会员身份证号
    private String birthday;//	否	string	会员生日 格式 : yyyy-mm-dd
    private String storeCode;//	否	string	注册门店code,如果为空则默认按照中台配置的会员卡体系为准
    private String levelCode;//	否	string	会员等级code,如果为空则默认按照中台配置的会员卡体系为准

    //guideCode
    private String guideCode;//否 string 导购code,如果为空则默认按照中台配置的会员卡体系为准

    @NotNull
    private Integer source;//	是	int	会员注册渠道 : 1.POS(门店) 2.官网3.商城 4.微信 5.天猫 6.其他
    private Integer points;//	否	int	会员可用积分,如果为空则默认为0
    private String unionId;//	否	string	微信unionId
    private Integer valid;//	否	int	会员卡状态 : 0.禁用 1.可用,默认为1
    @NotEmpty
    private String erpId;// 否 string erpId

//    String addinterfaceAll1 = "openCard,燕之屋会员开卡,/openapi.api/yanzhiwu/member/openCard";
//    String addParamList11 = "brandCode,品牌code&phone,手机号&cardNo,会员卡号&name,会员名称&sex,性别&province,省&city,市&county,区&address,会员详细地址&remark,备注&email,会员邮箱&idCard,会员身份证" +
//            "&birthday,会员生日&storeCode,注册门店&levelCode,会员等级code&registerType,会员注册渠道&points,可用积分&unionId,微信unionId&valid,会员卡状态&erpId,会员唯一标志";


    String addinterfaceAll1 = "openCard,燕之屋会员开卡,/openapi.api/yanzhiwu/member/openCard";
    String addParamList11 = "brandCode,品牌code&phone,手机号&cardNo,会员卡号&name,会员名称&sex,性别&province,省&city,市&county,区&address,会员详细地址&remark,备注&email,会员邮箱&idCard,会员身份证" +
            "&birthday,会员生日&storeCode,注册门店&guideCode,注册导购&levelCode,会员等级code&source,会员注册渠道&points,可用积分&unionId,微信unionId&valid,会员卡状态&erpId,会员唯一标志";

    String addinterfaceAll2 = "memberQuery,燕之屋会员查询,/openapi.api/yanzhiwu/member/queryMember";
    String addParamList12 = "brandCode,品牌code&erpId,会员唯一标志&phone,手机号&wxUnionId,会员unionId";
    
    private Long sysCompanyId;
    
    

}
