package com.bizvane.openapifacade.interfaces;

import com.bizvane.openapifacade.models.vo.CommonOrderRequestApiVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

/**
 * Created by admin on 2019/10/14.
 */
@FeignClient(value = "${feign.client.openapi.name}", path = "${feign.client.openapi.path}/common/order")
@Api(tags = {"订单接口"}, description = "")
public interface CommonOrderServiceFeign {

    /**
     * 保存订单接口
     * @param requestApiVo
     * @return
     */
    @PostMapping(value = "/addCommonOrder")
    ResponseData<String> addCommonOrder(@RequestBody @Valid CommonOrderRequestApiVo requestApiVo, HttpServletRequest request);


}


