package com.bizvane.openapifacade.interfaces;

import com.bizvane.openapifacade.models.vo.CommonOrderRequestApiVo;
import com.bizvane.openapifacade.models.vo.IntegralAdjustYmRequestVO;
import com.bizvane.openapifacade.yanzhiwu.vo.CommonOpenCardRequestVo;
import com.bizvane.openapifacade.yanzhiwu.vo.CommonOpenCardResponseVo;
import com.bizvane.openapifacade.yanzhiwu.vo.YMStaffSyncRequestVo;
import com.bizvane.openapifacade.yanzhiwu.vo.YMStoreSyncRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

/**
 * 内部调用会员标准开卡rpc接口
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年07月02日 17:14:00
 */
@FeignClient(value = "${feign.client.openapi.name}",path = "${feign.client.openapi.path}/common")
public interface CommonFeignRpc {


    @PostMapping(value = "/member/openCard")
    ResponseData<CommonOpenCardResponseVo> openCard(@RequestBody @Valid CommonOpenCardRequestVo requestVo, HttpServletRequest request);

    @PostMapping(value = "/order/addCommonOrder")
    ResponseData<String> addCommonOrder(@RequestBody @Valid CommonOrderRequestApiVo requestApiVo, HttpServletRequest request);

    @PostMapping(value = "/staff/syncStaff")
    ResponseData addStaffInfo(@RequestBody @Valid YMStaffSyncRequestVo requestVo, HttpServletRequest request);

    @PostMapping(value = "/store/syncStore")
    ResponseData addAndUpdateStoreInfo(@RequestBody @Valid YMStoreSyncRequestVo requestVo, HttpServletRequest request);

    @PostMapping(value = "/integral/integralAdjust")
    ResponseData integralAdjust(@RequestBody @Valid IntegralAdjustYmRequestVO vo, HttpServletRequest request);
}
