/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.quickbi.openapi.core.util;

import com.alibaba.quickbi.openapi.core.OpenAPIHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPILoggerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPILoggerUtils.class);
    private static final String LOG_PATTERN_NORMAL = "[traceId: %s]-[%s#%s#L%s] --> Msg: %s";

    private static int getLine() {
        return Thread.currentThread().getStackTrace()[4].getLineNumber();
    }

    private static String getMethodName() {
        return Thread.currentThread().getStackTrace()[4].getMethodName();
    }

    private static String getClassName() {
        return Thread.currentThread().getStackTrace()[4].getClassName();
    }

    private static String format(String msg) {
        String traceId = OpenAPIHolder.getTraceId();
        return String.format(LOG_PATTERN_NORMAL, traceId, OpenAPILoggerUtils.getClassName(), OpenAPILoggerUtils.getMethodName(), OpenAPILoggerUtils.getLine(), msg);
    }

    public static void info(String message, String ... args) {
        message = String.format(message, args);
        if (LOGGER.isInfoEnabled()) {
            String msg = OpenAPILoggerUtils.format(message);
            LOGGER.info(msg);
        }
    }

    public static void info(String message) {
        if (LOGGER.isInfoEnabled()) {
            String msg = OpenAPILoggerUtils.format(message);
            LOGGER.info(msg);
        }
    }

    public static void debug(String message) {
        if (LOGGER.isDebugEnabled()) {
            String msg = OpenAPILoggerUtils.format(message);
            LOGGER.debug(msg);
        }
    }

    public static void debug(String message, String ... args) {
        message = String.format(message, args);
        if (LOGGER.isDebugEnabled()) {
            String msg = OpenAPILoggerUtils.format(message);
            LOGGER.debug(msg);
        }
    }

    public static void debug(String message, Exception e) {
        if (LOGGER.isDebugEnabled()) {
            String msg = OpenAPILoggerUtils.format(message);
            LOGGER.debug(msg, (Throwable)e);
        }
    }

    public static void error(Exception e) {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error(null, (Throwable)e);
        }
    }

    public static void error(String message) {
        if (LOGGER.isErrorEnabled()) {
            String msg = OpenAPILoggerUtils.format(message);
            LOGGER.error(msg);
        }
    }

    public static void error(String message, String ... args) {
        message = String.format(message, args);
        if (LOGGER.isErrorEnabled()) {
            String msg = OpenAPILoggerUtils.format(message);
            LOGGER.error(msg);
        }
    }

    public static void error(Exception e, String message) {
        if (LOGGER.isErrorEnabled()) {
            String msg = OpenAPILoggerUtils.format(message);
            LOGGER.error(msg, (Throwable)e);
        }
    }

    public static void error(Exception e, String message, String ... args) {
        message = String.format(message, args);
        if (LOGGER.isErrorEnabled()) {
            String msg = OpenAPILoggerUtils.format(message);
            LOGGER.error(msg, (Throwable)e);
        }
    }
}

