/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.quickbi.openapi.common.signature;

import com.alibaba.quickbi.openapi.common.exception.SignatureException;
import com.alibaba.quickbi.openapi.core.util.Sha256Util;
import com.alibaba.quickbi.openapi.core.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;

public class SignatureUtil {
    private static final String SK_PREFIX = "quickbi-auth-v1/%s/%s";

    public static String buildStringToSign(String uri, String method, Map<String, String> parameters, Map<String, String> headers) {
        String headerString;
        String queryString;
        if (StringUtils.isEmpty(uri) || StringUtils.isEmpty(method)) {
            throw new IllegalArgumentException("input parameter error, uri or method can not be null");
        }
        uri = uri.replace("+", " ");
        StringBuilder sb = new StringBuilder();
        sb.append(method.toUpperCase());
        sb.append("\n");
        sb.append(uri);
        sb.append("\n");
        if (null != parameters && parameters.size() > 0 && StringUtils.isNotEmpty(queryString = SignatureUtil.buildSortedString(parameters, "=", "&"))) {
            sb.append(queryString);
            sb.append("\n");
        }
        if (null != headers && headers.size() > 0 && StringUtils.isNotEmpty(headerString = SignatureUtil.buildSortedString(headers, ":", "\n"))) {
            sb.append(headerString);
        }
        return sb.toString();
    }

    public static String buildSignSecretKey(String ak, String sk, Long expireTime) throws SignatureException {
        String accessKeyPrefix = String.format(SK_PREFIX, ak, expireTime);
        try {
            return Sha256Util.sha256(accessKeyPrefix, sk);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SignatureException("buildSignSecretKey error", e);
        }
    }

    public static String sign(String stringToSign, String secretKey) throws SignatureException {
        if (null == stringToSign || null == secretKey) {
            throw new IllegalArgumentException("input parameter error");
        }
        try {
            String encodeString = SignatureUtil.percentEncode(stringToSign);
            return Sha256Util.sha256(encodeString, secretKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SignatureException("sign error", e);
        }
    }

    private static String percentEncode(String value) throws UnsupportedEncodingException {
        return value != null ? URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
    }

    private static String buildSortedString(Map<String, String> maps, String symbol1, String symbol2) {
        StringBuilder sb = new StringBuilder();
        LinkedList<String> keys = new LinkedList<String>();
        for (String key : maps.keySet()) {
            keys.add(key);
        }
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key;
            key = (String)keys.get(i);
            String value = maps.get(key);
            if (null == key || key.trim().length() == 0 || null == value || value.trim().length() == 0) continue;
            sb.append(key);
            sb.append(symbol1);
            sb.append(value);
            if (i == keys.size() - 1) continue;
            sb.append(symbol2);
        }
        return sb.toString();
    }
}

