package com.bizvane.mktcenterservice.common;

import lombok.Getter;

/**
 * 渠道会员对应关系
 */
@Getter
/**
 * 订单支付枚举
 */
public enum ChannelMemberCodeEnum {
    ALLTYPE(100000, "全部（微信与支付宝）"),
    POS(100001,"POS端"),
    WX_MINI_MEMBER(100002, "微信小程序会员中心"),
    ALIPAY_MINI(100003, "支付宝小程序会员中心"),
    TIAN_MAO(100004, "天猫"),
    ELECTRONIC_MEMBER_CARD(100005, "电子会员卡"),
    MALL_MINI(100006, "微商城"),
    HAND_EXPORT(100007, "手工导入"),
    WM_MALL(100008, "微盟商城"),
    EHR(100009, "EHR"),
    OTHER(100010, "其他"),
    YOU_ZAN(100011, "有赞"),
    ALIPAY_ELECTRONIC_MEMBER_CARD(100013, "支付宝电子会员卡"),
    MALL_MINI_NEW(100014, "商帆新微商城"),
    WEBSITE(100015, "官网"),
    CHANNELS_SMALL_SHOP(100016,"视频号小店"),
    OTHER_NEW(888888,"其他"),
    WEBSITE_OR_MALL(999999,"官网/商城"),
    TIKTOK(777777,"抖音"),
    ;

    private Integer code;
    private String message;

    ChannelMemberCodeEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
