package com.bizvane.mktcenterservice.rpc.tree3;

import com.bizvane.mktcenterservice.models.vo.tree3.reqvo.*;
import com.bizvane.mktcenterservice.models.vo.tree3.respvo.CourseGroupResultVO;
import com.bizvane.mktcenterservice.models.vo.tree3.respvo.MktCourseUploadLearnProgressRespVO;
import com.bizvane.mktcenterservice.models.vo.tree3.respvo.MktLearnCourseDetailRespVO;
import com.bizvane.mktcenterservice.models.vo.tree3.respvo.MktLearnCoursePageRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/mktLearnCourseRpc")
public interface MktLearnCourseRpc {

    @GetMapping("/getCourseGroupList")
    ResponseData<List<CourseGroupResultVO>> getCourseGroupList(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("sysBrandId") Long sysBrandId);

    @PostMapping("/getLearnCourseList")
    ResponseData<List<MktLearnCoursePageRespVO>> getLearnCourseList(@RequestBody MktLearnCoursePageReqVO reqVO);

    @PostMapping("/getDetail")
    ResponseData<MktLearnCourseDetailRespVO> getDetail(@RequestBody MktLearnCourseDetailReqVO reqVO);

    @PostMapping("/exchangeCourse")
    ResponseData<Boolean> exchangeCourse(@RequestBody MktLearnCourseDetailReqVO reqVO);

    @PostMapping("/uploadLearnProgress")
    ResponseData<MktCourseUploadLearnProgressRespVO> uploadLearnProgress(@RequestBody MktCourseUploadLearnProgressReqVO reqVO);

    @PostMapping("/comment")
    ResponseData<String> comment(@RequestBody MktCourseCommentReqVO reqVO);

    @PostMapping("/getLearnPage")
    ResponseData<PageInfo<MktLearnCoursePageRespVO>> getLearnPage(@RequestBody MktCourseLearnPageReqVO reqVO);
}
