package com.bizvane.mktcenterservice.common;

/**
 * @author chen.li
 * @date on 2018/7/13 11:05
 * @description 活动类型枚举类
 * @Copyright (c) 2018 上海商帆信息科技有限公司-版权所有
 */
public enum ActivityTypeEnum {

    ACTIVITY_TYPE_ALL(0, "全部"),
    ACTIVITY_TYPE_REGISGER(1, "开卡活动"),
    ACTIVITY_TYPE_UPGRADE(2, "升级活动"),
    ACTIVITY_TYPE_QRCODE(3, "扫码领券活动"),
    ACTIVITY_TYPE_MANUAL(4, "手动领券活动"),
    ACTIVITY_TYPE_ORDER(5, "消费活动"),
    ACTIVITY_TYPE_SIGNIN(6, "签到活动"),
    ACTIVITY_TYPE_BIRTHDAY(7, "生日活动"),
    ACTIVITY_TYPE_SMART(8, "智能营销活动"),
    ACTIVITY_TYPE_EVALUATION(9, "评价奖励活动"),
    ACTIVITY_TYPE_ANNIVERSARY(10, "纪念日活动"),
    ACTIVITY_TYPE_PRIZE(11, "抽奖活动"),
    ACTIVITY_TYPE_REDBAGS(12, "红包膨胀活动"),
    ACTIVITY_TYPE_GOLDEN(13, "砸金蛋"),
    ACTIVITY_TYPE_BABY_BIRTHDAY(14, "宝宝生日活动"),
    ACTIVITY_TYPE_FIRST_SINGLE(15, "会员首单活动"),
    ACTIVITY_TYPE_SHARK_IT_OFF(16, "摇一摇"),
    ACTIVITY_TYPE_PAY(17, "储值活动"),
    ACTIVITY_TYPE_REGISTRATION(18, "线下报名活动"),
    ACTIVITY_TYPE_POINTSDISTRIBUTE(20, "积分派发"),
    ACTIVITY_TYPE_ALIPAY_VOUCHER(21,"支付宝商家券"),
    ACTIVITY_TYPE_POINTSLOOT(22, "积分夺宝活动"),
    ACTIVITY_TYPE_PRIZE_NEW(23, "幸运大转盘");


    private int code;
    private String message;

    ActivityTypeEnum(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public static ActivityTypeEnum getActivityTypeEnumByCode(int code) {
        for (ActivityTypeEnum activityTypeEnum : ActivityTypeEnum.values()) {
            if (code == activityTypeEnum.getCode()) {
                return activityTypeEnum;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * 判断是否是小程序会员中心列表展示的活动
     */
    public static boolean checkAppletShowActivity(int activityType){
        if(ACTIVITY_TYPE_UPGRADE.getCode() == activityType || ACTIVITY_TYPE_ORDER.getCode() == activityType
                || ACTIVITY_TYPE_PRIZE.getCode() == activityType || ACTIVITY_TYPE_REDBAGS.getCode() == activityType
                || ACTIVITY_TYPE_GOLDEN.getCode() == activityType || ACTIVITY_TYPE_BABY_BIRTHDAY.getCode() == activityType
                || ACTIVITY_TYPE_FIRST_SINGLE.getCode() == activityType || ACTIVITY_TYPE_SHARK_IT_OFF.getCode() == activityType
                || ACTIVITY_TYPE_REGISTRATION.getCode() == activityType || ACTIVITY_TYPE_PRIZE_NEW.getCode() == activityType){
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}
