package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.models.vo.MktTaskMbrDefVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author zcc
 * @date 2020/6/10 17:49
 *
 **/
@Api(tags = {"营销会员关系参数设置Rpc"})
@FeignClient(value ="${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/taskMbrDefRpc")
public interface MktTaskMbrDefRpc {
    /**
     * 获取详情
     * @param mktTaskMbrDefVO
     * @return
     */
    @ApiOperation(value = "获取详情", notes = "获取详情", tags = {"获取详情接口"})
    @ApiImplicitParams({
            @ApiImplicitParam(name = "mktTaskMbrDefId", value = "主键id,不传时根据企业id和品牌id获取", required = false, dataType = "Long"),
            @ApiImplicitParam(name = "sysCompanyId", value = "企业id", required = false, dataType = "Long"),
            @ApiImplicitParam(name = "sysBrandId", value = "品牌id", required = false, dataType = "Long")
    })
    @PostMapping("getEntityByVo")
    public ResponseData<MktTaskMbrDefVO> getEntityByVo(@RequestBody MktTaskMbrDefVO mktTaskMbrDefVO);
}
