package com.bizvane.mktcenterservice.rpc.tree3;

import com.bizvane.mktcenterservice.models.vo.tree3.reqvo.SelectListConstructabilityByIdListReqVO;
import com.bizvane.mktcenterservice.models.vo.tree3.respvo.GetDetailConstructabilityRespVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/constructability")
public interface ConstructabilityRpc {

    @PostMapping("/getListByIdList")
    ResponseData<List<GetDetailConstructabilityRespVO>> getListByIdList(@RequestBody @Valid SelectListConstructabilityByIdListReqVO reqVO);
}
