package com.bizvane.mktcenterservice.rpc.mktp;

import com.bizvane.mktcenterservice.models.vo.mktp.*;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 客户群裂变feign
 * @author yuantq
 * @date 2023/6/26
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/fissionActivityServiceRpc")
public interface FissionActivityServiceRpc {

    /**
     * 小程序端获取客户群裂变活动详情
     * @param paramsVO
     * @return
     */
    @PostMapping("selectActivityDetail")
    ResponseData<FissionActivityDetailResponseVO> selectActivityDetail(@RequestBody FissionActivityParamsVO paramsVO);

    /**
     * 参与活动(立即邀请)-返回h5二维码地址
     * @param paramsVO
     * @return
     */
    @PostMapping("inviteNow")
    ResponseData<FissionActivityInviteResponseVO> inviteNow(@RequestBody FissionActivityParamsVO paramsVO);

    /**
     * 参与客户裂变活动(立即邀请)-返回员工活码二维码地址
     * @param paramsVO
     * @return
     */
    @PostMapping("customerActivityInviteNow")
    ResponseData<FissionActivityInviteResponseVO> customerActivityInviteNow(@RequestBody FissionActivityParamsVO paramsVO);

    /**
     * 获取活动规则
     * @param paramsVO
     * @return
     */
    @PostMapping("getActivityRuleByCode")
    ResponseData<ActivityRuleResponseVO> getActivityRuleByCode(@RequestBody FissionActivityParamsVO paramsVO);

    /**
     * 获取邀请明细
     * @param paramsVO
     * @return
     */
    @PostMapping("getInvitationRecord")
    ResponseData<FissionActivityInviteRecordVO> getInvitationRecord(@RequestBody FissionActivityParamsVO paramsVO);

    /**
     * 领奖
     * @param paramsVO
     * @return
     */
    @PostMapping("receiveAward")
    ResponseData<ReceiveAwardResponseVO> receiveAward(@RequestBody FissionActivityParamsVO paramsVO);

    /**
     * 获取员工活码二维码
     * @param lifeCodeId
     * @return
     */
    @GetMapping("getLiveCodeInfoById")
    ResponseData<LifeCodeResponseVO> getLiveCodeInfoById(@RequestParam("lifeCodeId")Long lifeCodeId);

    /**
     * 根据中奖记录ID获取可提货门店
     * @param paramsVO
     * @return
     */
    @PostMapping("selectStoreIds")
    ResponseData<List<Long>> selectStoreIds(@RequestBody FissionActivityParamsVO paramsVO);

    /**
     * 根据活动ID获取活动基本信息
     * @param mktpActivityId
     * @return
     */
    @PostMapping("selectMktpActivityInfoById")
    ResponseData<MktpActivityVO> selectMktpActivityInfoById(@RequestParam("mktpActivityId")Long mktpActivityId);

}
