package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.centerstageservice.models.po.SysCheckPo;
import com.bizvane.messagebase.model.vo.StandardBatchMessageVO;
import com.bizvane.mktcenterservice.models.vo.MktMsgTaskVO;
import com.bizvane.mktcenterservice.models.vo.PageForm;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;

public interface MktMsgTaskService{

    /**
     * 获取列表
     * @param mktMsgTaskVO
     * @param pageForm
     * @return
     */
    ResponseData<PageInfo<MktMsgTaskVO>> getList(MktMsgTaskVO mktMsgTaskVO, PageForm pageForm);
    /**
     * 添加消息群发消息
     * @param mktMsgTaskVO
     * @param sysAccountPo
     * @return
     */
    ResponseData<String> addTask(MktMsgTaskVO mktMsgTaskVO, SysAccountPO sysAccountPo);
    /**
     * 审核任务
     * @param po
     * @param sysAccountPO
     * @return
     */
    ResponseData<Integer> checkTask(SysCheckPo po, SysAccountPO sysAccountPO);

    /**
     * 执行任务
     * @param mktMsgTaskId
     * @return
     */
    ResponseData<String> executeTask(Long mktMsgTaskId);

    /**
     * 取消任务
     * @param mktMsgTaskId
     * @param sysAccountPo
     * @return
     */
    ResponseData<String> cancelTask(Long mktMsgTaskId, SysAccountPO sysAccountPo);

    /**
     * 获取群发消息任务的详情
     * @param mktMsgTaskId
     * @param sysAccountPo
     * @return
     */
    ResponseData<MktMsgTaskVO> getMsgTaskDetails(Long mktMsgTaskId, SysAccountPO sysAccountPo);

    /**
     *
     * @param url
     * @param sysAccountPo
     * @return
     */
    ResponseData<List<Map<String,String>>> analysisExcel(String url, PageForm pageForm, SysAccountPO sysAccountPo);

    /**
     * 修改发送数量
     * @param standardBatchMessageVO
     * @return
     */
    ResponseData<String> updateSendMsgCount(StandardBatchMessageVO standardBatchMessageVO);
}
