package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.models.bo.MktActivityDetailAndPicture;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import com.bizvane.mktcenterservice.models.vo.MktActivityPrizeRecordVO;
import com.bizvane.mktcenterservice.models.vo.ProbabilityVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.text.ParseException;
import java.util.List;
import java.util.Map;

/**
 * @Author: lijunwei
 * @Time: 2019/2/26 11:27
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/activityEGRpc")
public interface ActivityEGServiceRpc {
    @RequestMapping("getMktActivityPOWithBLOBs")
    public ResponseData<MktActivityDetailAndPicture> getMktActivityPOWithBLOBs(@RequestBody ProbabilityVO vo);

    @RequestMapping("doEggFrenzy")
    public ResponseData<String> doEggFrenzy(@RequestBody ProbabilityVO vo) throws ParseException;

    @RequestMapping("getEGPrizeRecordList")
    public ResponseData<List<MktActivityPrizeRecordVO>> getEGPrizeRecordList(@RequestBody MktActivityPrizeRecordPO po);

    @RequestMapping("residueMemberNumber")
    public ResponseData<Map<String,Integer>>  residueMemberNumber(@RequestBody ProbabilityVO vo) throws ParseException;

    @RequestMapping("addMemberNumber")
    public ResponseData<Map<String,Integer>> addMemberNumber(@RequestBody ProbabilityVO vo) throws ParseException;

    @RequestMapping("getActivityId")
    public ResponseData<MktActivityPOWithBLOBs>  getActivityId(@RequestBody ProbabilityVO vo);
    
    /**
     * 砸金蛋详情，小程序端用户查询
     * @param vo
     * @return
     */
    @RequestMapping("getMktActivityBO2C")
    ResponseData<MktActivityDetailAndPicture> getMktActivityBO2C(@RequestBody ProbabilityVO vo);
}
