package com.bizvane.mktcenterservice.interfaces;

import java.util.List;

import com.bizvane.mktcenterservice.models.po.MktTaskPhysicalPO;
import com.bizvane.mktcenterservice.models.po.MktTaskPhysicalRecordPO;
import com.bizvane.mktcenterservice.models.requestvo.TaskPrizeReqVO;
import com.bizvane.mktcenterservice.models.vo.BatchUpdateLogisticsStatusReqVO;
import com.bizvane.mktcenterservice.models.vo.MemberTaskPrizeReqVO;
import com.bizvane.mktcenterservice.models.vo.MemberTaskPrizeResVO;
import com.bizvane.mktcenterservice.models.vo.MemberTaskPrizeStoreReqVO;
import com.bizvane.mktcenterservice.models.vo.MemberTaskPrizeStoreResVO;
import com.bizvane.mktcenterservice.models.vo.TaskPhysicalVO;
import com.bizvane.mktcenterservice.models.vo.TaskPrizeAddressReqVO;
import com.bizvane.mktcenterservice.models.vo.TaskPrizeExchangeDetailReqVO;
import com.bizvane.mktcenterservice.models.vo.TaskPrizeExchangeDetailResVO;
import com.bizvane.mktcenterservice.models.vo.TaskPrizeExchangeReqVO;
import com.bizvane.mktcenterservice.models.vo.TaskPrizeResVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

public interface TaskPhysicalService {
    Long addTaskPhysical(Long mktTaskId,TaskPhysicalVO taskPhysicalVO, SysAccountPO stageUser);

    Integer deleteTaskPhysical(Long mktTaskId, SysAccountPO stageUser);

    Integer addTaskPhysicalRecord(MktTaskPhysicalRecordPO recordPO);

    ResponseData addPrizeAddressNew(TaskPrizeAddressReqVO reqVO);

    ResponseData<TaskPrizeExchangeDetailResVO> getPrizeExchangeDetail(TaskPrizeExchangeDetailReqVO reqVO);

    ResponseData receivePrize(TaskPrizeExchangeReqVO reqVO);

    ResponseData<PageInfo<TaskPrizeResVO>> findPrizeRecordPage(SysAccountPO sysAccountPo, TaskPrizeReqVO taskPrizeReqVO);

    ResponseData<String> findPrizeRecordExport(SysAccountPO sysAccountPo, TaskPrizeReqVO taskPrizeReqVO);

    ResponseData<String> batchUpdateLogisticsStatus(SysAccountPO sysAccountPo, BatchUpdateLogisticsStatusReqVO reqVO);

    ResponseData<List<MemberTaskPrizeResVO>> getTaskPrizeRecord(MemberTaskPrizeReqVO reqVO);

    ResponseData<MemberTaskPrizeStoreResVO> selectStoreIds(MemberTaskPrizeStoreReqVO reqVO);

    TaskPhysicalVO getTaskPrize(Long mktTaskId);
}
