/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl.mobile;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.mktcenter.api.service.MobileTaskPopupAdvertisementService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMktPopupAdvertisement;
import com.bizvane.mktcenter.domain.domain.po.TMktPopupAdvertisementRecord;
import com.bizvane.mktcenter.domain.service.TMktPopupAdvertisementRecordService;
import com.bizvane.mktcenter.domain.service.TMktPopupAdvertisementService;
import com.bizvane.mktcenter.feign.vo.req.ClickPopupAdvertisementReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryMobilePopupAdvertisementListReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryMobilePopupAdvertisementListRespVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MobileTaskPopupAdvertisementServiceImpl
implements MobileTaskPopupAdvertisementService {
    private static final Logger log = LoggerFactory.getLogger(MobileTaskPopupAdvertisementServiceImpl.class);
    @Autowired
    private TMktPopupAdvertisementService tMktPopupAdvertisementService;
    @Autowired
    private TMktPopupAdvertisementRecordService tMktPopupAdvertisementRecordService;

    public ResponseData<List<QueryMobilePopupAdvertisementListRespVO>> getList(QueryMobilePopupAdvertisementListReqVO reqVO) {
        String mbrMemberCode = reqVO.getMbrMemberCode();
        String mbrGroupDefCode = "";
        List recordList = this.tMktPopupAdvertisementRecordService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktPopupAdvertisementRecord::getMemberCode, (Object)mbrMemberCode)).eq(TMktPopupAdvertisementRecord::getValid, (Object)1));
        Set joinedPopupAdvertisementCodeSet = Optional.ofNullable(recordList).map(list -> list.stream().map(TMktPopupAdvertisementRecord::getMktPopupAdvertisementCode).collect(Collectors.toSet())).orElse(new HashSet());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktPopupAdvertisement::getValid, (Object)1)).lt(TMktPopupAdvertisement::getStartTime, (Object)new Date())).gt(TMktPopupAdvertisement::getEndTime, (Object)new Date())).ne(TMktPopupAdvertisement::getPopupStatus, (Object)4)).eq(TMktPopupAdvertisement::getStatus, (Object)1)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TMktPopupAdvertisement::getMbrConditionType, (Object)1)).or()).eq(TMktPopupAdvertisement::getMbrGroupDefCode, (Object)mbrGroupDefCode);
        });
        if (CollUtil.isNotEmpty((Collection)joinedPopupAdvertisementCodeSet)) {
            queryWrapper.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TMktPopupAdvertisement::getFrequencyType, (Object)1)).or()).eq(TMktPopupAdvertisement::getFrequencyType, (Object)0)).notIn(TMktPopupAdvertisement::getPopupAdvertisementCode, (Collection)joinedPopupAdvertisementCodeSet);
            });
        }
        List tMktPopupAdvertisementList = this.tMktPopupAdvertisementService.list((Wrapper)queryWrapper);
        log.info("tMktPopupAdvertisementList: {}", (Object)JacksonUtil.list2Json((List)tMktPopupAdvertisementList));
        List<Object> resultList = new ArrayList();
        if (CollUtil.isNotEmpty((Collection)tMktPopupAdvertisementList)) {
            resultList = tMktPopupAdvertisementList.stream().map(item -> {
                QueryMobilePopupAdvertisementListRespVO respVO = (QueryMobilePopupAdvertisementListRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)item), QueryMobilePopupAdvertisementListRespVO.class);
                return respVO;
            }).collect(Collectors.toList());
            List recordListNew = resultList.stream().map(item -> {
                TMktPopupAdvertisementRecord record = new TMktPopupAdvertisementRecord();
                record.setMktPopupAdvertisementRecodeCode(IdUtil.fastSimpleUUID());
                record.setMktPopupAdvertisementCode(item.getPopupAdvertisementCode());
                record.setMemberCode(mbrMemberCode);
                record.setPopupTime(new Date());
                record.setState(Integer.valueOf(1));
                record.setValid(Integer.valueOf(1));
                return record;
            }).collect(Collectors.toList());
            this.tMktPopupAdvertisementRecordService.saveBatch(recordListNew);
            tMktPopupAdvertisementList.forEach(item -> item.setPopupNum(Integer.valueOf(Optional.ofNullable(item.getPopupNum()).orElse(0) + 1)));
            this.tMktPopupAdvertisementService.updateBatchById((Collection)tMktPopupAdvertisementList);
        }
        return ResponseUtil.getSuccessData(resultList);
    }

    public ResponseData<String> clickPopupAdvertisement(ClickPopupAdvertisementReqVO reqVO) {
        String mbrMemberCode = reqVO.getMbrMemberCode();
        String mktPopupAdvertisementCode = reqVO.getMktPopupAdvertisementCode();
        boolean update = this.tMktPopupAdvertisementRecordService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(TMktPopupAdvertisementRecord.class).eq(TMktPopupAdvertisementRecord::getMemberCode, (Object)mbrMemberCode)).eq(TMktPopupAdvertisementRecord::getMktPopupAdvertisementCode, (Object)mktPopupAdvertisementCode)).eq(TMktPopupAdvertisementRecord::getState, (Object)1)).eq(TMktPopupAdvertisementRecord::getValid, (Object)1)).set(TMktPopupAdvertisementRecord::getState, (Object)2));
        if (update) {
            this.tMktPopupAdvertisementService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(TMktPopupAdvertisement.class).eq(TMktPopupAdvertisement::getPopupAdvertisementCode, (Object)mktPopupAdvertisementCode)).eq(TMktPopupAdvertisement::getValid, (Object)1)).setSql("click_num = click_num + 1", new Object[0]));
        }
        return ResponseUtil.getSuccessData((Object)"\u70b9\u51fb\u6210\u529f");
    }
}

