/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl.mobile;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bizvane.mktcenter.api.service.ApiMktCommonService;
import com.bizvane.mktcenter.api.service.MobileMktActivityService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMktActivity;
import com.bizvane.mktcenter.domain.service.TMktActivityService;
import com.bizvane.mktcenter.feign.vo.req.MktActivityVO;
import com.bizvane.mktcenter.feign.vo.req.mobile.MobileQueryActivityDetailReqVO;
import com.bizvane.mktcenter.feign.vo.req.mobile.MobileQueryActivityListReqVO;
import com.bizvane.mktcenter.feign.vo.resp.MobileQueryActivityListRespVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MobileMktActivityServiceImpl
implements MobileMktActivityService {
    private static final Logger log = LoggerFactory.getLogger(MobileMktActivityServiceImpl.class);
    @Autowired
    private TMktActivityService tMktActivityService;
    @Autowired
    private ApiMktCommonService apiMktCommonService;

    public ResponseData<List<MobileQueryActivityListRespVO>> getMobileActivityList(MobileQueryActivityListReqVO reqVO) {
        String mbrMemberCode = reqVO.getMbrMemberCode();
        Integer activityStatus = reqVO.getActivityStatus();
        List tMktActivityList = this.tMktActivityService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getActivityStatus, (Object)activityStatus)).ne(TMktActivity::getActivityStatus, (Object)4)).notIn(TMktActivity::getActivityType, Arrays.asList(7, 5, 3))).eq(TMktActivity::getValid, (Object)1));
        ArrayList<MobileQueryActivityListRespVO> resultList = new ArrayList<MobileQueryActivityListRespVO>();
        if (CollUtil.isNotEmpty((Collection)tMktActivityList)) {
            for (TMktActivity tMktActivity : tMktActivityList) {
                Integer mbrConditionType = tMktActivity.getMbrConditionType();
                if (mbrConditionType == 1) {
                    MobileQueryActivityListRespVO mobileQueryActivityListRespVO = (MobileQueryActivityListRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktActivity), MobileQueryActivityListRespVO.class);
                    resultList.add(mobileQueryActivityListRespVO);
                    continue;
                }
                String mbrGroupDefCode = tMktActivity.getMbrGroupDefCode();
                Boolean flag = this.apiMktCommonService.mbrInGroup(mbrMemberCode, mbrGroupDefCode);
                if (!flag.booleanValue()) continue;
                MobileQueryActivityListRespVO mobileQueryActivityListRespVO = (MobileQueryActivityListRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktActivity), MobileQueryActivityListRespVO.class);
                resultList.add(mobileQueryActivityListRespVO);
            }
        }
        return ResponseUtil.getSuccessData(resultList);
    }

    public ResponseData<MktActivityVO> getDetail(MobileQueryActivityDetailReqVO reqVO) {
        Boolean flag;
        String mktActivityCode = reqVO.getMktActivityCode();
        String mbrMemberCode = reqVO.getMbrMemberCode();
        TMktActivity tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivity.class).eq(TMktActivity::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivity::getActivityStatus, (Object)2)).eq(TMktActivity::getCheckStatus, (Object)3)).eq(TMktActivity::getValid, (Object)1));
        if (tMktActivity == null) {
            return ResponseUtil.getFailedMsg((String)"\u6d3b\u52a8\u65e0\u6548");
        }
        Integer mbrConditionType = tMktActivity.getMbrConditionType();
        String mbrGroupDefCode = tMktActivity.getMbrGroupDefCode();
        if (mbrConditionType != 1 && !(flag = this.apiMktCommonService.mbrInGroup(mbrMemberCode, mbrGroupDefCode)).booleanValue()) {
            return ResponseUtil.getFailedMsg((String)"\u4e0d\u5728\u6d3b\u52a8\u8303\u56f4\u5185");
        }
        MktActivityVO mktActivityVO = (MktActivityVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktActivity), MktActivityVO.class);
        return ResponseUtil.getSuccessData((Object)mktActivityVO);
    }
}

