/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl.mobile;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.mktcenter.api.domain.bo.SendActivityBO;
import com.bizvane.mktcenter.api.service.ApiMktActivityCommonService;
import com.bizvane.mktcenter.api.service.ApiMktCommonService;
import com.bizvane.mktcenter.api.service.MobileActivitySignInService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMktActivity;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityCoupon;
import com.bizvane.mktcenter.domain.domain.po.TMktActivitySendRecord;
import com.bizvane.mktcenter.domain.domain.po.TMktActivitySignInPrize;
import com.bizvane.mktcenter.domain.domain.po.TMktActivitySignInRecord;
import com.bizvane.mktcenter.domain.service.TMktActivityCouponService;
import com.bizvane.mktcenter.domain.service.TMktActivitySendRecordService;
import com.bizvane.mktcenter.domain.service.TMktActivityService;
import com.bizvane.mktcenter.domain.service.TMktActivitySignInPrizeService;
import com.bizvane.mktcenter.domain.service.TMktActivitySignInRecordService;
import com.bizvane.mktcenter.feign.vo.CouponDefVO;
import com.bizvane.mktcenter.feign.vo.req.MbrSignInRecordByMonthReqVO;
import com.bizvane.mktcenter.feign.vo.req.MbrSignInReqVO;
import com.bizvane.mktcenter.feign.vo.req.mobile.QuerySignInRecordPageListReqVO;
import com.bizvane.mktcenter.feign.vo.resp.MbrSignInRecordByMonthRespVO;
import com.bizvane.mktcenter.feign.vo.resp.MbrSignInRespVO;
import com.bizvane.mktcenter.feign.vo.resp.mobile.QuerySignInRecordPageListRespVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MobileActivitySignInServiceImpl
implements MobileActivitySignInService {
    private static final Logger log = LoggerFactory.getLogger(MobileActivitySignInServiceImpl.class);
    @Autowired
    private TMktActivitySignInPrizeService tMktActivitySignInPrizeService;
    @Autowired
    private TMktActivitySignInRecordService tMktActivitySignInRecordService;
    @Autowired
    private TMktActivityService tMktActivityService;
    @Autowired
    private ApiMktActivityCommonService apiMktActivityCommonService;
    @Autowired
    private TMktActivityCouponService tMktActivityCouponService;
    @Autowired
    private ApiMktCommonService apiMktCommonService;
    @Autowired
    private TMktActivitySendRecordService tMktActivitySendRecordService;

    public ResponseData<MbrSignInRespVO> mbrSignIn(MbrSignInReqVO reqVO) {
        String memberCode = reqVO.getMemberCode();
        TMktActivitySignInRecord todaySignIn = (TMktActivitySignInRecord)this.tMktActivitySignInRecordService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivitySignInRecord::getMbrMemberCode, (Object)memberCode)).between(TMktActivitySignInRecord::getSignInDate, (Object)Date.from(LocalDate.now().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()), (Object)Date.from(LocalDate.now().atTime(23, 59, 59).atZone(ZoneId.systemDefault()).toInstant()))).eq(TMktActivitySignInRecord::getValid, (Object)1));
        if (todaySignIn != null) {
            return ResponseUtil.getFailedMsg((String)"\u4eca\u65e5\u5df2\u7b7e\u5230");
        }
        Integer continuousNum = 1;
        TMktActivitySignInRecord yesterdaySignIn = (TMktActivitySignInRecord)this.tMktActivitySignInRecordService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivitySignInRecord::getMbrMemberCode, (Object)memberCode)).between(TMktActivitySignInRecord::getSignInDate, (Object)Date.from(LocalDate.now().minusDays(1L).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()), (Object)Date.from(LocalDate.now().minusDays(1L).atTime(23, 59, 59).atZone(ZoneId.systemDefault()).toInstant()))).eq(TMktActivitySignInRecord::getValid, (Object)1));
        if (yesterdaySignIn != null) {
            continuousNum = yesterdaySignIn.getContinuousNum() + 1;
        }
        Integer accumulateNum = (int)this.tMktActivitySignInRecordService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivitySignInRecord::getMbrMemberCode, (Object)memberCode)).eq(TMktActivitySignInRecord::getValid, (Object)1));
        accumulateNum = accumulateNum + 1;
        TMktActivitySignInRecord signInRecord = new TMktActivitySignInRecord();
        signInRecord.setMktActivitySignInRecordCode(IdUtil.fastSimpleUUID());
        signInRecord.setMbrMemberCode(memberCode);
        signInRecord.setSignInDate(new Date());
        signInRecord.setValid(Integer.valueOf(1));
        signInRecord.setContinuousNum(continuousNum);
        signInRecord.setAccumulateNum(accumulateNum);
        this.tMktActivitySignInRecordService.save((Object)signInRecord);
        TMktActivity tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivity.class).eq(TMktActivity::getActivityType, (Object)5)).eq(TMktActivity::getActivityStatus, (Object)2)).eq(TMktActivity::getCheckStatus, (Object)3)).eq(TMktActivity::getValid, (Object)1));
        List signInPrizeList = this.tMktActivitySignInPrizeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivitySignInPrize.class).eq(TMktActivitySignInPrize::getMktActivityCode, (Object)tMktActivity.getMktActivityCode())).eq(TMktActivitySignInPrize::getValid, (Object)1));
        log.info("signInPrizeList: {}", (Object)JacksonUtil.list2Json((List)signInPrizeList));
        Integer integral = 0;
        ArrayList couponCodeList = new ArrayList();
        if (CollUtil.isNotEmpty((Collection)signInPrizeList)) {
            for (TMktActivitySignInPrize tMktActivitySignInPrize : signInPrizeList) {
                Integer signInType = tMktActivitySignInPrize.getSignInType();
                if (!ObjUtil.equals((Object)1, (Object)signInType) && (!ObjUtil.equals((Object)2, (Object)signInType) || !ObjUtil.equals((Object)continuousNum, (Object)tMktActivitySignInPrize.getSignInDays())) && (!ObjUtil.equals((Object)3, (Object)signInType) || !ObjUtil.equals((Object)accumulateNum, (Object)tMktActivitySignInPrize.getSignInDays()))) continue;
                List activityCouponList = this.tMktActivityCouponService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivityCoupon.class).eq(TMktActivityCoupon::getMktActivityCode, (Object)tMktActivity.getMktActivityCode())).eq(TMktActivityCoupon::getMktActivitySignInPrizeCode, (Object)tMktActivitySignInPrize.getMktActivitySignInPrizeCode())).eq(TMktActivityCoupon::getValid, (Object)1));
                String couponList = Optional.ofNullable(activityCouponList).map(list -> list.stream().map(TMktActivityCoupon::getCouponCode).collect(Collectors.joining(","))).orElse(null);
                SendActivityBO sendActivityBO = new SendActivityBO();
                sendActivityBO.setActivityNo(tMktActivity.getActivityNo());
                sendActivityBO.setMktActivityCode(tMktActivity.getMktActivityCode());
                sendActivityBO.setIntegral(tMktActivity.getIntegral());
                sendActivityBO.setCouponCodeList(couponList);
                sendActivityBO.setBusinessCode(signInRecord.getMktActivitySignInRecordCode());
                sendActivityBO.setMktActivitySignInPrizeCode(tMktActivitySignInPrize.getMktActivitySignInPrizeCode());
                ResponseData sentActivityResp = this.apiMktActivityCommonService.sendActivityBenefit(sendActivityBO, Arrays.asList(memberCode));
                log.info("sentActivityResp:{}", (Object)JacksonUtil.bean2Json((Object)sentActivityResp));
                integral = integral + tMktActivity.getIntegral();
                couponCodeList.addAll(activityCouponList.stream().map(TMktActivityCoupon::getCouponCode).collect(Collectors.toList()));
                signInRecord.setExtra(Integer.valueOf(1));
                this.tMktActivitySignInRecordService.updateById((Object)signInRecord);
            }
        }
        MbrSignInRespVO mbrSignInRespVO = new MbrSignInRespVO();
        mbrSignInRespVO.setIntegral(integral);
        if (CollUtil.isNotEmpty(couponCodeList)) {
            Map couponCountMap = couponCodeList.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            List couponListByCode = this.apiMktCommonService.getCouponListByCode(couponCodeList);
            List mbrSignInCouponList = couponListByCode.stream().map(item -> {
                MbrSignInRespVO.MbrSignInCoupon mbrSignInCoupon = new MbrSignInRespVO.MbrSignInCoupon();
                mbrSignInCoupon.setCouponCode(item.getCouponCode());
                mbrSignInCoupon.setCouponName(item.getCouponName());
                mbrSignInCoupon.setNum((Long)couponCountMap.get(item.getCouponCode()));
                return mbrSignInCoupon;
            }).collect(Collectors.toList());
            mbrSignInRespVO.setCouponList(mbrSignInCouponList);
        }
        return ResponseUtil.getSuccessData((Object)mbrSignInRespVO);
    }

    public ResponseData<MbrSignInRecordByMonthRespVO> getRecordListByMonth(MbrSignInRecordByMonthReqVO reqVO) {
        TMktActivity tMktActivity;
        Integer year = reqVO.getYear();
        Integer month = reqVO.getMonth();
        String mbrMemberCode = reqVO.getMbrMemberCode();
        MbrSignInRecordByMonthRespVO respVO = new MbrSignInRecordByMonthRespVO();
        TMktActivitySignInRecord todaySignIn = (TMktActivitySignInRecord)this.tMktActivitySignInRecordService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivitySignInRecord::getMbrMemberCode, (Object)mbrMemberCode)).between(TMktActivitySignInRecord::getSignInDate, (Object)Date.from(LocalDate.now().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()), (Object)Date.from(LocalDate.now().atTime(23, 59, 59).atZone(ZoneId.systemDefault()).toInstant()))).eq(TMktActivitySignInRecord::getValid, (Object)1));
        if (todaySignIn != null) {
            respVO.setTodaySignInState(Integer.valueOf(1));
        } else {
            respVO.setTodaySignInState(Integer.valueOf(0));
        }
        HashSet<Object> dayRecordSet = new HashSet<Object>();
        List recordList = this.tMktActivitySignInRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivitySignInRecord.class).eq(TMktActivitySignInRecord::getMbrMemberCode, (Object)mbrMemberCode)).eq(TMktActivitySignInRecord::getValid, (Object)1)).between(TMktActivitySignInRecord::getSignInDate, (Object)Date.from(LocalDate.of((int)year, month, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()), (Object)Date.from(LocalDate.of((int)year, month, 1).plusMonths(1L).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant())));
        if (CollUtil.isNotEmpty((Collection)recordList)) {
            List recordByMonthRespVOS = recordList.stream().map(record -> {
                MbrSignInRecordByMonthRespVO.MbrSignInRecordByDay day = new MbrSignInRecordByMonthRespVO.MbrSignInRecordByDay();
                day.setDay(record.getSignInDate() == null ? null : record.getSignInDate().toInstant().atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                day.setSignInState(Integer.valueOf(1));
                day.setExtra(record.getExtra());
                return day;
            }).collect(Collectors.toList());
            dayRecordSet.addAll(recordByMonthRespVOS);
        }
        if ((tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivity.class).eq(TMktActivity::getActivityType, (Object)5)).eq(TMktActivity::getActivityStatus, (Object)2)).eq(TMktActivity::getCheckStatus, (Object)3)).eq(TMktActivity::getValid, (Object)1))) == null) {
            return ResponseUtil.getSuccessData((Object)respVO);
        }
        String mktActivityCode = tMktActivity.getMktActivityCode();
        List signInPrizeList = this.tMktActivitySignInPrizeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivitySignInPrize.class).eq(TMktActivitySignInPrize::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivitySignInPrize::getValid, (Object)1));
        log.info("getRecordListByMonth signInPrizeList: {}", (Object)JacksonUtil.list2Json((List)signInPrizeList));
        signInPrizeList = signInPrizeList.stream().filter(item -> item.getSignInType() == 2 || item.getSignInType() == 3).collect(Collectors.toList());
        if (CollUtil.isEmpty(signInPrizeList)) {
            return ResponseUtil.getSuccessData((Object)respVO);
        }
        TMktActivitySignInRecord latestRecord = (TMktActivitySignInRecord)this.tMktActivitySignInRecordService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivitySignInRecord.class).eq(TMktActivitySignInRecord::getMbrMemberCode, (Object)mbrMemberCode)).eq(TMktActivitySignInRecord::getValid, (Object)1)).orderByDesc(TMktActivitySignInRecord::getId)).last("limit 1"));
        Integer continuousNum = 0;
        Integer accumulateNum = 0;
        if (latestRecord == null) {
            continuousNum = 1;
            accumulateNum = 1;
        } else if (LocalDate.now().compareTo(latestRecord.getSignInDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate()) == 0) {
            continuousNum = latestRecord.getContinuousNum();
            accumulateNum = latestRecord.getAccumulateNum();
        } else if (LocalDate.now().minusDays(1L).compareTo(latestRecord.getSignInDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate()) == 0) {
            continuousNum = latestRecord.getContinuousNum() + 1;
            accumulateNum = latestRecord.getAccumulateNum() + 1;
        } else {
            continuousNum = 1;
            accumulateNum = latestRecord.getAccumulateNum() + 1;
        }
        for (TMktActivitySignInPrize tMktActivitySignInPrize : signInPrizeList) {
            MbrSignInRecordByMonthRespVO.MbrSignInRecordByDay day;
            LocalDate targetDate;
            Integer signInType = tMktActivitySignInPrize.getSignInType();
            Integer signInDays = tMktActivitySignInPrize.getSignInDays();
            if (signInType == 2 && continuousNum < signInDays && (targetDate = LocalDate.now().plusDays(signInDays - continuousNum)).getMonthValue() == month.intValue()) {
                day = new MbrSignInRecordByMonthRespVO.MbrSignInRecordByDay();
                day.setDay(targetDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                day.setSignInState(Integer.valueOf(0));
                day.setExtra(Integer.valueOf(0));
                dayRecordSet.add(day);
            }
            if (signInType != 3 || accumulateNum >= signInDays || (targetDate = LocalDate.now().plusDays(signInDays - accumulateNum)).getMonthValue() != month.intValue()) continue;
            day = new MbrSignInRecordByMonthRespVO.MbrSignInRecordByDay();
            day.setDay(targetDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            day.setSignInState(Integer.valueOf(0));
            day.setExtra(Integer.valueOf(0));
            dayRecordSet.add(day);
        }
        respVO.setDayRespVOList(new ArrayList(dayRecordSet));
        return ResponseUtil.getSuccessData((Object)respVO);
    }

    public ResponseData<PageInfo<QuerySignInRecordPageListRespVO>> getSignInRecordPage(QuerySignInRecordPageListReqVO reqVO) {
        PageInfo pageInfo = new PageInfo();
        Page page = (Page)this.tMktActivitySendRecordService.page((IPage)new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivitySendRecord.class).eq(TMktActivitySendRecord::getMbrMembersCode, (Object)reqVO.getMbrMemberCode())).eq(TMktActivitySendRecord::getValid, (Object)1)).eq(TMktActivitySendRecord::getActivityType, (Object)5)).orderByDesc(TMktActivitySendRecord::getCreateDate));
        List records = page.getRecords();
        if (CollUtil.isNotEmpty((Collection)records)) {
            ArrayList allCouponCodeList = new ArrayList();
            records.stream().forEach(item -> {
                String couponCodeList = item.getCouponCodeList();
                if (StrUtil.isNotBlank((CharSequence)couponCodeList)) {
                    allCouponCodeList.addAll(Arrays.asList(couponCodeList.split(",")));
                }
            });
            List signInPrizeCodeList = records.stream().map(TMktActivitySendRecord::getMktActivitySignInPrizeCode).collect(Collectors.toList());
            List signInPrizeList = this.tMktActivitySignInPrizeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivitySignInPrize.class).in(TMktActivitySignInPrize::getMktActivitySignInPrizeCode, signInPrizeCodeList)).eq(TMktActivitySignInPrize::getValid, (Object)1));
            Map prizeMap = signInPrizeList.stream().collect(Collectors.toMap(TMktActivitySignInPrize::getMktActivitySignInPrizeCode, Function.identity(), (o1, o2) -> o2));
            List signInRecordCodeList = records.stream().map(TMktActivitySendRecord::getBusinessCode).collect(Collectors.toList());
            List signInRecordList = this.tMktActivitySignInRecordService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivitySignInRecord.class).in(TMktActivitySignInRecord::getMktActivitySignInRecordCode, signInRecordCodeList)).eq(TMktActivitySignInRecord::getValid, (Object)1));
            Map signInRecordMap = signInRecordList.stream().collect(Collectors.toMap(TMktActivitySignInRecord::getMktActivitySignInRecordCode, Function.identity(), (o1, o2) -> o2));
            Map<Object, Object> couponDefVOMap = new HashMap();
            if (CollUtil.isNotEmpty(allCouponCodeList)) {
                List couponListByCode = this.apiMktCommonService.getCouponListByCode(allCouponCodeList);
                couponDefVOMap = couponListByCode.stream().collect(Collectors.toMap(CouponDefVO::getCouponCode, Function.identity(), (o1, o2) -> o2));
            }
            HashMap couponDefVOMapFinal = couponDefVOMap;
            List resultList = records.stream().map(item -> {
                QuerySignInRecordPageListRespVO respVO = new QuerySignInRecordPageListRespVO();
                respVO.setIntegral(item.getIntegral());
                String couponCodeList = item.getCouponCodeList();
                List couponDefVOList = Arrays.asList(couponCodeList.split(",")).stream().map(couponCode -> {
                    CouponDefVO couponDefVO = (CouponDefVO)couponDefVOMapFinal.get(couponCode);
                    return couponDefVO;
                }).collect(Collectors.toList());
                respVO.setCouponList(couponDefVOList);
                String mktActivitySignInPrizeCode = item.getMktActivitySignInPrizeCode();
                TMktActivitySignInPrize tMktActivitySignInPrize = (TMktActivitySignInPrize)prizeMap.get(mktActivitySignInPrizeCode);
                respVO.setSignInType(tMktActivitySignInPrize.getSignInType());
                respVO.setSignInDays(tMktActivitySignInPrize.getSignInDays());
                TMktActivitySignInRecord tMktActivitySignInRecord = (TMktActivitySignInRecord)signInRecordMap.get(item.getBusinessCode());
                respVO.setSignInTime(tMktActivitySignInRecord.getSignInDate());
                return respVO;
            }).collect(Collectors.toList());
            pageInfo = new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), resultList);
        }
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }
}

