/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.mktcenter.api.domain.bo.CompleteSurveyBO;
import com.bizvane.mktcenter.api.domain.bo.SendTaskBO;
import com.bizvane.mktcenter.api.service.ApiMktCommonService;
import com.bizvane.mktcenter.api.service.ApiMktTaskCommonService;
import com.bizvane.mktcenter.api.service.ApiMktTaskSurveyService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMktTask;
import com.bizvane.mktcenter.domain.domain.po.TMktTaskCoupon;
import com.bizvane.mktcenter.domain.domain.po.TMktTaskSendRecord;
import com.bizvane.mktcenter.domain.domain.po.TMktTaskSurvey;
import com.bizvane.mktcenter.domain.service.TMktTaskCouponService;
import com.bizvane.mktcenter.domain.service.TMktTaskSendRecordService;
import com.bizvane.mktcenter.domain.service.TMktTaskService;
import com.bizvane.mktcenter.domain.service.TMktTaskSurveyService;
import com.bizvane.mktcenter.feign.vo.MktSurveyVO;
import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktTaskSurveyReqVO;
import com.bizvane.mktcenter.feign.vo.req.MktTaskVO;
import com.bizvane.mktcenter.feign.vo.req.QueryTaskAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailTaskSurveyRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryTaskSurveyAnalysisPageRespVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMktTaskSurveyServiceImpl
implements ApiMktTaskSurveyService {
    private static final Logger log = LoggerFactory.getLogger(ApiMktTaskSurveyServiceImpl.class);
    @Autowired
    private TMktTaskService tMktTaskService;
    @Autowired
    private TMktTaskSurveyService tMktTaskSurveyService;
    @Autowired
    private ApiMktTaskCommonService apiMktTaskCommonService;
    @Autowired
    private TMktTaskSendRecordService tMktTaskSendRecordService;
    @Autowired
    private TMktTaskCouponService tMktTaskCouponService;
    @Autowired
    private ApiMktCommonService apiMktCommonService;

    public ResponseData<String> saveOrUpdate(AddOrUpdateMktTaskSurveyReqVO reqVO) {
        String mktTaskCode = reqVO.getMktTaskCode();
        TMktTask tMktTask = null;
        TMktTaskSurvey tMktTaskSurvey = null;
        if (StrUtil.isNotBlank((CharSequence)mktTaskCode)) {
            tMktTaskSurvey = (TMktTaskSurvey)this.tMktTaskSurveyService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTaskSurvey::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTaskSurvey::getValid, (Object)1));
            if (tMktTaskSurvey == null) {
                return ResponseUtil.getFailedMsg((String)"\u8c03\u67e5\u95ee\u5377\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
            tMktTask = (TMktTask)this.tMktTaskService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTask::getValid, (Object)1));
            if (tMktTask == null) {
                return ResponseUtil.getFailedMsg((String)"\u8c03\u67e5\u95ee\u5377\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
        } else {
            tMktTask = new TMktTask();
            tMktTaskSurvey = new TMktTaskSurvey();
            mktTaskCode = IdUtil.fastSimpleUUID();
            tMktTask.setMktTaskCode(mktTaskCode);
            tMktTask.setTaskNo(IdUtil.fastSimpleUUID());
            tMktTask.setTaskType(Integer.valueOf(4));
            tMktTask.setTaskStatus(Integer.valueOf(1));
            tMktTask.setCheckStatus(Integer.valueOf(1));
            tMktTask.setValid(Integer.valueOf(1));
            tMktTaskSurvey.setMktTaskCode(mktTaskCode);
            tMktTaskSurvey.setMktTaskSurveyCode(IdUtil.fastSimpleUUID());
            tMktTaskSurvey.setValid(Integer.valueOf(1));
        }
        this.apiMktTaskCommonService.saveCoupon((MktTaskVO)reqVO);
        BeanUtil.copyProperties((Object)reqVO, (Object)tMktTaskSurvey, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)reqVO, (Object)tMktTask, (CopyOptions)CopyOptions.create().ignoreNullValue());
        this.tMktTaskSurveyService.saveOrUpdate((Object)tMktTaskSurvey);
        return ResponseUtil.getSuccessData((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public ResponseData<PageInfo<QueryTaskSurveyAnalysisPageRespVO>> analysisPageList(QueryTaskAnalysisPageReqVO reqVO) {
        Page page = (Page)((Page)this.tMktTaskService.page((IPage)new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getTaskType, (Object)4)).eq(TMktTask::getValid, (Object)1)).eq(StrUtil.isNotBlank((CharSequence)reqVO.getTaskName()), TMktTask::getTaskName, (Object)reqVO.getTaskName())).eq(StrUtil.isNotBlank((CharSequence)reqVO.getTaskNo()), TMktTask::getTaskNo, (Object)reqVO.getTaskNo()))).convert(tMktTask -> (QueryTaskSurveyAnalysisPageRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktTask), QueryTaskSurveyAnalysisPageRespVO.class));
        PageInfo pageInfo = new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), page.getRecords());
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    public ResponseData<QueryDetailTaskSurveyRespVO> getDetail(String mktTaskCode) {
        List surveyListByCode;
        TMktTaskSurvey tMktTaskSurvey = (TMktTaskSurvey)this.tMktTaskSurveyService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTaskSurvey::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTaskSurvey::getValid, (Object)1));
        if (tMktTaskSurvey == null) {
            return ResponseUtil.getFailedMsg((String)"\u8c03\u67e5\u95ee\u5377\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        TMktTask tMktTask = (TMktTask)this.tMktTaskService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTask::getValid, (Object)1));
        if (tMktTask == null) {
            return ResponseUtil.getFailedMsg((String)"\u8c03\u67e5\u95ee\u5377\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        List mktTaskCouponList = this.tMktTaskCouponService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktTaskCoupon.class).eq(TMktTaskCoupon::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTaskCoupon::getValid, (Object)1));
        QueryDetailTaskSurveyRespVO respVO = new QueryDetailTaskSurveyRespVO();
        BeanUtil.copyProperties((Object)tMktTaskSurvey, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)tMktTask, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        respVO.setCouponCodeList((List)Optional.ofNullable(mktTaskCouponList).map(list -> list.stream().map(TMktTaskCoupon::getCouponCode).collect(Collectors.toList())).orElse(null));
        if (2 == tMktTask.getMbrConditionType() && StrUtil.isNotBlank((CharSequence)tMktTask.getMbrGroupDefCode())) {
            String mbrGroupName = this.apiMktCommonService.getMbrGroupName(tMktTask.getMbrGroupDefCode());
            respVO.setMbrGroupDefName(mbrGroupName);
        }
        if (CollUtil.isNotEmpty((Collection)(surveyListByCode = this.apiMktCommonService.getSurveyListByCode(Arrays.asList(tMktTaskSurvey.getMktTaskSurveyCode()))))) {
            respVO.setSurveyTemplateName(((MktSurveyVO)surveyListByCode.get(0)).getName());
        }
        return ResponseUtil.getSuccessData((Object)respVO);
    }

    public ResponseData<String> completeSurvey(CompleteSurveyBO completeSurveyBO) {
        log.info("completeSurvey completeSurveyBO:{}", (Object)JacksonUtil.bean2Json((Object)completeSurveyBO));
        String businessCode = completeSurveyBO.getBusinessCode();
        String surveyTemplateCode = completeSurveyBO.getSurveyTemplateCode();
        String mbrMemberCode = completeSurveyBO.getMbrMemberCode();
        String mbrGroupDefCode = "";
        List tMktTaskList = this.tMktTaskService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getValid, (Object)1)).eq(TMktTask::getTaskType, (Object)4)).eq(TMktTask::getCheckStatus, (Object)3)).eq(TMktTask::getTaskStatus, (Object)2)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TMktTask::getMbrConditionType, (Object)1)).or()).like(TMktTask::getMbrGroupDefCode, (Object)mbrGroupDefCode);
        }));
        log.info("tMktTaskList: {}", (Object)JacksonUtil.list2Json((List)tMktTaskList));
        if (CollUtil.isEmpty((Collection)tMktTaskList)) {
            log.info("\u6ca1\u6709\u8fdb\u884c\u4e2d\u7684\u8c03\u67e5\u95ee\u5377\u4efb\u52a1");
            return ResponseUtil.getFailedMsg((String)"\u6ca1\u6709\u8fdb\u884c\u4e2d\u7684\u8c03\u67e5\u95ee\u5377\u4efb\u52a1");
        }
        List mktTaskCodeList = tMktTaskList.stream().map(TMktTask::getMktTaskCode).collect(Collectors.toList());
        List recordList = this.tMktTaskSendRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTaskSendRecord::getValid, (Object)1)).eq(TMktTaskSendRecord::getMbrMembersCode, (Object)mbrMemberCode)).in(TMktTaskSendRecord::getMktTaskCode, mktTaskCodeList));
        log.info("recordList: {}", (Object)JacksonUtil.list2Json((List)recordList));
        Set joinedMktTaskCodeSet = Optional.ofNullable(recordList).map(list -> list.stream().map(TMktTaskSendRecord::getMktTaskCode).collect(Collectors.toSet())).orElse(new HashSet());
        tMktTaskList = tMktTaskList.stream().filter(item -> !joinedMktTaskCodeSet.contains(item.getMktTaskCode())).collect(Collectors.toList());
        mktTaskCodeList = mktTaskCodeList.stream().filter(item -> !joinedMktTaskCodeSet.contains(item)).collect(Collectors.toList());
        Map mktTaskMap = tMktTaskList.stream().collect(Collectors.toMap(TMktTask::getMktTaskCode, Function.identity()));
        List tMktTaskSurveyList = this.tMktTaskSurveyService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTaskSurvey::getValid, (Object)1)).eq(TMktTaskSurvey::getSurveyTemplateCode, (Object)surveyTemplateCode)).in(TMktTaskSurvey::getMktTaskCode, mktTaskCodeList));
        log.info("tMktTaskSurveyList: {}", (Object)JacksonUtil.list2Json((List)tMktTaskSurveyList));
        List mktTaskCouponList = this.tMktTaskCouponService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktTaskCoupon.class).eq(TMktTaskCoupon::getValid, (Object)1)).in(TMktTaskCoupon::getMktTaskCode, mktTaskCodeList));
        HashMap taskCouponListByTask = CollUtil.isNotEmpty((Collection)mktTaskCouponList) ? mktTaskCouponList.stream().collect(Collectors.groupingBy(TMktTaskCoupon::getMktTaskCode)) : new HashMap();
        for (TMktTaskSurvey tMktTaskSurvey : tMktTaskSurveyList) {
            String mktTaskCode = tMktTaskSurvey.getMktTaskCode();
            TMktTask tMktTask = (TMktTask)mktTaskMap.get(mktTaskCode);
            List tMktTaskCouponList = (List)taskCouponListByTask.get(mktTaskCode);
            String couponList = Optional.ofNullable(tMktTaskCouponList).map(list -> list.stream().map(TMktTaskCoupon::getCouponCode).collect(Collectors.joining(","))).orElse(null);
            SendTaskBO sendTaskBO = new SendTaskBO();
            sendTaskBO.setTaskType(tMktTask.getTaskType());
            sendTaskBO.setTaskNo(tMktTask.getTaskNo());
            sendTaskBO.setMktTaskCode(tMktTask.getMktTaskCode());
            sendTaskBO.setBusinessCode(businessCode);
            sendTaskBO.setIntegral(tMktTask.getIntegral());
            sendTaskBO.setCouponCodeList(couponList);
            this.apiMktTaskCommonService.sendTaskBenefit(sendTaskBO, Arrays.asList(mbrMemberCode));
        }
        return ResponseUtil.getSuccessData((Object)"\u901a\u77e5\u6210\u529f");
    }
}

