/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.mktcenter.api.domain.bo.MbrRegisterBO;
import com.bizvane.mktcenter.api.domain.bo.SendTaskBO;
import com.bizvane.mktcenter.api.service.ApiMktCommonService;
import com.bizvane.mktcenter.api.service.ApiMktTaskCommonService;
import com.bizvane.mktcenter.api.service.ApiMktTaskInviteRegisterService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMbrInviteRegisterRecord;
import com.bizvane.mktcenter.domain.domain.po.TMktTask;
import com.bizvane.mktcenter.domain.domain.po.TMktTaskCoupon;
import com.bizvane.mktcenter.domain.domain.po.TMktTaskInviteRegister;
import com.bizvane.mktcenter.domain.service.TMbrInviteRegisterRecordService;
import com.bizvane.mktcenter.domain.service.TMktTaskCouponService;
import com.bizvane.mktcenter.domain.service.TMktTaskInviteRegisterService;
import com.bizvane.mktcenter.domain.service.TMktTaskService;
import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktTaskInviteRegisterReqVO;
import com.bizvane.mktcenter.feign.vo.req.MktTaskVO;
import com.bizvane.mktcenter.feign.vo.req.QueryTaskAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailTaskInviteRegisterRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryTaskInviteRegisterAnalysisPageRespVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ApiMktTaskInviteRegisterServiceImpl
implements ApiMktTaskInviteRegisterService {
    private static final Logger log = LoggerFactory.getLogger(ApiMktTaskInviteRegisterServiceImpl.class);
    @Autowired
    private TMktTaskService tMktTaskService;
    @Autowired
    private TMktTaskInviteRegisterService tMktTaskInviteRegisterService;
    @Autowired
    private TMbrInviteRegisterRecordService tMbrInviteRegisterRecordService;
    @Autowired
    private ApiMktTaskCommonService apiMktTaskCommonService;
    @Autowired
    private TMktTaskCouponService tMktTaskCouponService;
    @Autowired
    private ApiMktCommonService apiMktCommonService;

    public ResponseData<String> saveOrUpdate(AddOrUpdateMktTaskInviteRegisterReqVO reqVO) {
        String mktTaskCode = reqVO.getMktTaskCode();
        TMktTask tMktActivity = null;
        TMktTaskInviteRegister tMktTaskInviteRegister = null;
        if (StrUtil.isNotBlank((CharSequence)mktTaskCode)) {
            tMktTaskInviteRegister = (TMktTaskInviteRegister)this.tMktTaskInviteRegisterService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTaskInviteRegister::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTaskInviteRegister::getValid, (Object)1));
            if (tMktTaskInviteRegister == null) {
                return ResponseUtil.getFailedMsg((String)"\u9080\u8bf7\u5165\u4f1a\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
            tMktActivity = (TMktTask)this.tMktTaskService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTask::getValid, (Object)1));
            if (tMktActivity == null) {
                return ResponseUtil.getFailedMsg((String)"\u9080\u8bf7\u5165\u4f1a\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
        } else {
            tMktActivity = new TMktTask();
            tMktTaskInviteRegister = new TMktTaskInviteRegister();
            mktTaskCode = IdUtil.fastSimpleUUID();
            tMktActivity.setMktTaskCode(mktTaskCode);
            tMktActivity.setTaskNo(IdUtil.fastSimpleUUID());
            tMktActivity.setTaskType(Integer.valueOf(1));
            tMktActivity.setTaskStatus(Integer.valueOf(1));
            tMktActivity.setCheckStatus(Integer.valueOf(1));
            tMktActivity.setValid(Integer.valueOf(1));
            tMktTaskInviteRegister.setMktTaskCode(mktTaskCode);
            tMktTaskInviteRegister.setMktTaskInviteRegisterCode(IdUtil.fastSimpleUUID());
            tMktTaskInviteRegister.setValid(Integer.valueOf(1));
        }
        this.apiMktTaskCommonService.saveCoupon((MktTaskVO)reqVO);
        BeanUtil.copyProperties((Object)reqVO, (Object)tMktTaskInviteRegister, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)reqVO, (Object)tMktActivity, (CopyOptions)CopyOptions.create().ignoreNullValue());
        this.tMktTaskService.saveOrUpdate((Object)tMktActivity);
        this.tMktTaskInviteRegisterService.saveOrUpdate((Object)tMktTaskInviteRegister);
        return ResponseUtil.getSuccessData((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public ResponseData<PageInfo<QueryTaskInviteRegisterAnalysisPageRespVO>> analysisPageList(QueryTaskAnalysisPageReqVO reqVO) {
        Page page = (Page)((Page)this.tMktTaskService.page((IPage)new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getTaskType, (Object)1)).eq(TMktTask::getValid, (Object)1)).eq(StrUtil.isNotBlank((CharSequence)reqVO.getTaskName()), TMktTask::getTaskName, (Object)reqVO.getTaskName())).eq(StrUtil.isNotBlank((CharSequence)reqVO.getTaskNo()), TMktTask::getTaskNo, (Object)reqVO.getTaskNo()))).convert(tMktActivity -> (QueryTaskInviteRegisterAnalysisPageRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktActivity), QueryTaskInviteRegisterAnalysisPageRespVO.class));
        PageInfo pageInfo = new PageInfo((int)page.getCurrent(), (int)page.getSize(), (long)((int)page.getTotal()), page.getRecords());
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    public ResponseData<QueryDetailTaskInviteRegisterRespVO> getDetail(String mktTaskCode) {
        TMktTaskInviteRegister tMktTaskInviteRegister = (TMktTaskInviteRegister)this.tMktTaskInviteRegisterService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTaskInviteRegister::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTaskInviteRegister::getValid, (Object)1));
        if (tMktTaskInviteRegister == null) {
            return ResponseUtil.getFailedMsg((String)"\u9080\u8bf7\u5165\u4f1a\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        TMktTask tMktTask = (TMktTask)this.tMktTaskService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTask::getValid, (Object)1));
        if (tMktTask == null) {
            return ResponseUtil.getFailedMsg((String)"\u9080\u8bf7\u5165\u4f1a\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        List mktTaskCouponList = this.tMktTaskCouponService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTaskCoupon::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTaskCoupon::getValid, (Object)1));
        QueryDetailTaskInviteRegisterRespVO respVO = new QueryDetailTaskInviteRegisterRespVO();
        BeanUtil.copyProperties((Object)tMktTaskInviteRegister, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)tMktTask, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        respVO.setCouponCodeList((List)Optional.ofNullable(mktTaskCouponList).map(list -> list.stream().map(TMktTaskCoupon::getCouponCode).collect(Collectors.toList())).orElse(null));
        if (2 == tMktTask.getMbrConditionType() && StrUtil.isNotBlank((CharSequence)tMktTask.getMbrGroupDefCode())) {
            String mbrGroupName = this.apiMktCommonService.getMbrGroupName(tMktTask.getMbrGroupDefCode());
            respVO.setMbrGroupDefName(mbrGroupName);
        }
        return ResponseUtil.getSuccessData((Object)respVO);
    }

    public void inviteRegisterConsumer(MbrRegisterBO mbrRegisterBO) {
        String mbrMemberCode = mbrRegisterBO.getMbrMemberCode();
        String inviteMemberCode = mbrRegisterBO.getInviteMemberCode();
        int count = (int)this.tMbrInviteRegisterRecordService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMbrInviteRegisterRecord::getMbrMembersCode, (Object)mbrMemberCode)).eq(TMbrInviteRegisterRecord::getInviteMemberCode, (Object)inviteMemberCode)).eq(TMbrInviteRegisterRecord::getValid, (Object)1));
        log.info("count: {}", (Object)count);
        if (count > 0) {
            log.info("\u5df2\u5b58\u5728\u9080\u8bf7\u8bb0\u5f55\uff0cmbrMemberCode: {}, inviteMemberCode: {}", (Object)mbrMemberCode, (Object)inviteMemberCode);
            return;
        }
        TMbrInviteRegisterRecord tMbrInviteRegisterRecord = new TMbrInviteRegisterRecord();
        tMbrInviteRegisterRecord.setMbrInviteRegisterRecordCode(IdUtil.fastSimpleUUID());
        tMbrInviteRegisterRecord.setMbrMembersCode(mbrMemberCode);
        tMbrInviteRegisterRecord.setInviteMemberCode(inviteMemberCode);
        tMbrInviteRegisterRecord.setInviteTime(mbrRegisterBO.getRegisterDate());
        tMbrInviteRegisterRecord.setValid(Integer.valueOf(1));
        this.tMbrInviteRegisterRecordService.save((Object)tMbrInviteRegisterRecord);
        List tMktTaskList = this.tMktTaskService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getValid, (Object)1)).eq(TMktTask::getTaskType, (Object)1)).eq(TMktTask::getCheckStatus, (Object)3)).eq(TMktTask::getTaskStatus, (Object)2));
        log.info("tMktTaskList: {}", (Object)JacksonUtil.list2Json((List)tMktTaskList));
        String mbrGroupDefCode = "";
        if (CollUtil.isNotEmpty((Collection)tMktTaskList)) {
            for (TMktTask tMktTask : tMktTaskList) {
                Integer taskMbrConditionType = tMktTask.getMbrConditionType();
                String taskMbrGroupDefCode = tMktTask.getMbrGroupDefCode();
                if (ObjUtil.equals((Object)taskMbrConditionType, (Object)2) && !StrUtil.equals((CharSequence)taskMbrGroupDefCode, (CharSequence)mbrGroupDefCode)) continue;
                List mktTaskCouponList = this.tMktTaskCouponService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTaskCoupon::getMktTaskCode, (Object)tMktTask.getMktTaskCode())).eq(TMktTaskCoupon::getValid, (Object)1));
                String couponList = Optional.ofNullable(mktTaskCouponList).map(list -> list.stream().map(TMktTaskCoupon::getCouponCode).collect(Collectors.joining(","))).orElse(null);
                TMktTaskInviteRegister tMktTaskInviteRegister = (TMktTaskInviteRegister)this.tMktTaskInviteRegisterService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTaskInviteRegister::getMktTaskCode, (Object)tMktTask.getMktTaskCode())).eq(TMktTaskInviteRegister::getMktTaskCode, (Object)tMktTask.getMktTaskCode())).eq(TMktTaskInviteRegister::getValid, (Object)1));
                Integer exeType = tMktTaskInviteRegister.getExeType();
                Integer cycleInviteTotalLimit = tMktTaskInviteRegister.getCycleInviteTotalLimit();
                Integer inviteLimit = tMktTaskInviteRegister.getInviteLimit();
                int inviteTotal = (int)this.tMbrInviteRegisterRecordService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMbrInviteRegisterRecord::getInviteMemberCode, (Object)inviteMemberCode)).eq(TMbrInviteRegisterRecord::getValid, (Object)1));
                if (ObjUtil.equals((Object)exeType, (Object)2) && cycleInviteTotalLimit >= inviteTotal && inviteTotal % inviteLimit == 0) {
                    this.apiMktTaskCommonService.sendTaskBenefit(ApiMktTaskInviteRegisterServiceImpl.getSendTaskBO((TMktTask)tMktTask, (String)couponList, (TMbrInviteRegisterRecord)tMbrInviteRegisterRecord), Arrays.asList(mbrMemberCode));
                }
                if (!ObjUtil.equals((Object)exeType, (Object)1) || inviteTotal != inviteLimit) continue;
                this.apiMktTaskCommonService.sendTaskBenefit(ApiMktTaskInviteRegisterServiceImpl.getSendTaskBO((TMktTask)tMktTask, (String)couponList, (TMbrInviteRegisterRecord)tMbrInviteRegisterRecord), Arrays.asList(mbrMemberCode));
            }
        }
    }

    private static SendTaskBO getSendTaskBO(TMktTask tMktTask, String couponList, TMbrInviteRegisterRecord tMbrInviteRegisterRecord) {
        SendTaskBO sendTaskBO = new SendTaskBO();
        sendTaskBO.setMktTaskCode(tMktTask.getMktTaskCode());
        sendTaskBO.setTaskType(tMktTask.getTaskType());
        sendTaskBO.setIntegral(tMktTask.getIntegral());
        sendTaskBO.setCouponCodeList(couponList);
        sendTaskBO.setTaskNo(tMktTask.getTaskNo());
        sendTaskBO.setBusinessCode(tMbrInviteRegisterRecord.getMbrInviteRegisterRecordCode());
        return sendTaskBO;
    }
}

