/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.mktcenter.api.domain.bo.NotifyBoardInfoBO;
import com.bizvane.mktcenter.api.domain.bo.SendTaskBO;
import com.bizvane.mktcenter.api.service.ApiMktCommonService;
import com.bizvane.mktcenter.api.service.ApiMktTaskBoardService;
import com.bizvane.mktcenter.api.service.ApiMktTaskCommonService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMktTask;
import com.bizvane.mktcenter.domain.domain.po.TMktTaskCoupon;
import com.bizvane.mktcenter.domain.domain.po.TMktTaskMbrBoard;
import com.bizvane.mktcenter.domain.service.TMktTaskCouponService;
import com.bizvane.mktcenter.domain.service.TMktTaskMbrBoardService;
import com.bizvane.mktcenter.domain.service.TMktTaskService;
import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktTaskBoardReqVO;
import com.bizvane.mktcenter.feign.vo.req.MktTaskVO;
import com.bizvane.mktcenter.feign.vo.req.QueryTaskAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailTaskBoardRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryTaskBoardAnalysisPageRespVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMktTaskBoardServiceImpl
implements ApiMktTaskBoardService {
    private static final Logger log = LoggerFactory.getLogger(ApiMktTaskBoardServiceImpl.class);
    @Autowired
    private TMktTaskService tMktTaskService;
    @Autowired
    private TMktTaskMbrBoardService tMktTaskMbrBoardService;
    @Autowired
    private ApiMktTaskCommonService apiMktTaskCommonService;
    @Autowired
    private TMktTaskCouponService tMktTaskCouponService;
    @Autowired
    private ApiMktCommonService apiMktCommonService;

    public ResponseData<String> saveOrUpdate(AddOrUpdateMktTaskBoardReqVO reqVO) {
        String mktTaskCode = reqVO.getMktTaskCode();
        TMktTask tMktTask = null;
        TMktTaskMbrBoard tMktTaskBoard = null;
        if (StrUtil.isNotBlank((CharSequence)mktTaskCode)) {
            tMktTaskBoard = (TMktTaskMbrBoard)this.tMktTaskMbrBoardService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTaskMbrBoard::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTaskMbrBoard::getValid, (Object)1));
            if (tMktTaskBoard == null) {
                return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u4e58\u673a\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
            tMktTask = (TMktTask)this.tMktTaskService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTask::getValid, (Object)1));
            if (tMktTask == null) {
                return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u4e58\u673a\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
        } else {
            tMktTask = new TMktTask();
            tMktTaskBoard = new TMktTaskMbrBoard();
            mktTaskCode = IdUtil.fastSimpleUUID();
            tMktTask.setMktTaskCode(mktTaskCode);
            tMktTask.setTaskNo(IdUtil.fastSimpleUUID());
            tMktTask.setTaskType(Integer.valueOf(3));
            tMktTask.setTaskStatus(Integer.valueOf(1));
            tMktTask.setCheckStatus(Integer.valueOf(1));
            tMktTask.setValid(Integer.valueOf(1));
            tMktTaskBoard.setMktTaskCode(mktTaskCode);
            tMktTaskBoard.setMktTaskMbrBoardCode(IdUtil.fastSimpleUUID());
            tMktTaskBoard.setValid(Integer.valueOf(1));
        }
        this.apiMktTaskCommonService.saveCoupon((MktTaskVO)reqVO);
        BeanUtil.copyProperties((Object)reqVO, (Object)tMktTaskBoard, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)reqVO, (Object)tMktTask, (CopyOptions)CopyOptions.create().ignoreNullValue());
        tMktTaskBoard.setAirportCode((String)Optional.ofNullable(reqVO.getAirportCodeList()).map(list -> String.join((CharSequence)",", list)).orElse(null));
        tMktTaskBoard.setBusinessCode((String)Optional.ofNullable(reqVO.getBusinessCodeList()).map(list -> String.join((CharSequence)",", list)).orElse(null));
        this.tMktTaskService.saveOrUpdate((Object)tMktTask);
        this.tMktTaskMbrBoardService.saveOrUpdate((Object)tMktTaskBoard);
        return ResponseUtil.getSuccessData((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public ResponseData<PageInfo<QueryTaskBoardAnalysisPageRespVO>> analysisPageList(QueryTaskAnalysisPageReqVO reqVO) {
        Page page = (Page)((Page)this.tMktTaskService.page((IPage)new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getTaskType, (Object)3)).eq(TMktTask::getValid, (Object)1)).eq(StrUtil.isNotBlank((CharSequence)reqVO.getTaskName()), TMktTask::getTaskName, (Object)reqVO.getTaskName())).eq(StrUtil.isNotBlank((CharSequence)reqVO.getTaskNo()), TMktTask::getTaskNo, (Object)reqVO.getTaskNo()))).convert(tMktTask -> (QueryTaskBoardAnalysisPageRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktTask), QueryTaskBoardAnalysisPageRespVO.class));
        PageInfo pageInfo = new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), page.getRecords());
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    public ResponseData<QueryDetailTaskBoardRespVO> getDetail(String mktTaskCode) {
        TMktTaskMbrBoard tMktTaskBoard = (TMktTaskMbrBoard)this.tMktTaskMbrBoardService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTaskMbrBoard::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTaskMbrBoard::getValid, (Object)1));
        if (tMktTaskBoard == null) {
            return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u4e58\u673a\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        TMktTask tMktTask = (TMktTask)this.tMktTaskService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTask::getValid, (Object)1));
        if (tMktTask == null) {
            return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u4e58\u673a\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        List mktTaskCouponList = this.tMktTaskCouponService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktTaskCoupon.class).eq(TMktTaskCoupon::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTaskCoupon::getValid, (Object)1));
        QueryDetailTaskBoardRespVO respVO = new QueryDetailTaskBoardRespVO();
        BeanUtil.copyProperties((Object)tMktTaskBoard, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)tMktTask, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        respVO.setCouponCodeList((List)Optional.ofNullable(mktTaskCouponList).map(list -> list.stream().map(TMktTaskCoupon::getCouponCode).collect(Collectors.toList())).orElse(null));
        List airportCodeList = Optional.ofNullable(tMktTaskBoard.getAirportCode()).map(str -> Arrays.asList(str.split(","))).orElse(null);
        List airportListByCode = this.apiMktCommonService.getAirportListByCode(airportCodeList);
        respVO.setAirportCodeList(airportListByCode);
        List businessCodeList = Optional.ofNullable(tMktTaskBoard.getBusinessCode()).map(str -> Arrays.asList(str.split(","))).orElse(null);
        List businessListByCode = this.apiMktCommonService.getBusinessListByCode(businessCodeList);
        respVO.setBusinessCodeList(businessListByCode);
        if (2 == tMktTask.getMbrConditionType() && StrUtil.isNotBlank((CharSequence)tMktTask.getMbrGroupDefCode())) {
            String mbrGroupName = this.apiMktCommonService.getMbrGroupName(tMktTask.getMbrGroupDefCode());
            respVO.setMbrGroupDefName(mbrGroupName);
        }
        return ResponseUtil.getSuccessData((Object)respVO);
    }

    public ResponseData<String> notifyBoardInfo(NotifyBoardInfoBO notifyBoardInfoBO) {
        log.info("notifyBoardInfo notifyBoardInfoBO:{}", (Object)JacksonUtil.bean2Json((Object)notifyBoardInfoBO));
        String businessCode = notifyBoardInfoBO.getBusinessCode();
        String airportCode = notifyBoardInfoBO.getAirportCode();
        List mbrMemberCodeList = notifyBoardInfoBO.getMbrMemberCodeList();
        List tMktTaskList = this.tMktTaskService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getValid, (Object)1)).eq(TMktTask::getTaskType, (Object)3)).eq(TMktTask::getCheckStatus, (Object)3)).eq(TMktTask::getTaskStatus, (Object)2));
        log.info("tMktTaskList: {}", (Object)JacksonUtil.list2Json((List)tMktTaskList));
        if (CollUtil.isEmpty((Collection)tMktTaskList)) {
            log.info("\u6ca1\u6709\u8fdb\u884c\u4e2d\u7684\u4f1a\u5458\u4e58\u673a\u4efb\u52a1");
            return ResponseUtil.getFailedMsg((String)"\u6ca1\u6709\u8fdb\u884c\u4e2d\u7684\u4f1a\u5458\u4e58\u673a\u4efb\u52a1");
        }
        List mktTaskCodeList = tMktTaskList.stream().map(TMktTask::getMktTaskCode).collect(Collectors.toList());
        List tMktTaskMbrBoardList = this.tMktTaskMbrBoardService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTaskMbrBoard::getValid, (Object)1)).in(TMktTaskMbrBoard::getMktTaskCode, mktTaskCodeList));
        log.info("tMktTaskMbrBoardList: {}", (Object)JacksonUtil.list2Json((List)tMktTaskMbrBoardList));
        Map tMktTaskMbrBoardMap = tMktTaskMbrBoardList.stream().collect(Collectors.toMap(TMktTaskMbrBoard::getMktTaskCode, Function.identity()));
        for (TMktTask tMktTask : tMktTaskList) {
            String mktTaskCode = tMktTask.getMktTaskCode();
            TMktTaskMbrBoard tMktTaskMbrBoard = (TMktTaskMbrBoard)tMktTaskMbrBoardMap.get(mktTaskCode);
            String airportCodeList = tMktTaskMbrBoard.getAirportCode();
            String businessCodeList = tMktTaskMbrBoard.getBusinessCode();
            if (StrUtil.isBlank((CharSequence)airportCodeList) || !Arrays.asList(airportCodeList.split(",")).contains(airportCode) || StrUtil.isBlank((CharSequence)businessCodeList) || !Arrays.asList(businessCodeList.split(",")).contains(businessCode)) {
                return ResponseUtil.getFailedMsg((String)"\u822a\u73ed\u4fe1\u606f\u4e0d\u6ee1\u8db3\u4f1a\u5458\u4e58\u673a\u4efb\u52a1\u6761\u4ef6");
            }
            Integer mbrConditionType = tMktTask.getMbrConditionType();
            List mbrMemberCodeByGroup = mbrMemberCodeList;
            if (mbrConditionType == 2) {
                mbrMemberCodeByGroup = mbrMemberCodeList.stream().filter(item -> true).collect(Collectors.toList());
            }
            List mktTaskCouponList = this.tMktTaskCouponService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktTaskCoupon.class).eq(TMktTaskCoupon::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTaskCoupon::getValid, (Object)1));
            SendTaskBO sendTaskBO = new SendTaskBO();
            sendTaskBO.setTaskType(tMktTask.getTaskType());
            sendTaskBO.setTaskNo(tMktTask.getTaskNo());
            sendTaskBO.setMktTaskCode(tMktTask.getMktTaskCode());
            sendTaskBO.setBusinessCode(notifyBoardInfoBO.getBusinessCode());
            sendTaskBO.setIntegral(tMktTask.getIntegral());
            sendTaskBO.setCouponCodeList((String)Optional.ofNullable(mktTaskCouponList).map(list -> list.stream().map(TMktTaskCoupon::getCouponCode).collect(Collectors.joining(","))).orElse(null));
            this.apiMktTaskCommonService.sendTaskBenefit(sendTaskBO, mbrMemberCodeByGroup);
        }
        return ResponseUtil.getSuccessData((Object)"\u901a\u77e5\u6210\u529f");
    }
}

