/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.mktcenter.api.service.ApiMktPopupAdvertisementService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMktPopAdvertisementManage;
import com.bizvane.mktcenter.domain.domain.po.TMktPopupAdvertisement;
import com.bizvane.mktcenter.domain.service.TMktPopAdvertisementManageService;
import com.bizvane.mktcenter.domain.service.TMktPopupAdvertisementService;
import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktPopupAdvertisementReqVO;
import com.bizvane.mktcenter.feign.vo.req.AddOrUpdatePopAdvertisementManageReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryTaskPopupAdvertisementPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailMktPopupAdvertisementReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailPopAdvertisementRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryTaskPopupAdvertisementPageRespVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMktPopupAdvertisementServiceImpl
implements ApiMktPopupAdvertisementService {
    private static final Logger log = LoggerFactory.getLogger(ApiMktPopupAdvertisementServiceImpl.class);
    @Autowired
    private TMktPopupAdvertisementService tMktPopupAdvertisementService;
    @Autowired
    private TMktPopAdvertisementManageService tMktPopAdvertisementManageService;

    public ResponseData<String> saveOrUpdate(AddOrUpdateMktPopupAdvertisementReqVO reqVO) {
        String popupAdvertisementCode = reqVO.getPopupAdvertisementCode();
        Integer mbrConditionType = reqVO.getMbrConditionType();
        TMktPopupAdvertisement tMktPopupAdvertisement = (TMktPopupAdvertisement)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)reqVO), TMktPopupAdvertisement.class);
        if (StrUtil.isNotBlank((CharSequence)popupAdvertisementCode)) {
            this.tMktPopupAdvertisementService.update((Object)tMktPopupAdvertisement, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TMktPopupAdvertisement::getPopupAdvertisementCode, (Object)popupAdvertisementCode)).eq(TMktPopupAdvertisement::getValid, (Object)1));
        } else {
            tMktPopupAdvertisement.setPopupAdvertisementCode(IdUtil.fastSimpleUUID());
            tMktPopupAdvertisement.setStatus(Integer.valueOf(1));
            if (ObjUtil.equals((Object)mbrConditionType, (Object)1)) {
                tMktPopupAdvertisement.setMbrGroupDefCode(null);
            }
            this.tMktPopupAdvertisementService.save((Object)tMktPopupAdvertisement);
        }
        return ResponseUtil.getSuccessData((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public ResponseData<PageInfo<QueryTaskPopupAdvertisementPageRespVO>> pageList(QueryTaskPopupAdvertisementPageReqVO reqVO) {
        Page page = (Page)((Page)this.tMktPopupAdvertisementService.page((IPage)new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StrUtil.isNotBlank((CharSequence)reqVO.getAdvertisementName()), TMktPopupAdvertisement::getAdvertisementName, (Object)reqVO.getAdvertisementName())).eq(reqVO.getPopupStatus() != null, TMktPopupAdvertisement::getPopupStatus, (Object)reqVO.getPopupStatus())).lt(reqVO.getStartTime() != null, TMktPopupAdvertisement::getStartTime, (Object)reqVO.getStartTime())).gt(reqVO.getEndTime() != null, TMktPopupAdvertisement::getEndTime, (Object)reqVO.getEndTime())).lt(reqVO.getCreateDateStart() != null, TMktPopupAdvertisement::getCreateDate, (Object)reqVO.getCreateDateStart())).gt(reqVO.getCreateDateEnd() != null, TMktPopupAdvertisement::getCreateDate, (Object)reqVO.getCreateDateEnd())).eq(StrUtil.isNotBlank((CharSequence)reqVO.getCreateUserName()), TMktPopupAdvertisement::getCreateUserName, (Object)reqVO.getCreateUserName()))).convert(item -> {
            QueryTaskPopupAdvertisementPageRespVO respVO = (QueryTaskPopupAdvertisementPageRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)item), QueryTaskPopupAdvertisementPageRespVO.class);
            return respVO;
        });
        PageInfo pageInfo = new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), page.getRecords());
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    public ResponseData<QueryDetailMktPopupAdvertisementReqVO> getDetail(String popupAdvertisementCode) {
        TMktPopupAdvertisement tMktPopupAdvertisement = (TMktPopupAdvertisement)this.tMktPopupAdvertisementService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktPopupAdvertisement::getPopupAdvertisementCode, (Object)popupAdvertisementCode)).eq(TMktPopupAdvertisement::getValid, (Object)1));
        QueryDetailMktPopupAdvertisementReqVO respVO = (QueryDetailMktPopupAdvertisementReqVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktPopupAdvertisement), QueryDetailMktPopupAdvertisementReqVO.class);
        return ResponseUtil.getSuccessData((Object)respVO);
    }

    public ResponseData<String> updateShelfStatus(String popupAdvertisementCode, Integer status) {
        log.info("updateStatus popupAdvertisementCode: {}, status: {}", (Object)popupAdvertisementCode, (Object)status);
        boolean update = this.tMktPopupAdvertisementService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TMktPopupAdvertisement::getPopupAdvertisementCode, (Object)popupAdvertisementCode)).eq(TMktPopupAdvertisement::getValid, (Object)1)).set(TMktPopupAdvertisement::getStatus, (Object)(status > 0 ? 1 : 0)));
        log.info("update: {}", (Object)JacksonUtil.bean2Json((Object)update));
        return ResponseUtil.getSuccessData((Object)"\u4fee\u6539\u4e0a\u4e0b\u67b6\u72b6\u6001\u6210\u529f");
    }

    public ResponseData<String> disable(String popupAdvertisementCode) {
        log.info("disable popupAdvertisementCode: {}", (Object)popupAdvertisementCode);
        boolean update = this.tMktPopupAdvertisementService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TMktPopupAdvertisement::getPopupAdvertisementCode, (Object)popupAdvertisementCode)).eq(TMktPopupAdvertisement::getValid, (Object)1)).set(TMktPopupAdvertisement::getPopupStatus, (Object)4));
        return ResponseUtil.getSuccessData((Object)"\u4fee\u6539\u72b6\u6001\u6210\u529f");
    }

    public ResponseData<String> updateSort(String popupAdvertisementCode, Integer sort) {
        log.info("updateSort popupAdvertisementCode: {}", (Object)popupAdvertisementCode);
        boolean update = this.tMktPopupAdvertisementService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TMktPopupAdvertisement::getPopupAdvertisementCode, (Object)popupAdvertisementCode)).eq(TMktPopupAdvertisement::getValid, (Object)1)).set(TMktPopupAdvertisement::getSort, (Object)sort));
        return ResponseUtil.getSuccessData((Object)"\u4fee\u6539\u6392\u5e8f\u6210\u529f");
    }

    public ResponseData<String> saveOrUpdateManage(AddOrUpdatePopAdvertisementManageReqVO reqVO) {
        TMktPopAdvertisementManage advertisementManage = (TMktPopAdvertisementManage)this.tMktPopAdvertisementManageService.getOne((Wrapper)new LambdaQueryWrapper().eq(TMktPopAdvertisementManage::getValid, (Object)1));
        if (advertisementManage != null) {
            this.tMktPopAdvertisementManageService.updateById((Object)advertisementManage);
        } else {
            advertisementManage = new TMktPopAdvertisementManage();
            advertisementManage.setMktPopAdvertisementManageCode(IdUtil.fastSimpleUUID());
            advertisementManage.setValid(Integer.valueOf(1));
        }
        advertisementManage.setPlaySecond(reqVO.getPlaySecond());
        advertisementManage.setSelectedPointColor(reqVO.getSelectedPointColor());
        advertisementManage.setNoSelectedPointColor(reqVO.getNoSelectedPointColor());
        this.tMktPopAdvertisementManageService.saveOrUpdate((Object)advertisementManage);
        return ResponseUtil.getSuccessData((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public ResponseData<QueryDetailPopAdvertisementRespVO> getManage() {
        TMktPopAdvertisementManage advertisementManage = (TMktPopAdvertisementManage)this.tMktPopAdvertisementManageService.getOne((Wrapper)new LambdaQueryWrapper().eq(TMktPopAdvertisementManage::getValid, (Object)1));
        QueryDetailPopAdvertisementRespVO respVO = new QueryDetailPopAdvertisementRespVO();
        if (advertisementManage != null) {
            respVO = (QueryDetailPopAdvertisementRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)advertisementManage), QueryDetailPopAdvertisementRespVO.class);
        }
        return ResponseUtil.getSuccessData((Object)respVO);
    }
}

