/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.message.feign.api.MsgMailTempFeign;
import com.bizvane.message.feign.api.MsgWeChatMiniProTemplateFeign;
import com.bizvane.message.feign.enums.msg.MsgTemplateTypeEnum;
import com.bizvane.message.feign.vo.mail.MsgMailTempDetailRequestVO;
import com.bizvane.message.feign.vo.mail.MsgMailTempDetailResponseVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempDetailRequestVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempDetailResponseVO;
import com.bizvane.mktcenter.api.service.ApiMktBatchSendMessageService;
import com.bizvane.mktcenter.api.service.ApiMktCommonService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.api.utils.SysResponseEnum;
import com.bizvane.mktcenter.domain.domain.po.TMktBatchSendMessage;
import com.bizvane.mktcenter.domain.service.TMktBatchSendMessageService;
import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktBatchSendMessageReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryMktBatchSendMessagePageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailBatchSendMessageRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryMktBatchSendMessagePageRespVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMktBatchSendMessageServiceImpl
implements ApiMktBatchSendMessageService {
    private static final Logger log = LoggerFactory.getLogger(ApiMktBatchSendMessageServiceImpl.class);
    @Autowired
    private TMktBatchSendMessageService tMktBatchSendMessageService;
    @Autowired
    private MsgWeChatMiniProTemplateFeign msgWeChatMiniProTemplateFeign;
    @Autowired
    private MsgMailTempFeign msgMailTempFeign;
    @Autowired
    private ApiMktCommonService apiMktCommonService;

    public ResponseData<String> saveOrUpdate(AddOrUpdateMktBatchSendMessageReqVO reqVO) {
        String mktBatchSendMessageCode = reqVO.getMktBatchSendMessageCode();
        TMktBatchSendMessage tMktBatchSendMessage = (TMktBatchSendMessage)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)reqVO), TMktBatchSendMessage.class);
        if (StrUtil.isNotBlank((CharSequence)mktBatchSendMessageCode)) {
            this.tMktBatchSendMessageService.update((Object)tMktBatchSendMessage, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktBatchSendMessage.class).eq(TMktBatchSendMessage::getMktBatchSendMessageCode, (Object)mktBatchSendMessageCode)).eq(TMktBatchSendMessage::getValid, (Object)1));
        } else {
            tMktBatchSendMessage.setMktBatchSendMessageCode(IdUtil.fastSimpleUUID());
            tMktBatchSendMessage.setCreateUserCode(reqVO.getUserCode());
            tMktBatchSendMessage.setCreateUserName(reqVO.getUserName());
            tMktBatchSendMessage.setModifiedUserCode(reqVO.getUserCode());
            tMktBatchSendMessage.setModifiedUserName(reqVO.getUserName());
            this.tMktBatchSendMessageService.save((Object)tMktBatchSendMessage);
        }
        return ResponseUtil.getSuccessData((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public ResponseData<PageInfo<QueryMktBatchSendMessagePageRespVO>> pageList(QueryMktBatchSendMessagePageReqVO reqVO) {
        IPage page = ((Page)this.tMktBatchSendMessageService.page((IPage)new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktBatchSendMessage.class).eq(StrUtil.isNotBlank((CharSequence)reqVO.getSendMessageName()), TMktBatchSendMessage::getSendMessageName, (Object)reqVO.getSendMessageName())).eq(reqVO.getSendMessageType() != null, TMktBatchSendMessage::getSendMessageType, (Object)reqVO.getSendMessageType())).eq(reqVO.getStatus() != null, TMktBatchSendMessage::getStatus, (Object)reqVO.getStatus())).eq(reqVO.getCheckStatus() != null, TMktBatchSendMessage::getCheckStatus, (Object)reqVO.getCheckStatus())).eq(StrUtil.isNotBlank((CharSequence)reqVO.getMessageTemplateName()), TMktBatchSendMessage::getMessageTemplateName, (Object)reqVO.getMessageTemplateName())).gt(reqVO.getExeTimeStart() != null, TMktBatchSendMessage::getExeTime, (Object)reqVO.getExeTimeStart())).lt(reqVO.getExeTimeEnd() != null, TMktBatchSendMessage::getExeTime, (Object)reqVO.getExeTimeEnd())).eq(TMktBatchSendMessage::getValid, (Object)1)).orderByDesc(TMktBatchSendMessage::getId))).convert(item -> {
            QueryMktBatchSendMessagePageRespVO respVO = (QueryMktBatchSendMessagePageRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)item), QueryMktBatchSendMessagePageRespVO.class);
            return respVO;
        });
        PageInfo resultPage = new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), page.getRecords());
        return ResponseUtil.getSuccessData((Object)resultPage);
    }

    public ResponseData<QueryDetailBatchSendMessageRespVO> getDetail(String mktBatchSendMessageCode) {
        MsgWxMiniProTempDetailRequestVO requestVO;
        TMktBatchSendMessage tMktBatchSendMessage = (TMktBatchSendMessage)this.tMktBatchSendMessageService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktBatchSendMessage.class).eq(TMktBatchSendMessage::getMktBatchSendMessageCode, (Object)mktBatchSendMessageCode)).eq(TMktBatchSendMessage::getValid, (Object)1));
        QueryDetailBatchSendMessageRespVO respVO = (QueryDetailBatchSendMessageRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktBatchSendMessage), QueryDetailBatchSendMessageRespVO.class);
        Integer sendMessageType = tMktBatchSendMessage.getSendMessageType();
        String messageTemplateCode = tMktBatchSendMessage.getMessageTemplateCode();
        if (sendMessageType == 1) {
            requestVO = new MsgWxMiniProTempDetailRequestVO();
            requestVO.setMsgWxMiniProTempCode(messageTemplateCode);
            requestVO.setTemplateType(MsgTemplateTypeEnum.MKT_MASS_MESSAGE.getCode());
            ResponseData msgWxMiniProTempDetailResponseVOResponseData = this.msgWeChatMiniProTemplateFeign.detailByCode(requestVO);
            if (msgWxMiniProTempDetailResponseVOResponseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
                respVO.setMsgWxMiniProTempDetailResponseVO((MsgWxMiniProTempDetailResponseVO)msgWxMiniProTempDetailResponseVOResponseData.getData());
            }
        } else if (sendMessageType != 2) {
            requestVO = new MsgMailTempDetailRequestVO();
            requestVO.setMsgMailTempCode(messageTemplateCode);
            ResponseData detail = this.msgMailTempFeign.detail((MsgMailTempDetailRequestVO)requestVO);
            if (detail.getCode() == SysResponseEnum.SUCCESS.getCode()) {
                respVO.setMsgMailTempDetailResponseVO((MsgMailTempDetailResponseVO)detail.getData());
            }
        }
        if (2 == tMktBatchSendMessage.getMbrConditionType() && StrUtil.isNotBlank((CharSequence)tMktBatchSendMessage.getMbrGroupDefCode())) {
            String mbrGroupName = this.apiMktCommonService.getMbrGroupName(tMktBatchSendMessage.getMbrGroupDefCode());
            respVO.setMbrGroupDefName(mbrGroupName);
        }
        return ResponseUtil.getSuccessData((Object)respVO);
    }

    public ResponseData<String> disable(String mktBatchSendMessageCode) {
        TMktBatchSendMessage tMktBatchSendMessage = new TMktBatchSendMessage();
        tMktBatchSendMessage.setStatus(Integer.valueOf(4));
        this.tMktBatchSendMessageService.update((Object)tMktBatchSendMessage, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktBatchSendMessage.class).eq(TMktBatchSendMessage::getMktBatchSendMessageCode, (Object)mktBatchSendMessageCode)).eq(TMktBatchSendMessage::getValid, (Object)1));
        return ResponseUtil.getSuccessData((Object)"\u7981\u7528\u6210\u529f");
    }
}

