/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.mktcenter.api.domain.bo.MbrLevelUpgradeBO;
import com.bizvane.mktcenter.api.domain.bo.SendActivityBO;
import com.bizvane.mktcenter.api.service.ApiMktActivityCommonService;
import com.bizvane.mktcenter.api.service.ApiMktActivityUpgradeService;
import com.bizvane.mktcenter.api.service.ApiMktCommonService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMktActivity;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityCoupon;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityUpgrade;
import com.bizvane.mktcenter.domain.service.TMktActivityCouponService;
import com.bizvane.mktcenter.domain.service.TMktActivityService;
import com.bizvane.mktcenter.domain.service.TMktActivityUpgradeService;
import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktActivityUpgradeReqVO;
import com.bizvane.mktcenter.feign.vo.req.MktActivityVO;
import com.bizvane.mktcenter.feign.vo.req.QueryActivityAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivityUpgradeAnalysisPageRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailActivityUpgradeRespVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMktActivityUpgradeServiceImpl
implements ApiMktActivityUpgradeService {
    private static final Logger log = LoggerFactory.getLogger(ApiMktActivityUpgradeServiceImpl.class);
    @Autowired
    private TMktActivityService tMktActivityService;
    @Autowired
    private TMktActivityUpgradeService tMktActivityUpgradeService;
    @Autowired
    private ApiMktActivityCommonService apiMktActivityCommonService;
    @Autowired
    private TMktActivityCouponService tMktActivityCouponService;
    @Autowired
    private ApiMktCommonService apiMktCommonService;

    public ResponseData<String> saveOrUpdate(AddOrUpdateMktActivityUpgradeReqVO reqVO) {
        String mktActivityCode = reqVO.getMktActivityCode();
        TMktActivity tMktActivity = null;
        TMktActivityUpgrade tMktActivityUpgrade = null;
        if (StrUtil.isNotBlank((CharSequence)mktActivityCode)) {
            tMktActivityUpgrade = (TMktActivityUpgrade)this.tMktActivityUpgradeService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityUpgrade::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityUpgrade::getValid, (Object)1));
            if (tMktActivityUpgrade == null) {
                return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u5347\u7ea7\u6d3b\u52a8\u4e0d\u5b58\u5728");
            }
            tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivity::getValid, (Object)1));
            if (tMktActivity == null) {
                return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u5347\u7ea7\u6d3b\u52a8\u4e0d\u5b58\u5728");
            }
        } else {
            tMktActivity = new TMktActivity();
            tMktActivityUpgrade = new TMktActivityUpgrade();
            mktActivityCode = IdUtil.fastSimpleUUID();
            tMktActivity.setMktActivityCode(mktActivityCode);
            tMktActivity.setActivityNo(IdUtil.fastSimpleUUID());
            tMktActivity.setActivityType(Integer.valueOf(2));
            tMktActivity.setActivityStatus(Integer.valueOf(1));
            tMktActivity.setCheckStatus(Integer.valueOf(1));
            tMktActivity.setValid(Integer.valueOf(1));
            tMktActivityUpgrade.setMktActivityCode(mktActivityCode);
            tMktActivityUpgrade.setMktActivityUpgradeCode(IdUtil.fastSimpleUUID());
            tMktActivityUpgrade.setValid(Integer.valueOf(1));
        }
        this.apiMktActivityCommonService.saveCoupon((MktActivityVO)reqVO);
        BeanUtil.copyProperties((Object)reqVO, (Object)tMktActivityUpgrade, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)reqVO, (Object)tMktActivity, (CopyOptions)CopyOptions.create().ignoreNullValue());
        tMktActivityUpgrade.setUpgradeLevelCode(reqVO.getUpgradeLevelCodeList().stream().collect(Collectors.joining(",")));
        this.tMktActivityService.saveOrUpdate((Object)tMktActivity);
        this.tMktActivityUpgradeService.saveOrUpdate((Object)tMktActivityUpgrade);
        return ResponseUtil.getSuccessData((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public ResponseData<PageInfo<QueryActivityUpgradeAnalysisPageRespVO>> analysisPageList(QueryActivityAnalysisPageReqVO reqVO) {
        Page page = (Page)((Page)this.tMktActivityService.page((IPage)new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getActivityType, (Object)2)).eq(TMktActivity::getValid, (Object)1)).eq(StrUtil.isNotBlank((CharSequence)reqVO.getActivityName()), TMktActivity::getActivityName, (Object)reqVO.getActivityName())).eq(StrUtil.isNotBlank((CharSequence)reqVO.getActivityNo()), TMktActivity::getActivityNo, (Object)reqVO.getActivityNo()))).convert(tMktActivity -> (QueryActivityUpgradeAnalysisPageRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktActivity), QueryActivityUpgradeAnalysisPageRespVO.class));
        PageInfo pageInfo = new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), page.getRecords());
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    public ResponseData<QueryDetailActivityUpgradeRespVO> getDetail(String mktActivityCode) {
        TMktActivityUpgrade tMktActivityUpgrade = (TMktActivityUpgrade)this.tMktActivityUpgradeService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityUpgrade::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityUpgrade::getValid, (Object)1));
        if (tMktActivityUpgrade == null) {
            return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u5347\u7ea7\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        TMktActivity tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivity::getValid, (Object)1));
        if (tMktActivity == null) {
            return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u5347\u7ea7\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        List activityCouponList = this.tMktActivityCouponService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivityCoupon.class).eq(TMktActivityCoupon::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityCoupon::getValid, (Object)1));
        QueryDetailActivityUpgradeRespVO respVO = new QueryDetailActivityUpgradeRespVO();
        BeanUtil.copyProperties((Object)tMktActivityUpgrade, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)tMktActivity, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        if (CollUtil.isNotEmpty((Collection)activityCouponList)) {
            List couponCodeList = activityCouponList.stream().map(TMktActivityCoupon::getCouponCode).collect(Collectors.toList());
            List couponListByCode = this.apiMktCommonService.getCouponListByCode(couponCodeList);
            respVO.setCouponCodeList(couponListByCode);
        }
        if (Optional.ofNullable(tMktActivityUpgrade.getUpgradeLevelCode()).isPresent()) {
            List<String> levelCodeList = Arrays.asList(tMktActivityUpgrade.getUpgradeLevelCode().split(","));
            List levelListByCode = this.apiMktCommonService.getLevelListByCode(levelCodeList);
            respVO.setUpgradeLevelCodeList(levelListByCode);
        }
        if (2 == tMktActivity.getMbrConditionType() && StrUtil.isNotBlank((CharSequence)tMktActivity.getMbrGroupDefCode())) {
            String mbrGroupName = this.apiMktCommonService.getMbrGroupName(tMktActivity.getMbrGroupDefCode());
            respVO.setMbrGroupDefName(mbrGroupName);
        }
        return ResponseUtil.getSuccessData((Object)respVO);
    }

    public ResponseData<String> mbrUpgradeConsumer(MbrLevelUpgradeBO mbrLevelUpgradeBO) {
        String mbrMemberCode = mbrLevelUpgradeBO.getMbrMemberCode();
        String levelCode = mbrLevelUpgradeBO.getLevelCode();
        List mktActivityCodeList = this.tMktActivityUpgradeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(TMktActivityUpgrade::getUpgradeLevelCode, (Object)levelCode)).eq(TMktActivityUpgrade::getValid, (Object)1)).stream().map(TMktActivityUpgrade::getMktActivityCode).collect(Collectors.toList());
        List tMktActivityList = this.tMktActivityService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getActivityType, (Object)2)).eq(TMktActivity::getValid, (Object)1)).in(TMktActivity::getMktActivityCode, mktActivityCodeList)).eq(TMktActivity::getCheckStatus, (Object)3)).eq(TMktActivity::getActivityStatus, (Object)2));
        if (CollUtil.isEmpty((Collection)tMktActivityList)) {
            return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u5347\u7ea7\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        List activityCouponList = this.tMktActivityCouponService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivityCoupon.class).in(TMktActivityCoupon::getMktActivityCode, mktActivityCodeList)).eq(TMktActivityCoupon::getValid, (Object)1));
        HashMap couponListByActivity = CollUtil.isNotEmpty((Collection)activityCouponList) ? activityCouponList.stream().collect(Collectors.groupingBy(TMktActivityCoupon::getMktActivityCode)) : new HashMap();
        for (TMktActivity tMktActivity : tMktActivityList) {
            String mktActivityCode = tMktActivity.getMktActivityCode();
            SendActivityBO sendActivityBO = new SendActivityBO();
            sendActivityBO.setActivityNo(tMktActivity.getActivityNo());
            sendActivityBO.setActivityType(tMktActivity.getActivityType());
            sendActivityBO.setMktActivityCode(mktActivityCode);
            sendActivityBO.setIntegral(tMktActivity.getIntegral());
            sendActivityBO.setBusinessCode(tMktActivity.getMktActivityCode());
            List tMktActivityCoupons = (List)couponListByActivity.get(mktActivityCode);
            if (CollUtil.isNotEmpty((Collection)tMktActivityCoupons)) {
                sendActivityBO.setCouponCodeList(tMktActivityCoupons.stream().map(TMktActivityCoupon::getCouponCode).collect(Collectors.joining(",")));
            }
            this.apiMktActivityCommonService.sendActivityBenefit(sendActivityBO, Arrays.asList(mbrMemberCode));
        }
        return ResponseUtil.getSuccessData((Object)"\u4f1a\u5458\u5347\u7ea7\u6d3b\u52a8\u53d1\u653e\u6210\u529f");
    }
}

