/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.mktcenter.api.service.ApiMktActivityCommonService;
import com.bizvane.mktcenter.api.service.ApiMktActivityRegisterService;
import com.bizvane.mktcenter.api.service.ApiMktCommonService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMktActivity;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityCoupon;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityRegister;
import com.bizvane.mktcenter.domain.service.TMktActivityCouponService;
import com.bizvane.mktcenter.domain.service.TMktActivityRegisterService;
import com.bizvane.mktcenter.domain.service.TMktActivityService;
import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktActivityRegisterReqVO;
import com.bizvane.mktcenter.feign.vo.req.MktActivityVO;
import com.bizvane.mktcenter.feign.vo.req.QueryActivityAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivityRegisterAnalysisPageRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailActivityRegisterRespVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMktActivityRegisterServiceImpl
implements ApiMktActivityRegisterService {
    private static final Logger log = LoggerFactory.getLogger(ApiMktActivityRegisterServiceImpl.class);
    @Autowired
    private TMktActivityService tMktActivityService;
    @Autowired
    private TMktActivityRegisterService tMktActivityRegisterService;
    @Autowired
    private ApiMktActivityCommonService apiMktActivityCommonService;
    @Autowired
    private TMktActivityCouponService tMktActivityCouponService;
    @Autowired
    private ApiMktCommonService apiMktCommonService;

    public ResponseData<String> saveOrUpdate(AddOrUpdateMktActivityRegisterReqVO reqVO) {
        String mktActivityCode = reqVO.getMktActivityCode();
        TMktActivity tMktActivity = null;
        TMktActivityRegister activityRegister = null;
        if (StrUtil.isNotBlank((CharSequence)mktActivityCode)) {
            activityRegister = (TMktActivityRegister)this.tMktActivityRegisterService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityRegister::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityRegister::getValid, (Object)1));
            if (activityRegister == null) {
                return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u6ce8\u518c\u6d3b\u52a8\u4e0d\u5b58\u5728");
            }
            tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivity::getValid, (Object)1));
            if (tMktActivity == null) {
                return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u6ce8\u518c\u6d3b\u52a8\u4e0d\u5b58\u5728");
            }
        } else {
            tMktActivity = new TMktActivity();
            activityRegister = new TMktActivityRegister();
            mktActivityCode = IdUtil.fastSimpleUUID();
            tMktActivity.setMktActivityCode(mktActivityCode);
            tMktActivity.setActivityNo(IdUtil.fastSimpleUUID());
            tMktActivity.setActivityType(Integer.valueOf(1));
            tMktActivity.setActivityStatus(Integer.valueOf(1));
            tMktActivity.setCheckStatus(Integer.valueOf(1));
            tMktActivity.setValid(Integer.valueOf(1));
            activityRegister.setMktActivityCode(mktActivityCode);
            activityRegister.setMktActivityRegisterCode(IdUtil.fastSimpleUUID());
            activityRegister.setValid(Integer.valueOf(1));
        }
        this.apiMktActivityCommonService.saveCoupon((MktActivityVO)reqVO);
        BeanUtil.copyProperties((Object)reqVO, (Object)activityRegister, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)reqVO, (Object)tMktActivity, (CopyOptions)CopyOptions.create().ignoreNullValue());
        this.tMktActivityService.saveOrUpdate((Object)tMktActivity);
        this.tMktActivityRegisterService.saveOrUpdate((Object)activityRegister);
        return ResponseUtil.getSuccessData((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public ResponseData<PageInfo<QueryActivityRegisterAnalysisPageRespVO>> pageAnalysisList(QueryActivityAnalysisPageReqVO reqVO) {
        Page page = (Page)((Page)this.tMktActivityService.page((IPage)new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getActivityType, (Object)1)).eq(TMktActivity::getValid, (Object)1)).eq(StrUtil.isNotBlank((CharSequence)reqVO.getActivityName()), TMktActivity::getActivityName, (Object)reqVO.getActivityName())).eq(StrUtil.isNotBlank((CharSequence)reqVO.getActivityNo()), TMktActivity::getActivityNo, (Object)reqVO.getActivityNo()))).convert(tMktActivity -> (QueryActivityRegisterAnalysisPageRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktActivity), QueryActivityRegisterAnalysisPageRespVO.class));
        PageInfo pageInfo = new PageInfo((int)page.getCurrent(), (int)page.getSize(), (long)((int)page.getTotal()), page.getRecords());
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    public ResponseData<QueryDetailActivityRegisterRespVO> getDetail(String mktActivityCode) {
        TMktActivityRegister activityRegister = (TMktActivityRegister)this.tMktActivityRegisterService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityRegister::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityRegister::getValid, (Object)1));
        if (activityRegister == null) {
            return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u6ce8\u518c\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        TMktActivity tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivity::getValid, (Object)1));
        if (tMktActivity == null) {
            return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u6ce8\u518c\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        List activityCouponList = this.tMktActivityCouponService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityCoupon::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityCoupon::getValid, (Object)1));
        QueryDetailActivityRegisterRespVO respVO = new QueryDetailActivityRegisterRespVO();
        BeanUtil.copyProperties((Object)activityRegister, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)tMktActivity, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        if (CollUtil.isNotEmpty((Collection)activityCouponList)) {
            List couponCodeList = activityCouponList.stream().map(TMktActivityCoupon::getCouponCode).collect(Collectors.toList());
            List couponListByCode = this.apiMktCommonService.getCouponListByCode(couponCodeList);
            respVO.setCouponCodeList(couponListByCode);
        }
        if (2 == tMktActivity.getMbrConditionType() && StrUtil.isNotBlank((CharSequence)tMktActivity.getMbrGroupDefCode())) {
            String mbrGroupName = this.apiMktCommonService.getMbrGroupName(tMktActivity.getMbrGroupDefCode());
            respVO.setMbrGroupDefName(mbrGroupName);
        }
        return ResponseUtil.getSuccessData((Object)respVO);
    }
}

