/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.mktcenter.api.service.ApiMktActivityPointLotteryService;
import com.bizvane.mktcenter.api.service.ApiMktCommonService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMktActivity;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityPointsLottery;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityPointsLotteryRecord;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityPointsLotteryRule;
import com.bizvane.mktcenter.domain.service.ITMktActivityPointsLotteryRuleService;
import com.bizvane.mktcenter.domain.service.TMktActivityPointsLotteryRecordService;
import com.bizvane.mktcenter.domain.service.TMktActivityPointsLotteryService;
import com.bizvane.mktcenter.domain.service.TMktActivityService;
import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktActivityPointLotteryReqVO;
import com.bizvane.mktcenter.feign.vo.req.AddOrUpdatePointsLotteryRuleReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryActivityAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryActivityLotteryRecordReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivityLotteryRecordRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivityPointsLotteryAnalysisPageRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailActivityPointLotteryRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailPointsLotteryRuleRespVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMktActivityPointLotteryServiceImpl
implements ApiMktActivityPointLotteryService {
    private static final Logger log = LoggerFactory.getLogger(ApiMktActivityPointLotteryServiceImpl.class);
    @Autowired
    private TMktActivityService tMktActivityService;
    @Autowired
    private TMktActivityPointsLotteryService tMktActivityPointsLotteryService;
    @Autowired
    private TMktActivityPointsLotteryRecordService tMktActivityPointsLotteryRecordService;
    @Autowired
    private ApiMktCommonService apiMktCommonService;
    @Autowired
    private ITMktActivityPointsLotteryRuleService itMktActivityPointsLotteryRuleService;

    public ResponseData<String> saveOrUpdate(AddOrUpdateMktActivityPointLotteryReqVO reqVO) {
        String mktActivityCode = reqVO.getMktActivityCode();
        TMktActivity tMktActivity = null;
        TMktActivityPointsLottery tMktActivityPointsLottery = null;
        if (StrUtil.isNotBlank((CharSequence)mktActivityCode)) {
            tMktActivityPointsLottery = (TMktActivityPointsLottery)this.tMktActivityPointsLotteryService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityPointsLottery::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityPointsLottery::getValid, (Object)1));
            if (tMktActivityPointsLottery == null) {
                return ResponseUtil.getFailedMsg((String)"\u79ef\u5206\u593a\u5b9d\u6d3b\u52a8\u4e0d\u5b58\u5728");
            }
            tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivity::getValid, (Object)1));
            if (tMktActivity == null) {
                return ResponseUtil.getFailedMsg((String)"\u79ef\u5206\u593a\u5b9d\u6d3b\u52a8\u4e0d\u5b58\u5728");
            }
        } else {
            tMktActivity = new TMktActivity();
            tMktActivityPointsLottery = new TMktActivityPointsLottery();
            mktActivityCode = IdUtil.fastSimpleUUID();
            tMktActivity.setMktActivityCode(mktActivityCode);
            tMktActivity.setActivityNo(IdUtil.fastSimpleUUID());
            tMktActivity.setActivityType(Integer.valueOf(7));
            tMktActivity.setActivityStatus(Integer.valueOf(1));
            tMktActivity.setCheckStatus(Integer.valueOf(1));
            tMktActivity.setValid(Integer.valueOf(1));
            tMktActivityPointsLottery.setMktActivityCode(mktActivityCode);
            tMktActivityPointsLottery.setMktActivityPointsLotteryCode(IdUtil.fastSimpleUUID());
            tMktActivityPointsLottery.setValid(Integer.valueOf(1));
        }
        BeanUtil.copyProperties((Object)reqVO, (Object)tMktActivityPointsLottery, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)reqVO, (Object)tMktActivity, (CopyOptions)CopyOptions.create().ignoreNullValue());
        this.tMktActivityService.saveOrUpdate((Object)tMktActivity);
        this.tMktActivityPointsLotteryService.saveOrUpdate((Object)tMktActivityPointsLottery);
        return ResponseUtil.getSuccessData((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public ResponseData<PageInfo<QueryActivityPointsLotteryAnalysisPageRespVO>> analysisPageList(QueryActivityAnalysisPageReqVO reqVO) {
        Page page = (Page)((Page)this.tMktActivityService.page((IPage)new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getActivityType, (Object)7)).eq(TMktActivity::getValid, (Object)1)).eq(StrUtil.isNotBlank((CharSequence)reqVO.getActivityName()), TMktActivity::getActivityName, (Object)reqVO.getActivityName())).eq(StrUtil.isNotBlank((CharSequence)reqVO.getActivityNo()), TMktActivity::getActivityNo, (Object)reqVO.getActivityNo()))).convert(tMktActivity -> (QueryActivityPointsLotteryAnalysisPageRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktActivity), QueryActivityPointsLotteryAnalysisPageRespVO.class));
        PageInfo pageInfo = new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), page.getRecords());
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    public ResponseData<QueryDetailActivityPointLotteryRespVO> getDetail(String mktActivityCode) {
        TMktActivityPointsLottery tMktActivityPointsLottery = (TMktActivityPointsLottery)this.tMktActivityPointsLotteryService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityPointsLottery::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityPointsLottery::getValid, (Object)1));
        if (tMktActivityPointsLottery == null) {
            return ResponseUtil.getFailedMsg((String)"\u79ef\u5206\u593a\u5b9d\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        TMktActivity tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivity::getValid, (Object)1));
        if (tMktActivity == null) {
            return ResponseUtil.getFailedMsg((String)"\u79ef\u5206\u593a\u5b9d\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        QueryDetailActivityPointLotteryRespVO respVO = new QueryDetailActivityPointLotteryRespVO();
        BeanUtil.copyProperties((Object)tMktActivityPointsLottery, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)tMktActivity, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        if (2 == tMktActivity.getMbrConditionType() && StrUtil.isNotBlank((CharSequence)tMktActivity.getMbrGroupDefCode())) {
            String mbrGroupName = this.apiMktCommonService.getMbrGroupName(tMktActivity.getMbrGroupDefCode());
            respVO.setMbrGroupDefName(mbrGroupName);
        }
        return ResponseUtil.getSuccessData((Object)respVO);
    }

    public ResponseData<PageInfo<QueryActivityLotteryRecordRespVO>> pageListRecord(QueryActivityLotteryRecordReqVO reqVO) {
        String cardNo = reqVO.getCardNo();
        String phone = reqVO.getPhone();
        Integer winState = reqVO.getWinState();
        ArrayList mbrMemberCodeList = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)cardNo) || StrUtil.isNotBlank((CharSequence)phone)) {
            mbrMemberCodeList = null;
        }
        IPage page = ((Page)this.tMktActivityPointsLotteryRecordService.page((IPage)new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivityPointsLotteryRecord.class).in(StrUtil.isNotBlank((CharSequence)cardNo) || StrUtil.isNotBlank((CharSequence)phone), TMktActivityPointsLotteryRecord::getMbrMembersCode, mbrMemberCodeList)).eq(winState != null, TMktActivityPointsLotteryRecord::getWinState, (Object)winState)).eq(TMktActivityPointsLotteryRecord::getValid, (Object)1)).orderByDesc(TMktActivityPointsLotteryRecord::getId))).convert(tMktActivityPointsLotteryRecord -> {
            QueryActivityLotteryRecordRespVO respVO = (QueryActivityLotteryRecordRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktActivityPointsLotteryRecord), QueryActivityLotteryRecordRespVO.class);
            if (tMktActivityPointsLotteryRecord.getReturnState() == 1) {
                respVO.setReturnIntegral(tMktActivityPointsLotteryRecord.getConsumeIntegral());
            } else {
                respVO.setReturnIntegral(Integer.valueOf(0));
            }
            return respVO;
        });
        PageInfo pageInfo = new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), page.getRecords());
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    public void drawLottery() {
        List tMktActivityList = this.tMktActivityService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getActivityType, (Object)7)).eq(TMktActivity::getActivityStatus, (Object)3)).eq(TMktActivity::getActivityStatus, (Object)3)).eq(TMktActivity::getValid, (Object)1));
        log.info("drawLottery tMktActivityList: {}", (Object)JacksonUtil.list2Json((List)tMktActivityList));
        if (CollUtil.isEmpty((Collection)tMktActivityList)) {
            return;
        }
        List mktActivityCodeList = tMktActivityList.stream().map(TMktActivity::getMktActivityCode).collect(Collectors.toList());
        this.drawLotteryItem(mktActivityCodeList);
    }

    private void drawLotteryItem(List<String> mktActivityCodeList) {
        List tMktActivityPointsLotteryList = this.tMktActivityPointsLotteryService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TMktActivityPointsLottery::getMktActivityCode, mktActivityCodeList)).eq(TMktActivityPointsLottery::getDrawPrizeStatus, (Object)0)).gt(TMktActivityPointsLottery::getDrawPrizeDate, (Object)DateUtil.date())).eq(TMktActivityPointsLottery::getValid, (Object)1));
        if (CollUtil.isEmpty((Collection)tMktActivityPointsLotteryList)) {
            return;
        }
        for (TMktActivityPointsLottery tMktActivityPointsLottery : tMktActivityPointsLotteryList) {
            this.doDrawPointLotteryItem(tMktActivityPointsLottery);
        }
    }

    private void doDrawPointLotteryItem(TMktActivityPointsLottery tMktActivityPointsLottery) {
        String mktActivityCode = tMktActivityPointsLottery.getMktActivityCode();
        Integer minParticipateNum = tMktActivityPointsLottery.getMinParticipateNum();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.select(new SFunction[]{TMktActivityPointsLotteryRecord::getMbrMembersCode}).eq(TMktActivityPointsLotteryRecord::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityPointsLotteryRecord::getWinState, (Object)3)).eq(TMktActivityPointsLotteryRecord::getValid, (Object)1)).groupBy(TMktActivityPointsLotteryRecord::getMbrMembersCode);
        Integer joinCustomerNum = this.tMktActivityPointsLotteryRecordService.getBaseMapper().selectCount((Wrapper)queryWrapper).intValue();
        List recordList = this.tMktActivityPointsLotteryRecordService.list((Wrapper)queryWrapper);
        if (joinCustomerNum < minParticipateNum) {
            this.tMktActivityPointsLotteryRecordService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TMktActivityPointsLotteryRecord::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityPointsLotteryRecord::getWinState, (Object)3)).eq(TMktActivityPointsLotteryRecord::getValid, (Object)1)).set(TMktActivityPointsLotteryRecord::getWinState, (Object)4));
            this.tMktActivityPointsLotteryService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TMktActivityPointsLottery::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityPointsLottery::getValid, (Object)1)).set(TMktActivityPointsLottery::getDrawPrizeStatus, (Object)3));
            for (TMktActivityPointsLotteryRecord record : recordList) {
                record.setReturnState(Integer.valueOf(1));
                record.setReturnTime(new Date());
                this.tMktActivityPointsLotteryRecordService.updateById((Object)record);
            }
        } else {
            ArrayList<String> winnerList = new ArrayList<String>();
            for (int i = 0; i < tMktActivityPointsLottery.getPrizeNumber(); ++i) {
                recordList = recordList.stream().filter(item -> !winnerList.contains(item.getMbrMembersCode())).collect(Collectors.toList());
                int index = new Random().nextInt(recordList.size());
                TMktActivityPointsLotteryRecord record = (TMktActivityPointsLotteryRecord)recordList.get(index);
                record.setWinState(Integer.valueOf(1));
                record.setWinTime(new Date());
                this.tMktActivityPointsLotteryRecordService.updateById((Object)record);
                winnerList.add(record.getMbrMembersCode());
            }
            this.tMktActivityPointsLotteryRecordService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TMktActivityPointsLotteryRecord::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityPointsLotteryRecord::getWinState, (Object)3)).eq(TMktActivityPointsLotteryRecord::getValid, (Object)1)).set(TMktActivityPointsLotteryRecord::getWinState, (Object)0));
        }
    }

    public ResponseData<String> saveRule(AddOrUpdatePointsLotteryRuleReqVO reqVO) {
        String desc = reqVO.getDesc();
        String mktActivityPointsLotteryRuleCode = reqVO.getMktActivityPointsLotteryRuleCode();
        TMktActivityPointsLotteryRule rule = (TMktActivityPointsLotteryRule)this.itMktActivityPointsLotteryRuleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivityPointsLotteryRule.class).eq(TMktActivityPointsLotteryRule::getValid, (Object)1)).eq(TMktActivityPointsLotteryRule::getMktActivityPointsLotteryRuleCode, (Object)mktActivityPointsLotteryRuleCode));
        if (rule != null) {
            rule.setDesc(desc);
        } else {
            rule = new TMktActivityPointsLotteryRule();
            mktActivityPointsLotteryRuleCode = IdUtil.fastSimpleUUID();
            rule.setMktActivityPointsLotteryRuleCode(mktActivityPointsLotteryRuleCode);
            rule.setCreateDate(new Date());
            rule.setValid(Integer.valueOf(1));
            rule.setDesc(desc);
        }
        this.itMktActivityPointsLotteryRuleService.saveOrUpdate((Object)rule);
        return ResponseUtil.getSuccessData((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public ResponseData<QueryDetailPointsLotteryRuleRespVO> getRule() {
        List list = this.itMktActivityPointsLotteryRuleService.list((Wrapper)new LambdaQueryWrapper(TMktActivityPointsLotteryRule.class).eq(TMktActivityPointsLotteryRule::getValid, (Object)1));
        if (CollUtil.isNotEmpty((Collection)list)) {
            QueryDetailPointsLotteryRuleRespVO reqVO = (QueryDetailPointsLotteryRuleRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json(list.get(0)), QueryDetailPointsLotteryRuleRespVO.class);
            return ResponseUtil.getSuccessData((Object)reqVO);
        }
        return ResponseUtil.getSuccessData(null);
    }
}

