/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.mktcenter.api.service.ApiMktActivityCommonService;
import com.bizvane.mktcenter.api.service.ApiMktActivityOrderService;
import com.bizvane.mktcenter.api.service.ApiMktCommonService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMktActivity;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityCoupon;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityOrder;
import com.bizvane.mktcenter.domain.service.TMktActivityCouponService;
import com.bizvane.mktcenter.domain.service.TMktActivityOrderService;
import com.bizvane.mktcenter.domain.service.TMktActivityService;
import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktOrderRegisterReqVO;
import com.bizvane.mktcenter.feign.vo.req.MktActivityVO;
import com.bizvane.mktcenter.feign.vo.req.QueryActivityAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivityOrderAnalysisPageRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailActivityOrderRespVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMktActivityOrderServiceImpl
implements ApiMktActivityOrderService {
    private static final Logger log = LoggerFactory.getLogger(ApiMktActivityOrderServiceImpl.class);
    @Autowired
    private TMktActivityService tMktActivityService;
    @Autowired
    private TMktActivityOrderService tMktActivityOrderService;
    @Autowired
    private ApiMktActivityCommonService apiMktActivityCommonService;
    @Autowired
    private TMktActivityCouponService tMktActivityCouponService;
    @Autowired
    private ApiMktCommonService apiMktCommonService;

    public ResponseData<String> saveOrUpdate(AddOrUpdateMktOrderRegisterReqVO reqVO) {
        String mktActivityCode = reqVO.getMktActivityCode();
        TMktActivityOrder activityOrder = null;
        TMktActivity tMktActivity = null;
        if (StrUtil.isNotBlank((CharSequence)mktActivityCode)) {
            activityOrder = (TMktActivityOrder)this.tMktActivityOrderService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityOrder::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityOrder::getValid, (Object)1));
            if (activityOrder == null) {
                return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u6d88\u8d39\u6d3b\u52a8\u4e0d\u5b58\u5728");
            }
            tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivity::getValid, (Object)1));
            if (tMktActivity == null) {
                return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u6d88\u8d39\u6d3b\u52a8\u4e0d\u5b58\u5728");
            }
        } else {
            tMktActivity = new TMktActivity();
            activityOrder = new TMktActivityOrder();
            mktActivityCode = IdUtil.fastSimpleUUID();
            tMktActivity.setMktActivityCode(mktActivityCode);
            tMktActivity.setActivityNo(IdUtil.fastSimpleUUID());
            tMktActivity.setActivityType(Integer.valueOf(4));
            tMktActivity.setActivityStatus(Integer.valueOf(1));
            tMktActivity.setCheckStatus(Integer.valueOf(1));
            tMktActivity.setLongTerm(Integer.valueOf(0));
            tMktActivity.setValid(Integer.valueOf(1));
            activityOrder.setMktActivityCode(mktActivityCode);
            activityOrder.setMktActivityOrderCode(IdUtil.fastSimpleUUID());
            activityOrder.setValid(Integer.valueOf(1));
        }
        this.apiMktActivityCommonService.saveCoupon((MktActivityVO)reqVO);
        List merchantCodeListByKey = this.apiMktCommonService.getMerchantCodeListByKey(reqVO.getMerchantCodeSelectedKey());
        BeanUtil.copyProperties((Object)reqVO, (Object)activityOrder, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)reqVO, (Object)tMktActivity, (CopyOptions)CopyOptions.create().ignoreNullValue());
        activityOrder.setConsumeChannelCode((String)Optional.ofNullable(reqVO.getConsumeChannelCode()).map(list -> String.join((CharSequence)",", list)).orElse(null));
        activityOrder.setAirportLimit((String)Optional.ofNullable(reqVO.getAirportLimit()).map(list -> String.join((CharSequence)",", list)).orElse(null));
        activityOrder.setBusinessCode((String)Optional.ofNullable(reqVO.getBusinessCode()).map(list -> String.join((CharSequence)",", list)).orElse(null));
        activityOrder.setMerchantCode((String)Optional.ofNullable(merchantCodeListByKey).map(list -> String.join((CharSequence)",", list)).orElse(null));
        this.tMktActivityService.saveOrUpdate((Object)tMktActivity);
        this.tMktActivityOrderService.saveOrUpdate((Object)activityOrder);
        return ResponseUtil.getSuccessData((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public ResponseData<PageInfo<QueryActivityOrderAnalysisPageRespVO>> pageAnalysisList(QueryActivityAnalysisPageReqVO reqVO) {
        Page page = (Page)((Page)this.tMktActivityService.page((IPage)new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getActivityType, (Object)4)).eq(TMktActivity::getValid, (Object)1)).eq(StrUtil.isNotBlank((CharSequence)reqVO.getActivityName()), TMktActivity::getActivityName, (Object)reqVO.getActivityName())).eq(StrUtil.isNotBlank((CharSequence)reqVO.getActivityNo()), TMktActivity::getActivityNo, (Object)reqVO.getActivityNo()))).convert(tMktActivity -> (QueryActivityOrderAnalysisPageRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktActivity), QueryActivityOrderAnalysisPageRespVO.class));
        PageInfo pageInfo = new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), page.getRecords());
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    public ResponseData<QueryDetailActivityOrderRespVO> getDetail(String mktActivityCode) {
        TMktActivityOrder activityOrder = (TMktActivityOrder)this.tMktActivityOrderService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityOrder::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityOrder::getValid, (Object)1));
        if (activityOrder == null) {
            return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u6d88\u8d39\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        TMktActivity tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivity::getValid, (Object)1));
        if (tMktActivity == null) {
            return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u6d88\u8d39\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        List activityCouponList = this.tMktActivityCouponService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityCoupon::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityCoupon::getValid, (Object)1));
        QueryDetailActivityOrderRespVO respVO = new QueryDetailActivityOrderRespVO();
        BeanUtil.copyProperties((Object)activityOrder, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)tMktActivity, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        if (CollUtil.isNotEmpty((Collection)activityCouponList)) {
            List couponCodeList = activityCouponList.stream().map(TMktActivityCoupon::getCouponCode).collect(Collectors.toList());
            List couponListByCode = this.apiMktCommonService.getCouponListByCode(couponCodeList);
            respVO.setCouponCodeList(couponListByCode);
        }
        List consumeChannelCodeList = Optional.ofNullable(activityOrder.getConsumeChannelCode()).map(str -> Arrays.asList(str.split(","))).orElse(null);
        List consumeChannelListByCode = this.apiMktCommonService.getConsumeChannelListByCode(consumeChannelCodeList);
        respVO.setConsumeChannelList(consumeChannelListByCode);
        List airportCodeList = Optional.ofNullable(activityOrder.getAirportLimit()).map(str -> Arrays.asList(str.split(","))).orElse(null);
        List airportListByCode = this.apiMktCommonService.getAirportListByCode(airportCodeList);
        respVO.setAirportList(airportListByCode);
        List businessCodeList = Optional.ofNullable(activityOrder.getBusinessCode()).map(str -> Arrays.asList(str.split(","))).orElse(null);
        List businessListByCode = this.apiMktCommonService.getBusinessListByCode(businessCodeList);
        respVO.setBusinessList(businessListByCode);
        List merchantCodeList = Optional.ofNullable(activityOrder.getMerchantCode()).map(str -> Arrays.asList(str.split(","))).orElse(null);
        String keyByMerchantCodeList = this.apiMktCommonService.getKeyByMerchantCodeList(merchantCodeList);
        respVO.setMerchantCodeSelectedKey(keyByMerchantCodeList);
        if (2 == tMktActivity.getMbrConditionType() && StrUtil.isNotBlank((CharSequence)tMktActivity.getMbrGroupDefCode())) {
            String mbrGroupName = this.apiMktCommonService.getMbrGroupName(tMktActivity.getMbrGroupDefCode());
            respVO.setMbrGroupDefName(mbrGroupName);
        }
        return ResponseUtil.getSuccessData((Object)respVO);
    }
}

