/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.mktcenter.api.domain.bo.SendActivityBO;
import com.bizvane.mktcenter.api.service.ApiMktActivityCommonService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMktActivity;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityCoupon;
import com.bizvane.mktcenter.domain.domain.po.TMktActivitySendRecord;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityUpgrade;
import com.bizvane.mktcenter.domain.service.TMktActivityCouponService;
import com.bizvane.mktcenter.domain.service.TMktActivitySendRecordService;
import com.bizvane.mktcenter.domain.service.TMktActivityService;
import com.bizvane.mktcenter.domain.service.TMktActivityUpgradeService;
import com.bizvane.mktcenter.feign.vo.req.MktActivityVO;
import com.bizvane.mktcenter.feign.vo.req.QueryPageActivityPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivityPageRespVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMktActivityCommonServiceImpl
implements ApiMktActivityCommonService {
    private static final Logger log = LoggerFactory.getLogger(ApiMktActivityCommonServiceImpl.class);
    @Autowired
    private TMktActivityService tMktActivityService;
    @Autowired
    private TMktActivitySendRecordService tMktActivitySendRecordService;
    @Autowired
    private TMktActivityUpgradeService tMktActivityUpgradeService;
    @Autowired
    private TMktActivityCouponService tMktActivityCouponService;

    public ResponseData<PageInfo<QueryActivityPageRespVO>> pageList(QueryPageActivityPageReqVO reqVO) {
        String upgradeLevelCode = reqVO.getUpgradeLevelCode();
        List<Object> mktActivityCodeList = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)upgradeLevelCode)) {
            mktActivityCodeList = this.tMktActivityUpgradeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(TMktActivityUpgrade::getUpgradeLevelCode, (Object)upgradeLevelCode)).eq(TMktActivityUpgrade::getValid, (Object)1)).stream().map(TMktActivityUpgrade::getMktActivityCode).collect(Collectors.toList());
        }
        Page page = (Page)((Page)this.tMktActivityService.page((IPage)new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getActivityType, (Object)reqVO.getActivityType())).eq(TMktActivity::getValid, (Object)1)).eq(StrUtil.isNotBlank((CharSequence)reqVO.getActivityName()), TMktActivity::getActivityName, (Object)reqVO.getActivityName())).eq(StrUtil.isNotBlank((CharSequence)reqVO.getActivityNo()), TMktActivity::getActivityNo, (Object)reqVO.getActivityNo())).eq(StrUtil.isNotBlank((CharSequence)reqVO.getCreateUserName()), TMktActivity::getCreateUserName, (Object)reqVO.getCreateUserName())).in(StrUtil.isNotBlank((CharSequence)upgradeLevelCode), TMktActivity::getMktActivityCode, mktActivityCodeList)).eq(reqVO.getCheckStatus() != null, TMktActivity::getCheckStatus, (Object)reqVO.getCheckStatus())).eq(reqVO.getActivityStatus() != null, TMktActivity::getActivityStatus, (Object)reqVO.getActivityStatus()))).convert(tMktActivity -> (QueryActivityPageRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktActivity), QueryActivityPageRespVO.class));
        PageInfo pageInfo = new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), page.getRecords());
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    public ResponseData<String> disableActivity(String mktActivityCode) {
        TMktActivity tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivity::getValid, (Object)1));
        if (tMktActivity == null) {
            return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u6ce8\u518c\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        tMktActivity.setActivityStatus(Integer.valueOf(4));
        this.tMktActivityService.updateById((Object)tMktActivity);
        return ResponseUtil.getSuccessData((Object)"\u7981\u7528\u6210\u529f");
    }

    public ResponseData<String> sendActivityBenefit(SendActivityBO sendActivityBO, List<String> memberCodeList) {
        List sendRecordList = this.tMktActivitySendRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivitySendRecord.class).eq(TMktActivitySendRecord::getMktActivityCode, (Object)sendActivityBO.getMktActivityCode())).eq(TMktActivitySendRecord::getValid, (Object)1)).in(TMktActivitySendRecord::getMbrMembersCode, memberCodeList)).eq(TMktActivitySendRecord::getBusinessCode, (Object)sendActivityBO.getBusinessCode())).between(TMktActivitySendRecord::getCreateDate, (Object)DateUtil.beginOfYear((Date)new Date()), (Object)DateUtil.endOfYear((Date)new Date())));
        if (CollUtil.isNotEmpty((Collection)sendRecordList)) {
            Set mbrMemberCodeSet = sendRecordList.stream().map(TMktActivitySendRecord::getMbrMembersCode).collect(Collectors.toSet());
            memberCodeList = memberCodeList.stream().filter(item -> !mbrMemberCodeSet.contains(item)).collect(Collectors.toList());
        }
        List tMktActivitySendRecordList = memberCodeList.stream().map(memberCode -> {
            TMktActivitySendRecord record = new TMktActivitySendRecord();
            record.setMktActivitySendRecordCode(IdUtil.fastSimpleUUID());
            record.setMktActivityCode(sendActivityBO.getMktActivityCode());
            record.setMbrMembersCode(memberCode);
            record.setActivityType(sendActivityBO.getActivityType());
            record.setSendDate(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            record.setIntegral(sendActivityBO.getIntegral());
            record.setCouponCodeList(sendActivityBO.getCouponCodeList());
            record.setBusinessCode(sendActivityBO.getBusinessCode());
            record.setMktActivitySignInPrizeCode(sendActivityBO.getMktActivitySignInPrizeCode());
            record.setValid(Integer.valueOf(1));
            return record;
        }).collect(Collectors.toList());
        this.tMktActivitySendRecordService.saveBatch(tMktActivitySendRecordList);
        return ResponseUtil.getSuccessData((Object)"\u53d1\u9001\u6210\u529f");
    }

    public void saveCoupon(MktActivityVO mktActivityVO) {
        String mktActivityCode = mktActivityVO.getMktActivityCode();
        List couponCodeList = mktActivityVO.getCouponCodeList();
        this.tMktActivityCouponService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(TMktActivityCoupon.class).eq(TMktActivityCoupon::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityCoupon::getValid, (Object)1)).set(TMktActivityCoupon::getValid, (Object)0)).set(TMktActivityCoupon::getModifiedUserName, (Object)mktActivityVO.getUserName())).set(TMktActivityCoupon::getModifiedUserCode, (Object)mktActivityVO.getUserCode()));
        if (CollUtil.isNotEmpty((Collection)couponCodeList)) {
            List tMktActivityCouponList = couponCodeList.stream().map(couponCode -> {
                TMktActivityCoupon tMktActivityCoupon = new TMktActivityCoupon();
                tMktActivityCoupon.setCouponCode(couponCode.getCouponCode());
                tMktActivityCoupon.setMktActivityCode(mktActivityCode);
                tMktActivityCoupon.setMktActivityCouponCode(IdUtil.fastSimpleUUID());
                tMktActivityCoupon.setValid(Integer.valueOf(1));
                tMktActivityCoupon.setCreateUserCode(mktActivityVO.getUserCode());
                tMktActivityCoupon.setCreateUserName(mktActivityVO.getUserName());
                tMktActivityCoupon.setModifiedUserCode(mktActivityVO.getUserCode());
                tMktActivityCoupon.setModifiedUserName(mktActivityVO.getUserName());
                return tMktActivityCoupon;
            }).collect(Collectors.toList());
            this.tMktActivityCouponService.saveBatch(tMktActivityCouponList);
        }
    }
}

