/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.mktcenter.api.domain.bo.MbrRegisterBO;
import com.bizvane.mktcenter.api.domain.bo.SendActivityBO;
import com.bizvane.mktcenter.api.service.ApiMktActivityBirthdayService;
import com.bizvane.mktcenter.api.service.ApiMktActivityCommonService;
import com.bizvane.mktcenter.api.service.ApiMktCommonService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.bo.GetActivityListByConditionBO;
import com.bizvane.mktcenter.domain.domain.po.TMktActivity;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityBirthday;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityCoupon;
import com.bizvane.mktcenter.domain.service.TMktActivityBirthdayService;
import com.bizvane.mktcenter.domain.service.TMktActivityCouponService;
import com.bizvane.mktcenter.domain.service.TMktActivityService;
import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktActivityBirthdayReqVO;
import com.bizvane.mktcenter.feign.vo.req.MktActivityVO;
import com.bizvane.mktcenter.feign.vo.req.QueryActivityAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivityBirthdayAnalysisPageRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailActivityBirthdayRespVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMktActivityBirthdayServiceImpl
implements ApiMktActivityBirthdayService {
    private static final Logger log = LoggerFactory.getLogger(ApiMktActivityBirthdayServiceImpl.class);
    @Autowired
    private TMktActivityService tMktActivityService;
    @Autowired
    private TMktActivityBirthdayService tMktActivityBirthdayService;
    @Autowired
    private ApiMktActivityCommonService apiMktActivityCommonService;
    @Autowired
    private TMktActivityCouponService tMktActivityCouponService;
    @Autowired
    private ApiMktCommonService apiMktCommonService;

    public ResponseData<String> saveOrUpdate(AddOrUpdateMktActivityBirthdayReqVO reqVO) {
        String mktActivityCode = reqVO.getMktActivityCode();
        TMktActivityBirthday activityBirthday = null;
        TMktActivity tMktActivity = null;
        if (StrUtil.isNotBlank((CharSequence)mktActivityCode)) {
            activityBirthday = (TMktActivityBirthday)this.tMktActivityBirthdayService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityBirthday::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityBirthday::getValid, (Object)1));
            if (activityBirthday == null) {
                return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u751f\u65e5\u6d3b\u52a8\u4e0d\u5b58\u5728");
            }
            tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivity::getValid, (Object)1));
            if (tMktActivity == null) {
                return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u751f\u65e5\u6d3b\u52a8\u4e0d\u5b58\u5728");
            }
        } else {
            tMktActivity = new TMktActivity();
            activityBirthday = new TMktActivityBirthday();
            mktActivityCode = IdUtil.fastSimpleUUID();
            tMktActivity.setMktActivityCode(mktActivityCode);
            tMktActivity.setActivityNo(IdUtil.fastSimpleUUID());
            tMktActivity.setActivityType(Integer.valueOf(6));
            tMktActivity.setActivityStatus(Integer.valueOf(1));
            tMktActivity.setCheckStatus(Integer.valueOf(1));
            tMktActivity.setLongTerm(Integer.valueOf(0));
            tMktActivity.setValid(Integer.valueOf(1));
            activityBirthday.setMktActivityCode(mktActivityCode);
            activityBirthday.setMktActivityBirthdayCode(IdUtil.fastSimpleUUID());
            activityBirthday.setValid(Integer.valueOf(1));
        }
        BeanUtil.copyProperties((Object)reqVO, (Object)activityBirthday, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)reqVO, (Object)tMktActivity, (CopyOptions)CopyOptions.create().ignoreNullValue());
        this.apiMktActivityCommonService.saveCoupon((MktActivityVO)reqVO);
        this.tMktActivityService.saveOrUpdate((Object)tMktActivity);
        this.tMktActivityBirthdayService.saveOrUpdate((Object)activityBirthday);
        return ResponseUtil.getSuccessData((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public ResponseData<PageInfo<QueryActivityBirthdayAnalysisPageRespVO>> pageAnalysisList(QueryActivityAnalysisPageReqVO reqVO) {
        Page page = (Page)((Page)this.tMktActivityService.page((IPage)new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getActivityType, (Object)6)).eq(TMktActivity::getValid, (Object)1)).eq(StrUtil.isNotBlank((CharSequence)reqVO.getActivityName()), TMktActivity::getActivityName, (Object)reqVO.getActivityName())).eq(StrUtil.isNotBlank((CharSequence)reqVO.getActivityNo()), TMktActivity::getActivityNo, (Object)reqVO.getActivityNo()))).convert(tMktActivity -> (QueryActivityBirthdayAnalysisPageRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktActivity), QueryActivityBirthdayAnalysisPageRespVO.class));
        PageInfo pageInfo = new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), page.getRecords());
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    public ResponseData<QueryDetailActivityBirthdayRespVO> getDetail(String mktActivityCode) {
        TMktActivityBirthday activityBirthday = (TMktActivityBirthday)this.tMktActivityBirthdayService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityBirthday::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityBirthday::getValid, (Object)1));
        if (activityBirthday == null) {
            return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u751f\u65e5\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        TMktActivity tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivity::getValid, (Object)1));
        if (tMktActivity == null) {
            return ResponseUtil.getFailedMsg((String)"\u4f1a\u5458\u751f\u65e5\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        List activityCouponList = this.tMktActivityCouponService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityCoupon::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityCoupon::getValid, (Object)1));
        QueryDetailActivityBirthdayRespVO respVO = new QueryDetailActivityBirthdayRespVO();
        BeanUtil.copyProperties((Object)activityBirthday, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)tMktActivity, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        if (CollUtil.isNotEmpty((Collection)activityCouponList)) {
            List couponCodeList = activityCouponList.stream().map(TMktActivityCoupon::getCouponCode).collect(Collectors.toList());
            List couponListByCode = this.apiMktCommonService.getCouponListByCode(couponCodeList);
            respVO.setCouponCodeList(couponListByCode);
        }
        if (2 == tMktActivity.getMbrConditionType() && StrUtil.isNotBlank((CharSequence)tMktActivity.getMbrGroupDefCode())) {
            String mbrGroupName = this.apiMktCommonService.getMbrGroupName(tMktActivity.getMbrGroupDefCode());
            respVO.setMbrGroupDefName(mbrGroupName);
        }
        return ResponseUtil.getSuccessData((Object)respVO);
    }

    public ResponseData<String> everydayJobProcess() {
        block6: {
            block5: {
                int dayOfMonth;
                GetActivityListByConditionBO conditionBO = new GetActivityListByConditionBO();
                conditionBO.setDayOrMonth(Integer.valueOf(1));
                List activityCodeListByDay = this.tMktActivityBirthdayService.getActivityCodeListByCondition(conditionBO);
                log.info("\u751f\u65e5\u6d3b\u52a8job activityCodeListByDay: {}", (Object)JacksonUtil.list2Json((List)activityCodeListByDay));
                if (CollUtil.isNotEmpty((Collection)activityCodeListByDay)) {
                    for (String activityCode : activityCodeListByDay) {
                        this.sendBenefitByActivity(activityCode, Integer.valueOf(1));
                    }
                }
                if ((dayOfMonth = LocalDate.now().getDayOfMonth()) != 1) break block5;
                GetActivityListByConditionBO conditionBO2 = new GetActivityListByConditionBO();
                conditionBO2.setDayOrMonth(Integer.valueOf(2));
                List activityCodeListByMonth = this.tMktActivityBirthdayService.getActivityCodeListByCondition(conditionBO2);
                log.info("\u751f\u65e5\u6d3b\u52a8job activityCodeListByMonth: {}", (Object)JacksonUtil.list2Json((List)activityCodeListByMonth));
                if (!CollUtil.isNotEmpty((Collection)activityCodeListByMonth)) break block6;
                for (String activityCode : activityCodeListByMonth) {
                    this.sendBenefitByActivity(activityCode, Integer.valueOf(2));
                }
                break block6;
            }
            GetActivityListByConditionBO conditionBO3 = new GetActivityListByConditionBO();
            conditionBO3.setDayOrMonth(Integer.valueOf(2));
            conditionBO3.setBirthMonthSendType(Integer.valueOf(2));
            List activityCodeListByMonthNextDay = this.tMktActivityBirthdayService.getActivityCodeListByCondition(conditionBO3);
            log.info("\u751f\u65e5\u6d3b\u52a8job activityCodeListByMonthNextDay: {}", (Object)JacksonUtil.list2Json((List)activityCodeListByMonthNextDay));
            if (CollUtil.isNotEmpty((Collection)activityCodeListByMonthNextDay)) {
                for (String activityCode : activityCodeListByMonthNextDay) {
                    this.sendBenefitByActivity(activityCode, Integer.valueOf(3));
                }
            }
        }
        return ResponseUtil.getSuccessData((Object)"\u5904\u7406\u6210\u529f");
    }

    public ResponseData<String> sendBenefitOnRegister(MbrRegisterBO mbrRegisterBO) {
        String mbrMemberCode = mbrRegisterBO.getMbrMemberCode();
        Date birthday = mbrRegisterBO.getBirthday();
        GetActivityListByConditionBO conditionBO = new GetActivityListByConditionBO();
        conditionBO.setDayOrMonth(Integer.valueOf(2));
        conditionBO.setBirthMonthSendType(Integer.valueOf(1));
        List activityCodeListByMonth = this.tMktActivityBirthdayService.getActivityCodeListByCondition(conditionBO);
        log.info("sendBenefitOnRegister activityCodeListByDay: {}", (Object)JacksonUtil.list2Json((List)activityCodeListByMonth));
        if (CollUtil.isNotEmpty((Collection)activityCodeListByMonth)) {
            for (String activityCode : activityCodeListByMonth) {
                TMktActivity tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivity.class).eq(TMktActivity::getMktActivityCode, (Object)activityCode)).eq(TMktActivity::getValid, (Object)1));
                List activityCouponList = this.tMktActivityCouponService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivityCoupon.class).eq(TMktActivityCoupon::getMktActivityCode, (Object)activityCode)).eq(TMktActivityCoupon::getValid, (Object)1));
                String couponList = Optional.ofNullable(activityCouponList).map(list -> list.stream().map(TMktActivityCoupon::getCouponCode).collect(Collectors.joining(","))).orElse(null);
                Integer mbrConditionType = tMktActivity.getMbrConditionType();
                String activityMbrGroupDefCode = tMktActivity.getMbrGroupDefCode();
                String mbrGroupDefCode = "";
                if (2 != mbrConditionType && (!StrUtil.isNotBlank((CharSequence)mbrGroupDefCode) || !StrUtil.equals((CharSequence)activityMbrGroupDefCode, (CharSequence)mbrGroupDefCode)) || birthday == null || LocalDate.from(birthday.toInstant()).getMonthValue() != LocalDate.now().getMonthValue()) continue;
                this.sendBenefitProcess(tMktActivity, couponList, Arrays.asList(mbrMemberCode));
            }
        }
        return ResponseUtil.getSuccessData((Object)"\u5904\u7406\u6210\u529f");
    }

    private void sendBenefitByActivity(String activityCode, Integer scene) {
        TMktActivityBirthday activityBirthday = (TMktActivityBirthday)this.tMktActivityBirthdayService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityBirthday::getMktActivityCode, (Object)activityCode)).eq(TMktActivityBirthday::getValid, (Object)1));
        TMktActivity tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivity.class).eq(TMktActivity::getMktActivityCode, (Object)activityCode)).eq(TMktActivity::getValid, (Object)1));
        Integer mbrConditionType = tMktActivity.getMbrConditionType();
        if (2 == mbrConditionType) {
            String string = tMktActivity.getMbrGroupDefCode();
        }
        List activityCouponList = this.tMktActivityCouponService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivityCoupon.class).eq(TMktActivityCoupon::getMktActivityCode, (Object)activityCode)).eq(TMktActivityCoupon::getValid, (Object)1));
        String couponList = Optional.ofNullable(activityCouponList).map(list -> list.stream().map(TMktActivityCoupon::getCouponCode).collect(Collectors.joining(","))).orElse(null);
        if (scene == 1) {
            Integer aheadDays = Optional.ofNullable(activityBirthday.getAheadDays()).orElse(0);
            LocalDate localDate = LocalDate.now().plusDays(aheadDays.intValue());
        } else if (scene == 2) {
            int birthMonth = LocalDate.now().getMonthValue();
            Date date = Date.from(LocalDate.now().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        } else if (scene == 3) {
            int birthMonth = LocalDate.now().getMonthValue();
            Date minRegisterDate = Date.from(LocalDate.now().minusDays(1L).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
            DateTime dateTime = DateUtil.endOfDay((Date)Date.from(LocalDate.now().minusDays(1L).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
        }
        this.sendBenefitProcess(tMktActivity, couponList, null);
    }

    private void sendBenefitProcess(TMktActivity tMktActivity, String couponList, List<String> mbrMemberCodeList) {
        SendActivityBO sendActivityBO = new SendActivityBO();
        sendActivityBO.setActivityNo(tMktActivity.getActivityNo());
        sendActivityBO.setMktActivityCode(tMktActivity.getMktActivityCode());
        sendActivityBO.setIntegral(tMktActivity.getIntegral());
        sendActivityBO.setCouponCodeList(couponList);
        this.apiMktActivityCommonService.sendActivityBenefit(sendActivityBO, mbrMemberCodeList);
    }
}

