/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bizvane.mktcenter.api.domain.bo.OrderConsumerBO;
import com.bizvane.mktcenter.api.domain.bo.SendActivityBO;
import com.bizvane.mktcenter.api.service.ApiMktActivityCommonService;
import com.bizvane.mktcenter.domain.domain.po.TMktActivity;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityCoupon;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityOrder;
import com.bizvane.mktcenter.domain.service.TMktActivityCouponService;
import com.bizvane.mktcenter.domain.service.TMktActivityOrderService;
import com.bizvane.mktcenter.domain.service.TMktActivityService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RocketMQMessageListener(topic="rocketmq_topic_order", tags={"rocketmq_tag_order"})
public class OrderConsumer
implements RocketMQListener<OrderConsumerBO> {
    private static final Logger log = LoggerFactory.getLogger(OrderConsumer.class);
    @Autowired
    private TMktActivityOrderService mktActivityOrderService;
    @Autowired
    private TMktActivityService tMktActivityService;
    @Autowired
    private ApiMktActivityCommonService apiMktActivityCommonService;
    @Autowired
    private TMktActivityCouponService tMktActivityCouponService;

    public void onMessage(ConsumerMessage<OrderConsumerBO> message) {
        log.info("OrderConsumer onMessage: {}", (Object)JacksonUtil.bean2Json(message));
        OrderConsumerBO orderConsumerBO = (OrderConsumerBO)message.getMessage();
        String orderCode = orderConsumerBO.getOrderCode();
        ArrayList memberGroupCodeList = new ArrayList();
        String merchantCode = orderConsumerBO.getMerchantCode();
        String businessCode = "";
        String airportCode = "";
        LambdaQueryWrapper tMktActivityLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)tMktActivityLambdaQueryWrapper.lt(TMktActivity::getStartTime, (Object)new Date())).gt(TMktActivity::getEndTime, (Object)new Date())).eq(TMktActivity::getActivityType, (Object)4)).eq(TMktActivity::getValid, (Object)1);
        tMktActivityLambdaQueryWrapper.and(wrapper -> {
            wrapper.eq(TMktActivity::getMbrConditionType, (Object)1);
            if (CollUtil.isNotEmpty((Collection)memberGroupCodeList)) {
                for (String groupCode : memberGroupCodeList) {
                    ((LambdaQueryWrapper)wrapper.or()).like(TMktActivity::getMbrGroupDefCode, (Object)groupCode);
                }
            }
        });
        List tMktActivityList = this.tMktActivityService.list((Wrapper)tMktActivityLambdaQueryWrapper);
        log.info("tMktActivityList:{}", (Object)JacksonUtil.list2Json((List)tMktActivityList));
        if (CollUtil.isNotEmpty((Collection)tMktActivityList)) {
            HashMap activityCouponMap;
            Map activityMap = tMktActivityList.stream().collect(Collectors.toMap(TMktActivity::getMktActivityCode, Function.identity()));
            List mktActivityCodeList = tMktActivityList.stream().map(TMktActivity::getMktActivityCode).collect(Collectors.toList());
            List tMktActivityOrderList = this.mktActivityOrderService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityOrder::getValid, (Object)1)).in(TMktActivityOrder::getMktActivityCode, mktActivityCodeList)).eq(TMktActivityOrder::getFirstOrder, (Object)orderConsumerBO.getFirstOrder())).gt(TMktActivityOrder::getMinOrderAmount, (Object)orderConsumerBO.getOrderAmount())).lt(TMktActivityOrder::getMaxOrderAmount, (Object)orderConsumerBO.getOrderAmount())).gt(TMktActivityOrder::getMinOrderDiscount, (Object)orderConsumerBO.getOrderDiscountRate())).lt(TMktActivityOrder::getMaxOrderDiscount, (Object)orderConsumerBO.getOrderDiscountRate())).like(TMktActivityOrder::getConsumeChannelCode, (Object)orderConsumerBO.getConsumeChannelCode()));
            log.info("tMktActivityOrderList:{}", (Object)JacksonUtil.list2Json((List)tMktActivityOrderList));
            List activityCouponList = this.tMktActivityCouponService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivityCoupon.class).in(TMktActivityCoupon::getMktActivityCode, mktActivityCodeList)).eq(TMktActivityCoupon::getValid, (Object)1));
            Map<Object, Object> map = activityCouponMap = CollUtil.isNotEmpty((Collection)activityCouponList) ? activityCouponList.stream().collect(Collectors.groupingBy(TMktActivityCoupon::getMktActivityCode)) : new HashMap();
            if (CollUtil.isNotEmpty((Collection)tMktActivityOrderList)) {
                tMktActivityOrderList.forEach(item -> {
                    String mktActivityCode = item.getMktActivityCode();
                    Integer activityOrderLimitType = item.getOrderLimitType();
                    String activityAirportLimit = item.getAirportLimit();
                    String activityBusinessCode = item.getBusinessCode();
                    String activityMerchantCode = item.getMerchantCode();
                    if (activityOrderLimitType == 0 || activityOrderLimitType == 1 && StrUtil.isNotBlank((CharSequence)activityAirportLimit) && CollUtil.contains(Arrays.asList(activityBusinessCode.split(",")), (Object)businessCode) || activityOrderLimitType == 2 && StrUtil.isNotBlank((CharSequence)activityMerchantCode) && CollUtil.contains(Arrays.asList(activityMerchantCode.split(",")), (Object)merchantCode)) {
                        TMktActivity tMktActivity = (TMktActivity)activityMap.get(mktActivityCode);
                        SendActivityBO sendActivityBO = new SendActivityBO();
                        sendActivityBO.setActivityNo(tMktActivity.getActivityNo());
                        sendActivityBO.setMktActivityCode(tMktActivity.getMktActivityCode());
                        sendActivityBO.setIntegral(tMktActivity.getIntegral());
                        List tMktActivityCoupons = (List)activityCouponMap.get(mktActivityCode);
                        if (CollUtil.isNotEmpty((Collection)tMktActivityCoupons)) {
                            sendActivityBO.setCouponCodeList(tMktActivityCoupons.stream().map(TMktActivityCoupon::getCouponCode).collect(Collectors.joining(",")));
                        }
                        sendActivityBO.setBusinessCode(orderCode);
                        ResponseData sentActivityResp = this.apiMktActivityCommonService.sendActivityBenefit(sendActivityBO, Arrays.asList(orderConsumerBO.getMbrMemberCode()));
                        log.info("sentActivityResp:{}", (Object)JacksonUtil.bean2Json((Object)sentActivityResp));
                    }
                });
            }
        }
    }
}

