/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bizvane.mktcenter.api.domain.bo.SendTaskBO;
import com.bizvane.mktcenter.api.service.ApiMktCommonService;
import com.bizvane.mktcenter.api.service.ApiMktTaskCommonService;
import com.bizvane.mktcenter.domain.domain.po.TMktTask;
import com.bizvane.mktcenter.domain.domain.po.TMktTaskCoupon;
import com.bizvane.mktcenter.domain.domain.po.TMktTaskImproveProfile;
import com.bizvane.mktcenter.domain.domain.po.TMktTaskSendRecord;
import com.bizvane.mktcenter.domain.service.TMktTaskCouponService;
import com.bizvane.mktcenter.domain.service.TMktTaskImproveProfileService;
import com.bizvane.mktcenter.domain.service.TMktTaskSendRecordService;
import com.bizvane.mktcenter.domain.service.TMktTaskService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RocketMQMessageListener(topic="rocketmq_topic_order", tags={"rocketmq_tag_order"})
public class MbrImproveProfileConsumer
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(MbrImproveProfileConsumer.class);
    @Autowired
    private TMktTaskImproveProfileService tMktTaskImproveProfileService;
    @Autowired
    private TMktTaskService tMktTaskService;
    @Autowired
    private TMktTaskSendRecordService tMktTaskSendRecordService;
    @Autowired
    private ApiMktTaskCommonService apiMktTaskCommonService;
    @Autowired
    private TMktTaskCouponService tMktTaskCouponService;
    @Autowired
    private ApiMktCommonService apiMktCommonService;

    public void onMessage(ConsumerMessage<String> message) {
        log.info("MbrImproveProfileConsumer onMessage: {}", (Object)JacksonUtil.bean2Json(message));
        String mbrMemberCode = (String)message.getMessage();
        ArrayList mbrProfileList = new ArrayList();
        if (CollUtil.isEmpty(mbrProfileList)) {
            log.info("\u4f1a\u5458\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u5b8c\u5584\u8d44\u6599\u4efb\u52a1");
            return;
        }
        List tMktTaskList = this.tMktTaskService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getValid, (Object)1)).eq(TMktTask::getTaskType, (Object)2)).eq(TMktTask::getCheckStatus, (Object)3)).eq(TMktTask::getTaskStatus, (Object)2));
        log.info("tMktTaskList: {}", (Object)JacksonUtil.list2Json((List)tMktTaskList));
        if (CollUtil.isEmpty((Collection)tMktTaskList)) {
            log.info("\u6ca1\u6709\u8fdb\u884c\u4e2d\u7684\u5b8c\u5584\u8d44\u6599\u4efb\u52a1");
            return;
        }
        List mktTaskCodeList = tMktTaskList.stream().map(TMktTask::getMktTaskCode).collect(Collectors.toList());
        List tMktTaskSendRecordList = this.tMktTaskSendRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTaskSendRecord::getValid, (Object)1)).eq(TMktTaskSendRecord::getMbrMembersCode, (Object)mbrMemberCode)).in(TMktTaskSendRecord::getMktTaskCode, mktTaskCodeList));
        log.info("tMktTaskSendRecordList: {}", (Object)JacksonUtil.list2Json((List)tMktTaskSendRecordList));
        List joinedMktTaskCodeList = Optional.ofNullable(tMktTaskSendRecordList).map(list -> list.stream().map(TMktTaskSendRecord::getMktTaskCode).collect(Collectors.toList())).orElse(new ArrayList());
        mktTaskCodeList = mktTaskCodeList.stream().filter(item -> !joinedMktTaskCodeList.contains(item)).collect(Collectors.toList());
        tMktTaskList = tMktTaskList.stream().filter(item -> !joinedMktTaskCodeList.contains(item.getMktTaskCode())).collect(Collectors.toList());
        List improveProfileList = this.tMktTaskImproveProfileService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTaskImproveProfile::getValid, (Object)1)).in(TMktTaskImproveProfile::getMktTaskCode, mktTaskCodeList));
        log.info("improveProfileList: {}", (Object)JacksonUtil.list2Json((List)improveProfileList));
        Map improveProfileMap = improveProfileList.stream().collect(Collectors.toMap(TMktTaskImproveProfile::getMktTaskCode, Function.identity()));
        for (TMktTask tMktTask : tMktTaskList) {
            String mktTaskCode = tMktTask.getMktTaskCode();
            TMktTaskImproveProfile tMktTaskImproveProfile = (TMktTaskImproveProfile)improveProfileMap.get(mktTaskCode);
            String improveProfileOptions = tMktTaskImproveProfile.getImproveProfileOptions();
            if (StrUtil.isBlank((CharSequence)improveProfileOptions) || !CollUtil.containsAll(mbrProfileList, Arrays.asList(improveProfileOptions.split(",")))) {
                log.info("\u4f1a\u5458\u4fe1\u606f\u4e0d\u6ee1\u8db3\u5b8c\u5584\u8d44\u6599\u4efb\u52a1\u6761\u4ef6\uff0cmbrMemberCode: {}, mktTaskCode: {}", (Object)mbrMemberCode, (Object)mktTaskCode);
                return;
            }
            List activityCouponList = this.tMktTaskCouponService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktTaskCoupon.class).in(TMktTaskCoupon::getMktTaskCode, mktTaskCodeList)).eq(TMktTaskCoupon::getValid, (Object)1));
            String couponCodeList = Optional.ofNullable(activityCouponList).map(list -> list.stream().map(TMktTaskCoupon::getCouponCode).collect(Collectors.joining(","))).orElse(null);
            SendTaskBO sendTaskBO = new SendTaskBO();
            sendTaskBO.setTaskType(tMktTask.getTaskType());
            sendTaskBO.setTaskNo(tMktTask.getTaskNo());
            sendTaskBO.setMktTaskCode(tMktTask.getMktTaskCode());
            sendTaskBO.setBusinessCode(tMktTask.getMktTaskCode());
            sendTaskBO.setIntegral(tMktTask.getIntegral());
            sendTaskBO.setCouponCodeList(couponCodeList);
            this.apiMktTaskCommonService.sendTaskBenefit(sendTaskBO, Arrays.asList(mbrMemberCode));
        }
    }
}

