/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl.mobile;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bizvane.mktcenter.api.controller.req.MobilePointsLotteryReqVO;
import com.bizvane.mktcenter.api.service.MobileActivityPointLotteryService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMktActivity;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityPointsLottery;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityPointsLotteryPrizeRecord;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityPointsLotteryRecord;
import com.bizvane.mktcenter.domain.service.TMktActivityPointsLotteryRecordService;
import com.bizvane.mktcenter.domain.service.TMktActivityPointsLotteryService;
import com.bizvane.mktcenter.domain.service.TMktActivityService;
import com.bizvane.mktcenter.feign.vo.req.ActivityPointLotteryReceivePrizeReqVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MobileActivityPointLotteryServiceImpl
implements MobileActivityPointLotteryService {
    private static final Logger log = LoggerFactory.getLogger(MobileActivityPointLotteryServiceImpl.class);
    @Autowired
    private TMktActivityPointsLotteryService activityPointsLotteryService;
    @Autowired
    private TMktActivityPointsLotteryRecordService pointsLotteryRecordService;
    @Autowired
    private TMktActivityService tMktActivityService;

    @Override
    public ResponseData<String> joinPointLottery(MobilePointsLotteryReqVO reqVO) {
        int joinCount;
        log.info("joinPointLottery reqVO:{}", (Object)JacksonUtil.bean2Json((Object)reqVO));
        String mktActivityCode = reqVO.getMktActivityCode();
        TMktActivity tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivity.class).eq(TMktActivity::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivity::getActivityStatus, (Object)2)).eq(TMktActivity::getCheckStatus, (Object)3)).eq(TMktActivity::getActivityType, (Object)7)).eq(TMktActivity::getValid, (Object)1));
        if (tMktActivity == null) {
            return ResponseUtil.getFailedMsg("\u79ef\u5206\u593a\u5b9d\u6d3b\u52a8\u65e0\u6548\u6216\u4e0d\u5b58\u5728");
        }
        TMktActivityPointsLottery tMktActivityPointsLottery = (TMktActivityPointsLottery)this.activityPointsLotteryService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityPointsLottery::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityPointsLottery::getValid, (Object)1));
        if (tMktActivityPointsLottery == null) {
            return ResponseUtil.getFailedMsg("\u79ef\u5206\u593a\u5b9d\u6d3b\u52a8\u65e0\u6548\u6216\u4e0d\u5b58\u5728");
        }
        String mbrMemberCode = reqVO.getMbrMemberCode();
        Integer mbrConditionType = tMktActivity.getMbrConditionType();
        if (ObjUtil.equals((Object)2, (Object)mbrConditionType)) {
            // empty if block
        }
        if ((joinCount = this.pointsLotteryRecordService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityPointsLotteryRecord::getMbrMembersCode, (Object)mbrMemberCode)).eq(TMktActivityPointsLotteryRecord::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityPointsLotteryRecord::getValid, (Object)1))) >= tMktActivityPointsLottery.getMaxPerPersonParticipationNum()) {
            return ResponseUtil.getFailedMsg("\u6bcf\u4eba\u6700\u591a\u53c2\u4e0e\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650");
        }
        Integer consumePoints = tMktActivityPointsLottery.getConsumePoints();
        TMktActivityPointsLotteryRecord record = new TMktActivityPointsLotteryRecord();
        record.setMktActivityPointsLotteryRecordCode(IdUtil.fastSimpleUUID());
        record.setMktActivityCode(reqVO.getMktActivityCode());
        record.setMbrMembersCode(reqVO.getMbrMemberCode());
        record.setMktActivityPointsLotteryCode(tMktActivityPointsLottery.getMktActivityPointsLotteryCode());
        record.setCustomeIntegral(consumePoints);
        record.setWinState(Integer.valueOf(0));
        record.setReturnState(Integer.valueOf(0));
        record.setValid(Integer.valueOf(1));
        this.pointsLotteryRecordService.save((Object)record);
        return ResponseUtil.getSuccessData("\u53c2\u4e0e\u6210\u529f");
    }

    @Override
    public ResponseData<String> receivePrize(ActivityPointLotteryReceivePrizeReqVO reqVO) {
        String mktActivityPointsLotteryRecordCode = reqVO.getMktActivityPointsLotteryRecordCode();
        String mbrMemberCode = reqVO.getMbrMemberCode();
        TMktActivityPointsLotteryRecord record = (TMktActivityPointsLotteryRecord)this.pointsLotteryRecordService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityPointsLotteryRecord::getMktActivityPointsLotteryRecordCode, (Object)mktActivityPointsLotteryRecordCode)).eq(TMktActivityPointsLotteryRecord::getMbrMembersCode, (Object)mbrMemberCode)).eq(TMktActivityPointsLotteryRecord::getValid, (Object)1));
        if (record == null) {
            return ResponseUtil.getFailedMsg("\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (record.getWinState() != 2) {
            return ResponseUtil.getFailedMsg("\u672a\u4e2d\u5956");
        }
        record.setWinState(Integer.valueOf(3));
        this.pointsLotteryRecordService.updateById((Object)record);
        TMktActivityPointsLotteryPrizeRecord prizeRecord = new TMktActivityPointsLotteryPrizeRecord();
        prizeRecord.setMktActivityPointsLotteryRecordPrizeCode(IdUtil.fastSimpleUUID());
        prizeRecord.setMktActivityPointsLotteryRecordCode(mktActivityPointsLotteryRecordCode);
        prizeRecord.setMktActivityPointsLotteryCode(record.getMktActivityPointsLotteryCode());
        prizeRecord.setMktActivityCode(record.getMktActivityCode());
        prizeRecord.setMbrMembersCode(mbrMemberCode);
        prizeRecord.setConsigneeName(reqVO.getConsigneeName());
        prizeRecord.setConsigneePhone(reqVO.getConsigneePhone());
        prizeRecord.setConsigneeAddress(reqVO.getConsigneeAddress());
        prizeRecord.setReceiveTime(new Date());
        prizeRecord.setValid(Integer.valueOf(1));
        return ResponseUtil.getSuccessData("\u9886\u5956\u6210\u529f");
    }
}

