/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl.mobile;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bizvane.mktcenter.api.controller.req.MbrReceiveCouponReqVO;
import com.bizvane.mktcenter.api.service.MobileActivityManualService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMktActivity;
import com.bizvane.mktcenter.domain.domain.po.TMktActivityManual;
import com.bizvane.mktcenter.domain.domain.po.TMktActivitySendRecord;
import com.bizvane.mktcenter.domain.service.TMktActivityManualService;
import com.bizvane.mktcenter.domain.service.TMktActivitySendRecordService;
import com.bizvane.mktcenter.domain.service.TMktActivityService;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MobileActivityManualServiceImpl
implements MobileActivityManualService {
    private static final Logger log = LoggerFactory.getLogger(MobileActivityManualServiceImpl.class);
    @Autowired
    private TMktActivityManualService tMktActivityManualService;
    @Autowired
    private TMktActivityService tMktActivityService;
    @Autowired
    private TMktActivitySendRecordService tMktActivitySendRecordService;

    @Override
    public ResponseData<String> receiveCoupon(MbrReceiveCouponReqVO reqVO) {
        int count;
        String couponCode = reqVO.getCouponCode();
        String mktActivityCode = reqVO.getMktActivityCode();
        String mbrMemberCode = reqVO.getMbrMemberCode();
        TMktActivity tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivity::getActivityStatus, (Object)2)).eq(TMktActivity::getCheckStatus, (Object)3)).eq(TMktActivity::getValid, (Object)1));
        if (tMktActivity == null) {
            return ResponseUtil.getFailedMsg("\u6d3b\u52a8\u65e0\u6548");
        }
        String couponCodeList = tMktActivity.getCouponCodeList();
        if (StrUtil.isBlank((CharSequence)couponCodeList) || !Arrays.asList(couponCodeList.split(",")).contains(couponCode)) {
            return ResponseUtil.getFailedMsg("\u6d3b\u52a8\u4e0d\u5305\u542b\u6b64\u4f18\u60e0\u5238");
        }
        TMktActivityManual tMktActivityManual = (TMktActivityManual)this.tMktActivityManualService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivityManual::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivityManual::getValid, (Object)1));
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivitySendRecord.class).eq(TMktActivitySendRecord::getMbrMembersCode, (Object)mbrMemberCode)).eq(TMktActivitySendRecord::getSendDate, (Object)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")))).eq(TMktActivitySendRecord::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivitySendRecord::getValid, (Object)1);
        Integer perPersonPerDayMaxType = tMktActivityManual.getPerPersonPerDayMaxType();
        Integer perPersonPerDayMax = tMktActivityManual.getPerPersonPerDayMax();
        if (perPersonPerDayMaxType == 1) {
            queryWrapper.eq(TMktActivitySendRecord::getCouponCodeList, (Object)couponCode);
        }
        if ((count = this.tMktActivitySendRecordService.count((Wrapper)queryWrapper)) >= perPersonPerDayMax) {
            return ResponseUtil.getFailedMsg("\u6bcf\u4eba\u6bcf\u65e5\u9886\u53d6\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650");
        }
        queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivitySendRecord.class).eq(TMktActivitySendRecord::getMbrMembersCode, (Object)mbrMemberCode)).eq(TMktActivitySendRecord::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivitySendRecord::getValid, (Object)1);
        Integer perPersonMaxType = tMktActivityManual.getPerPersonMaxType();
        Integer perPersonMax = tMktActivityManual.getPerPersonMax();
        if (perPersonMaxType == 1) {
            queryWrapper.eq(TMktActivitySendRecord::getCouponCodeList, (Object)couponCode);
        }
        if ((count = this.tMktActivitySendRecordService.count((Wrapper)queryWrapper)) >= perPersonMax) {
            return ResponseUtil.getFailedMsg("\u6bcf\u4eba\u9886\u53d6\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650");
        }
        Integer totalNumType = tMktActivityManual.getTotalNumType();
        Integer totalNum = tMktActivityManual.getTotalNum();
        queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivitySendRecord.class).eq(TMktActivitySendRecord::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivitySendRecord::getValid, (Object)1);
        if (totalNumType == 2) {
            queryWrapper.eq(TMktActivitySendRecord::getCouponCodeList, (Object)couponCode);
        }
        if ((count = this.tMktActivitySendRecordService.count((Wrapper)queryWrapper)) >= totalNum) {
            return ResponseUtil.getFailedMsg("\u6d3b\u52a8\u53d1\u5238\u5f20\u6570\u5df2\u8fbe\u4e0a\u9650");
        }
        TMktActivitySendRecord tMktActivitySendRecord = new TMktActivitySendRecord();
        tMktActivitySendRecord.setMktActivityCode(mktActivityCode);
        tMktActivitySendRecord.setMbrMembersCode(mbrMemberCode);
        tMktActivitySendRecord.setCouponCodeList(couponCode);
        tMktActivitySendRecord.setSendDate(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        tMktActivitySendRecord.setValid(Integer.valueOf(1));
        this.tMktActivitySendRecordService.save((Object)tMktActivitySendRecord);
        return ResponseUtil.getSuccessData("\u9886\u53d6\u6210\u529f");
    }
}

